/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.files.Utils;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadKeyStore(String keyStore, String password) {
        try (InputStream is = Utils.getFile(new File(keyStore)).openStream();){
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(is, password.toCharArray());
            KeyStore keyStore2 = trustStore;
            return keyStore2;
        }
        catch (Exception e) {
            String error = "Unable to load trust store";
            LOGGER.error(error, (Throwable)e);
            throw new InternalReportPortalClientException(error, e);
        }
    }
}

