/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.io.ByteSource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class LoggingContext {
    public static final int DEFAULT_LOG_BATCH_SIZE = 10;
    @Deprecated
    public static final int DEFAULT_BUFFER_SIZE = 10;
    private static final ThreadLocal<Pair<Long, Deque<LoggingContext>>> CONTEXT_THREAD_LOCAL = new InheritableThreadLocal<Pair<Long, Deque<LoggingContext>>>();
    private static final Set<Long> THREAD_IDS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final Maybe<String> itemUuid;
    private final boolean convertImages;

    @Nonnull
    private static Deque<LoggingContext> createContext() {
        Long threadKey = Thread.currentThread().getId();
        if (!THREAD_IDS.contains(threadKey) || CONTEXT_THREAD_LOCAL.get() == null) {
            ArrayDeque<LoggingContext> context = new ArrayDeque<LoggingContext>();
            CONTEXT_THREAD_LOCAL.set((Pair<Long, Deque<LoggingContext>>)Pair.of((Object)threadKey, context));
            THREAD_IDS.add(threadKey);
            return context;
        }
        return (Deque)CONTEXT_THREAD_LOCAL.get().getValue();
    }

    @Nullable
    private static Deque<LoggingContext> getContext() {
        Long threadKey = Thread.currentThread().getId();
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).filter(ctx -> threadKey.equals(ctx.getKey())).map(Pair::getValue).orElse(null);
    }

    @Nullable
    public static LoggingContext context() {
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).map(Pair::getValue).map(Deque::peek).orElse(null);
    }

    @Nonnull
    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        LoggingContext context = new LoggingContext(launchUuid, itemUuid, client, scheduler, parameters);
        LoggingContext.createContext().push(context);
        return context;
    }

    @Nonnull
    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, int batchLogsSize, boolean convertImages) {
        ListenerParameters params = new ListenerParameters();
        params.setBatchLogsSize(batchLogsSize);
        params.setConvertImage(convertImages);
        return LoggingContext.init(launchUuid, itemUuid, client, scheduler, params);
    }

    @Nonnull
    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler) {
        return LoggingContext.init(launchUuid, itemUuid, client, scheduler, 10, false);
    }

    @Nonnull
    public static Completable complete() {
        LoggingContext loggingContext = Optional.ofNullable(LoggingContext.getContext()).map(Deque::poll).orElse(null);
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    LoggingContext(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        this.launchUuid = launchUuid;
        this.itemUuid = itemUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = parameters.isConvertImage();
        new FlowableFromObservable(this.emitter).flatMap(Maybe::toFlowable).buffer(parameters.getBatchLogsSize().intValue()).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable()).doOnError(LoggingCallback.LOG_ERROR).observeOn(scheduler).onBackpressureBuffer(parameters.getRxBufferSize(), false, true).subscribe(SubscriptionUtils.logFlowableResults("Logging context"));
    }

    private SaveLogRQ prepareRequest(String launchId, String itemId, Function<String, SaveLogRQ> logSupplier) throws IOException {
        SaveLogRQ rq = logSupplier.apply(itemId);
        rq.setLaunchUuid(launchId);
        SaveLogRQ.File file = rq.getFile();
        if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
            TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap((byte[])file.getContent()));
            file.setContent(source.read());
            file.setContentType(source.getMediaType());
        }
        return rq;
    }

    public void emit(Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.zipWith(this.itemUuid, (launchId, itemId) -> this.prepareRequest((String)launchId, (String)itemId, logSupplier)));
    }

    public void emit(Maybe<String> logItemUuid, Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.zipWith(logItemUuid, (launchId, itemId) -> this.prepareRequest((String)launchId, (String)itemId, logSupplier)));
    }

    @Nonnull
    public Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

