/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class PathParamInterceptor
implements Interceptor {
    private static final String PARAMETER_PATTERN = "{%s}";
    private final String key;
    private final String value;

    public PathParamInterceptor(String replaceKey, String replaceValue) {
        this.key = String.format(PARAMETER_PATTERN, replaceKey);
        this.value = replaceValue;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        List segments = originalRequest.url().pathSegments();
        HttpUrl.Builder urlBuilder = originalRequest.url().newBuilder();
        IntStream.range(0, segments.size()).forEach(i -> {
            String s = (String)segments.get(i);
            if (s.contains(this.key)) {
                urlBuilder.setPathSegment(i, s.replace(this.key, this.value));
            }
        });
        Request request = originalRequest.newBuilder().url(urlBuilder.build()).build();
        return chain.proceed(request);
    }
}

