/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.utils.templating.TemplateConfiguration;
import com.epam.reportportal.utils.templating.TemplateProcessing;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class StepNameUtils {
    private StepNameUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String getStepName(@Nonnull Step step, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        String nameTemplate = step.value();
        if (nameTemplate.trim().isEmpty()) {
            return signature.getMethod().getName();
        }
        TemplateConfiguration defaultConfig = new TemplateConfiguration();
        TemplateConfiguration deprecatedConfig = new TemplateConfiguration(step.templateConfig());
        TemplateConfiguration config = new TemplateConfiguration(step.config());
        if (!deprecatedConfig.equals(defaultConfig) && config.equals(defaultConfig)) {
            config = deprecatedConfig;
        }
        return StepNameUtils.getStepName(nameTemplate, config, signature, joinPoint);
    }

    @Nonnull
    public static String getStepName(@Nonnull String nameTemplate, @Nonnull TemplateConfiguration config, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        Map<String, Object> parametersMap = StepNameUtils.createParamsMapping(config, signature, joinPoint);
        return TemplateProcessing.processTemplate(nameTemplate, parametersMap, config);
    }

    @Nonnull
    static Map<String, Object> createParamsMapping(@Nonnull TemplateConfiguration templateConfig, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        String[] parameterNames = signature.getParameterNames();
        int paramsCount = Math.min(Optional.ofNullable(parameterNames).map(p -> ((String[])p).length).orElse(0), Optional.ofNullable(args).map(a -> ((Object[])a).length).orElse(0));
        HashMap<String, Object> paramsMapping = new HashMap<String, Object>();
        Optional.ofNullable(signature.getMethod()).ifPresent(method -> {
            paramsMapping.put(templateConfig.getMethodName(), method.getName());
            Class<?> clazz = method.getDeclaringClass();
            paramsMapping.put(templateConfig.getClassName(), clazz.getSimpleName());
            paramsMapping.put(templateConfig.getClassRef(), clazz.getName());
        });
        Optional.ofNullable(joinPoint.getThis()).ifPresent(current -> paramsMapping.put(templateConfig.getSelfName(), current));
        for (int i = 0; i < paramsCount; ++i) {
            paramsMapping.put(parameterNames[i], args[i]);
            paramsMapping.put(Integer.toString(i), args[i]);
        }
        return paramsMapping;
    }
}

