/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.step;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.reportportal.service.step.StepRequestUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.files.Utils;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.base.Throwables;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStepReporter
implements StepReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStepReporter.class);
    private final ThreadLocal<Deque<Maybe<String>>> stepStack = new InheritableThreadLocal<Deque<Maybe<String>>>(){

        @Override
        protected Deque<Maybe<String>> initialValue() {
            return new ConcurrentLinkedDeque<Maybe<String>>();
        }
    };
    private final ThreadLocal<Deque<StepReporter.StepEntry>> steps = new InheritableThreadLocal<Deque<StepReporter.StepEntry>>(){

        @Override
        protected Deque<StepReporter.StepEntry> initialValue() {
            return new ConcurrentLinkedDeque<StepReporter.StepEntry>();
        }
    };
    private final Set<Maybe<String>> parentFailures = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Launch launch;

    public DefaultStepReporter(Launch currentLaunch) {
        this.launch = currentLaunch;
    }

    @Override
    public void setParent(@Nullable Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.stepStack.get().add(parentUuid);
        }
    }

    @Override
    @Nullable
    public Maybe<String> getParent() {
        return this.stepStack.get().peekLast();
    }

    @Override
    public void removeParent(@Nullable Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.stepStack.get().removeLastOccurrence(parentUuid);
            this.parentFailures.remove(parentUuid);
        }
    }

    @Override
    public boolean isFailed(@Nullable Maybe<String> parentId) {
        if (parentId != null) {
            return this.parentFailures.contains(parentId);
        }
        return false;
    }

    protected void sendStep(@Nonnull ItemStatus status, @Nonnull String name, @Nullable Runnable actions) {
        StartTestItemRQ rq = this.buildStartStepRequest(name);
        Maybe<String> stepId = this.startStepRequest(rq);
        if (actions != null) {
            try {
                actions.run();
            }
            catch (Throwable e) {
                LOGGER.error("Unable to process nested step: " + e.getLocalizedMessage(), e);
            }
        }
        this.finishStepRequest(stepId, status, rq.getStartTime());
    }

    @Override
    public void sendStep(@Nonnull String name) {
        this.sendStep(ItemStatus.PASSED, name, () -> {});
    }

    @Override
    public void sendStep(@Nonnull String name, String ... logs) {
        this.sendStep(ItemStatus.PASSED, name, logs);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, @Nonnull String name) {
        this.sendStep(status, name, () -> {});
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, @Nonnull String name, String ... logs) {
        Runnable actions = Optional.ofNullable(logs).map(l -> () -> Arrays.stream(l).forEach(log -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, (String)log, LogLevel.INFO)))).orElse(null);
        this.sendStep(status, name, actions);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, @Nonnull String name, Throwable throwable) {
        this.sendStep(status, name, () -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable)));
    }

    @Override
    public void sendStep(@Nonnull String name, File ... files) {
        this.sendStep(ItemStatus.PASSED, name, files);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, @Nonnull String name, File ... files) {
        Runnable actions = Optional.ofNullable(files).map(f -> () -> Arrays.stream(f).forEach(file -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, "", LogLevel.INFO, (File)file)))).orElse(null);
        this.sendStep(status, name, actions);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, @Nonnull String name, Throwable throwable, File ... files) {
        this.sendStep(status, name, () -> {
            for (File file : files) {
                ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable, file));
            }
        });
    }

    private Optional<StepReporter.StepEntry> finishPreviousStepInternal(@Nullable ItemStatus finishStatus) {
        return Optional.ofNullable(this.steps.get().pollLast()).map(stepEntry -> {
            FinishTestItemRQ finishRq = stepEntry.getFinishTestItemRQ();
            ItemStatus status = StatusEvaluation.evaluateStatus(ItemStatus.valueOf(finishRq.getStatus()), finishStatus);
            Optional.ofNullable(status).ifPresent(s -> finishRq.setStatus(s.name()));
            this.launch.finishTestItem(stepEntry.getItemId(), finishRq);
            return stepEntry;
        });
    }

    @Override
    public void finishPreviousStep(@Nullable ItemStatus status) {
        this.finishPreviousStepInternal(status).ifPresent(e -> {
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.parentFailures.addAll((Collection<Maybe<String>>)this.stepStack.get());
            }
        });
    }

    @Override
    public void finishPreviousStep() {
        this.finishPreviousStep(ItemStatus.PASSED);
    }

    @Override
    @Nonnull
    public Maybe<String> startNestedStep(@Nonnull StartTestItemRQ startStepRequest) {
        Maybe<String> parent = this.getParent();
        if (parent == null) {
            LOGGER.warn("Unable to find parent ID, skipping step: " + startStepRequest.getName());
            return Maybe.empty();
        }
        return this.launch.startTestItem(parent, startStepRequest);
    }

    @Override
    public void finishNestedStep(@Nonnull FinishTestItemRQ finishStepRequest) {
        Maybe<String> stepId = this.getParent();
        if (stepId == null) {
            LOGGER.warn("Unable to find item ID, skipping step a finish step");
            return;
        }
        this.launch.finishTestItem(stepId, finishStepRequest);
    }

    @Override
    public void finishNestedStep() {
        FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishTestItemRequest(ItemStatus.PASSED);
        this.finishNestedStep(finishStepRequest);
    }

    @Override
    public void finishNestedStep(@Nullable Throwable throwable) {
        ReportPortal.emitLog(itemUuid -> this.buildSaveLogRequest((String)itemUuid, throwable));
        FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishTestItemRequest(ItemStatus.FAILED);
        this.finishNestedStep(finishStepRequest);
    }

    @Override
    public void step(@Nonnull String name) {
        this.startNestedStep(this.buildStartStepRequest(name));
        this.finishNestedStep(StepRequestUtils.buildFinishTestItemRequest(ItemStatus.PASSED));
    }

    @Override
    public void step(@Nonnull ItemStatus status, @Nonnull String name) {
        this.startNestedStep(this.buildStartStepRequest(name));
        this.finishNestedStep(StepRequestUtils.buildFinishTestItemRequest(status));
    }

    @Override
    @Nullable
    public <T> T step(@Nonnull String name, @Nonnull Supplier<T> actions) {
        this.startNestedStep(this.buildStartStepRequest(name));
        try {
            T result = actions.get();
            this.finishNestedStep(StepRequestUtils.buildFinishTestItemRequest(ItemStatus.PASSED));
            return result;
        }
        catch (Error | RuntimeException e) {
            ReportPortal.emitLog(itemUuid -> this.buildSaveLogRequest((String)itemUuid, e));
            this.finishNestedStep(StepRequestUtils.buildFinishTestItemRequest(ItemStatus.FAILED));
            throw e;
        }
    }

    private Maybe<String> startStepRequest(StartTestItemRQ startTestItemRQ) {
        this.finishPreviousStepInternal(ItemStatus.PASSED).ifPresent(e -> {
            Date currentDate;
            Date previousDate = e.getTimestamp();
            if (!previousDate.before(currentDate = startTestItemRQ.getStartTime())) {
                startTestItemRQ.setStartTime(new Date(previousDate.getTime() + 1L));
            }
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.parentFailures.addAll((Collection<Maybe<String>>)this.stepStack.get());
            }
        });
        return this.startNestedStep(startTestItemRQ);
    }

    private StartTestItemRQ buildStartStepRequest(@Nonnull String name) {
        StartTestItemRQ startTestItemRQ = new StartTestItemRQ();
        startTestItemRQ.setName(name);
        startTestItemRQ.setType("STEP");
        startTestItemRQ.setHasStats(false);
        startTestItemRQ.setStartTime(Calendar.getInstance().getTime());
        return startTestItemRQ;
    }

    private void finishStepRequest(Maybe<String> stepId, ItemStatus status, Date timestamp) {
        FinishTestItemRQ finishTestItemRQ = StepRequestUtils.buildFinishTestItemRequest(status);
        this.steps.get().add(new StepReporter.StepEntry(stepId, timestamp, finishTestItemRQ));
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level) {
        SaveLogRQ rq = new SaveLogRQ();
        rq.setItemUuid(itemId);
        rq.setMessage(message);
        rq.setLevel(level.name());
        rq.setLogTime(Calendar.getInstance().getTime());
        return rq;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level, File file) {
        SaveLogRQ logRQ = this.buildSaveLogRequest(itemId, message, level);
        if (file != null) {
            try {
                logRQ.setFile(this.createFileModel(file));
            }
            catch (IOException e) {
                LOGGER.error("Unable to read file attachment: " + e.getMessage(), (Throwable)e);
            }
        }
        return logRQ;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable, File file) {
        String message = throwable != null ? Throwables.getStackTraceAsString((Throwable)throwable) : "Test has failed without exception";
        return this.buildSaveLogRequest(itemId, message, LogLevel.ERROR, file);
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable) {
        return this.buildSaveLogRequest(itemId, throwable, null);
    }

    private SaveLogRQ.File createFileModel(File file) throws IOException {
        TypeAwareByteSource dataSource = Utils.getFile(file);
        SaveLogRQ.File fileModel = new SaveLogRQ.File();
        fileModel.setContent(dataSource.read());
        fileModel.setContentType(dataSource.getMediaType());
        fileModel.setName(UUID.randomUUID().toString());
        return fileModel;
    }
}

