/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.TestCaseIdKey;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestCaseIdUtils {
    private static final Function<List<?>, String> TRANSFORM_PARAMETERS = it -> it.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));

    private TestCaseIdUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String getCodeRef(@Nonnull Executable executable) {
        if (executable instanceof Constructor) {
            return executable.getName();
        }
        return executable.getDeclaringClass().getCanonicalName() + "." + executable.getName();
    }

    @Nullable
    public static <T> String getParametersForTestCaseId(Executable executable, List<T> parameters) {
        if (executable == null || parameters == null || parameters.isEmpty()) {
            return null;
        }
        Annotation[][] parameterAnnotations = executable.getParameterAnnotations();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int paramIndex = 0; paramIndex < parameterAnnotations.length; ++paramIndex) {
            for (int annotationIndex = 0; annotationIndex < parameterAnnotations[paramIndex].length; ++annotationIndex) {
                Annotation testCaseIdAnnotation = parameterAnnotations[paramIndex][annotationIndex];
                if (testCaseIdAnnotation.annotationType() != TestCaseIdKey.class) continue;
                keys.add(paramIndex);
            }
        }
        if (keys.isEmpty()) {
            return TRANSFORM_PARAMETERS.apply(parameters);
        }
        if (keys.size() <= 1) {
            return String.valueOf(parameters.get((Integer)keys.get(0)));
        }
        return TRANSFORM_PARAMETERS.apply(keys.stream().map(parameters::get).collect(Collectors.toList()));
    }

    @Nullable
    public static <T> TestCaseIdEntry getTestCaseId(@Nullable TestCaseId annotation, @Nullable Executable executable, @Nullable List<T> parameters) {
        return TestCaseIdUtils.getTestCaseId(annotation, executable, null, parameters);
    }

    @Nullable
    public static <T> TestCaseIdEntry getTestCaseId(@Nullable TestCaseId annotation, @Nullable Executable executable, @Nullable String codRef, @Nullable List<T> parameters) {
        if (annotation != null) {
            if (annotation.value().isEmpty()) {
                if (annotation.parametrized()) {
                    return Optional.ofNullable(TestCaseIdUtils.getParametersForTestCaseId(executable, parameters)).map(TestCaseIdEntry::new).orElse(Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(executable, parameters)));
                }
                return Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(executable, parameters));
            }
            if (annotation.parametrized()) {
                return Optional.ofNullable(TestCaseIdUtils.getParametersForTestCaseId(executable, parameters)).map(p -> new TestCaseIdEntry(annotation.value() + (p.startsWith("[") ? p : "[" + p + "]"))).orElse(Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(executable, parameters)));
            }
            return new TestCaseIdEntry(annotation.value());
        }
        return Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(executable, parameters));
    }

    @Nullable
    public static <T> TestCaseIdEntry getTestCaseId(@Nullable Executable executable, @Nullable List<T> parameters) {
        return Optional.ofNullable(executable).map(m -> TestCaseIdUtils.getTestCaseId(TestCaseIdUtils.getCodeRef(m), parameters)).orElse(TestCaseIdUtils.getTestCaseId(parameters));
    }

    @Nullable
    public static <T> TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<T> parameters) {
        return Optional.ofNullable(codeRef).map(r -> new TestCaseIdEntry(codeRef + Optional.ofNullable(parameters).map(TRANSFORM_PARAMETERS).orElse(""))).orElse(TestCaseIdUtils.getTestCaseId(parameters));
    }

    @Nullable
    public static <T> TestCaseIdEntry getTestCaseId(@Nullable List<T> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return new TestCaseIdEntry(TRANSFORM_PARAMETERS.apply(parameters));
    }
}

