/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import io.reactivex.CompletableObserver;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionUtils.class);

    public static <T> MaybeObserver<T> logMaybeResults(final String type) {
        return new MaybeObserver<T>(){

            public void onSubscribe(@Nonnull Disposable d) {
            }

            public void onSuccess(@Nonnull T Result) {
                LOGGER.debug("{} successfully completed", (Object)type);
            }

            public void onError(@Nonnull Throwable e) {
                LOGGER.error("{} completed with error ", (Object)type, (Object)e);
            }

            public void onComplete() {
                LOGGER.debug("{} completed", (Object)type);
            }
        };
    }

    public static <T> FlowableSubscriber<T> logFlowableResults(final String type) {
        return new FlowableSubscriber<T>(){

            public void onSubscribe(@Nonnull Subscription s) {
            }

            public void onNext(T result) {
            }

            public void onError(Throwable e) {
                LOGGER.error("{} completed with error ", (Object)type, (Object)e);
            }

            public void onComplete() {
                LOGGER.debug("{} completed", (Object)type);
            }
        };
    }

    public static CompletableObserver logCompletableResults(final String type) {
        return new CompletableObserver(){

            public void onSubscribe(@Nonnull Disposable d) {
            }

            public void onError(@Nonnull Throwable e) {
                LOGGER.error("[{}] ReportPortal {} execution error", new Object[]{Thread.currentThread().getId(), type, e});
            }

            public void onComplete() {
                LOGGER.debug("{} completed", (Object)type);
            }
        };
    }

    public static <T> Maybe<T> createConstantMaybe(T rs) {
        return Maybe.create(emitter -> {
            emitter.onSuccess(rs);
            emitter.onComplete();
        });
    }

    public static <T> Maybe<T> createConstantMaybe(Throwable exception) {
        return Maybe.create(emitter -> {
            emitter.onError(exception);
            emitter.onComplete();
        });
    }
}

