/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.restendpoint.http.HttpMethod;
import com.epam.reportportal.restendpoint.http.MultiPartRequest;
import com.epam.reportportal.restendpoint.http.annotation.Body;
import com.epam.reportportal.restendpoint.http.annotation.Close;
import com.epam.reportportal.restendpoint.http.annotation.Multipart;
import com.epam.reportportal.restendpoint.http.annotation.Path;
import com.epam.reportportal.restendpoint.http.annotation.Request;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;

public interface ReportPortalClient {
    @Request(method=HttpMethod.POST, url="/launch")
    public Maybe<StartLaunchRS> startLaunch(@Body StartLaunchRQ var1);

    @Request(method=HttpMethod.POST, url="/launch/merge")
    public Maybe<LaunchResource> mergeLaunches(@Body MergeLaunchesRQ var1);

    @Request(method=HttpMethod.PUT, url="/launch/{launchId}/finish")
    public Maybe<OperationCompletionRS> finishLaunch(@Path(value="launchId") String var1, @Body FinishExecutionRQ var2);

    @Request(method=HttpMethod.POST, url="/item/")
    public Maybe<ItemCreatedRS> startTestItem(@Body StartTestItemRQ var1);

    @Request(method=HttpMethod.POST, url="/item/{parent}")
    public Maybe<ItemCreatedRS> startTestItem(@Path(value="parent") String var1, @Body StartTestItemRQ var2);

    @Request(method=HttpMethod.PUT, url="/item/{itemId}")
    public Maybe<OperationCompletionRS> finishTestItem(@Path(value="itemId") String var1, @Body FinishTestItemRQ var2);

    @Request(method=HttpMethod.POST, url="/log/")
    public Maybe<EntryCreatedAsyncRS> log(@Body SaveLogRQ var1);

    @Request(method=HttpMethod.POST, url="/log/")
    public Maybe<BatchSaveOperatingRS> log(@Body @Multipart MultiPartRequest var1);

    @Request(method=HttpMethod.GET, url="/launch/uuid/{launchUuid}")
    public Maybe<LaunchResource> getLaunchByUuid(@Path(value="launchUuid") String var1);

    @Close
    public void close();
}

