/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.serializer;

import com.epam.reportportal.restendpoint.http.exception.SerializerException;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import java.lang.reflect.Type;
import rp.com.google.common.net.MediaType;
import rp.com.google.common.reflect.TypeToken;

public class ByteArraySerializer
implements Serializer {
    @Override
    public final <T> byte[] serialize(T t) throws SerializerException {
        return (byte[])t;
    }

    @Override
    public final <T> T deserialize(byte[] content, Class<T> clazz) throws SerializerException {
        if (byte[].class.equals(clazz)) {
            return (T)content;
        }
        throw new SerializerException("Unable to deserialize to type '" + clazz.getName() + "'");
    }

    @Override
    public final <T> T deserialize(byte[] content, Type type) throws SerializerException {
        if (byte[].class.equals((Object)type)) {
            return (T)content;
        }
        throw new SerializerException("Unable to deserialize to type '" + type + "'");
    }

    @Override
    public final MediaType getMimeType() {
        return MediaType.OCTET_STREAM;
    }

    @Override
    public final boolean canRead(MediaType mimeType, Class<?> resultType) {
        return mimeType.is(MediaType.ANY_TYPE) && byte[].class.equals(resultType);
    }

    @Override
    public final boolean canRead(MediaType mimeType, Type resultType) {
        return this.canRead(mimeType, TypeToken.of(resultType).getRawType());
    }

    @Override
    public final boolean canWrite(Object o) {
        return byte[].class.equals(o.getClass());
    }
}

