/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.http;

import java.util.ArrayList;
import java.util.List;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.io.ByteSource;

public class MultiPartRequest {
    private final List<MultiPartSerialized<?>> serializedRQs;
    private final List<MultiPartBinary> binaryRQs;

    public MultiPartRequest(List<MultiPartSerialized<?>> serializedRQs, List<MultiPartBinary> binaryRQs) {
        this.serializedRQs = serializedRQs;
        this.binaryRQs = binaryRQs;
    }

    public final List<MultiPartBinary> getBinaryRQs() {
        return this.binaryRQs;
    }

    public final List<MultiPartSerialized<?>> getSerializedRQs() {
        return this.serializedRQs;
    }

    public static class Builder {
        private final List<MultiPartSerialized<?>> serializedRQs = new ArrayList();
        private final List<MultiPartBinary> binaryRQs = new ArrayList<MultiPartBinary>();

        public <RQ> Builder addSerializedPart(String partName, RQ body) {
            this.serializedRQs.add(new MultiPartSerialized<RQ>(partName, body));
            return this;
        }

        public Builder addBinaryPart(String partName, String filename, String contentType, ByteSource data) {
            Preconditions.checkNotNull(data, "Provided data shouldn't be null");
            this.binaryRQs.add(new MultiPartBinary(partName, filename, contentType, data));
            return this;
        }

        public MultiPartRequest build() {
            return new MultiPartRequest(this.serializedRQs, this.binaryRQs);
        }
    }

    public static class MultiPartBinary {
        private final String partName;
        private final String filename;
        private final String contentType;
        private final ByteSource data;

        public MultiPartBinary(String partName, String filename, String contentType, ByteSource data) {
            this.partName = partName;
            this.filename = filename;
            this.data = data;
            this.contentType = contentType;
        }

        public final ByteSource getData() {
            return this.data;
        }

        public final String getFilename() {
            return this.filename;
        }

        public final String getPartName() {
            return this.partName;
        }

        public final String getContentType() {
            return this.contentType;
        }
    }

    public static class MultiPartSerialized<RQ> {
        private final String partName;
        private final RQ request;

        public MultiPartSerialized(String partName, RQ request) {
            this.partName = partName;
            this.request = request;
        }

        public final String getPartName() {
            return this.partName;
        }

        public final RQ getRequest() {
            return this.request;
        }
    }
}

