/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.jbehave;

import com.epam.reportportal.jbehave.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Step;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.Timing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportPortalStoryReporter
extends NullStoryReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalStoryReporter.class);
    public static final String CODE_REF = "CODE_REF";
    public static final String START_TIME = "START_TIME";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String PARENT = "PARENT";
    public static final String START_REQUEST = "START_REQUEST";
    public static final String FINISH_REQUEST = "FINISH_REQUEST";
    private static final String CODE_REFERENCE_DELIMITER = "/";
    private static final String CODE_REFERENCE_ITEM_TYPE_DELIMITER = ":";
    private static final String CODE_REFERENCE_ITEM_START = "[";
    private static final String CODE_REFERENCE_ITEM_END = "]";
    private static final String EXAMPLE_VALUE_PATTERN = "<%s>";
    private static final Pattern EXAMPLE_VALUE_MATCH = Pattern.compile("<([^>]*)>");
    private static final String EXAMPLE = "EXAMPLE";
    private static final String LIFECYCLE = "LIFECYCLE";
    private static final String NO_NAME = "No name";
    private static final String BEFORE_STORIES = "BeforeStories";
    private static final String AFTER_STORIES = "AfterStories";
    private static final String BEFORE_STORY = "BeforeStory";
    private static final String AFTER_STORY = "AfterStory";
    private static final String PARAMETERS_PATTERN = "Parameters:\n\n%s";
    private final Deque<Entity<?>> structure = new LinkedList();
    private final Deque<TestItemTree.TestItemLeaf> stepStack = new LinkedList<TestItemTree.TestItemLeaf>();
    private final Supplier<Launch> launch;
    private final TestItemTree itemTree;
    private volatile ItemType currentLifecycleTopItemType;
    private volatile TestItemTree.TestItemLeaf lastStep;
    private ItemType currentLifecycleItemType;

    public ReportPortalStoryReporter(Supplier<Launch> launchSupplier, TestItemTree testItemTree) {
        this.launch = launchSupplier;
        this.itemTree = testItemTree;
    }

    @Nonnull
    public Optional<TestItemTree.TestItemLeaf> getLastStep() {
        return Optional.ofNullable(this.lastStep);
    }

    private String getCodeRef(@Nullable String parentCodeRef, @Nonnull TestItemTree.ItemTreeKey key, @Nonnull ItemType type) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)parentCodeRef)) {
            sb.append(key.getName());
        } else {
            String typeName;
            switch (type) {
                case SUITE: {
                    typeName = EXAMPLE;
                    break;
                }
                case TEST: {
                    typeName = LIFECYCLE;
                    break;
                }
                default: {
                    typeName = type.name();
                }
            }
            sb.append(parentCodeRef).append(CODE_REFERENCE_DELIMITER).append(CODE_REFERENCE_ITEM_START).append(typeName).append(CODE_REFERENCE_ITEM_TYPE_DELIMITER).append(key.getName().replace("\n", "").replace("\r", "")).append(CODE_REFERENCE_ITEM_END);
        }
        return sb.toString();
    }

    protected String getStoryName(@Nonnull Story story) {
        return story.getName();
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull Meta meta) {
        HashSet<ItemAttributesRQ> items = new HashSet<ItemAttributesRQ>();
        meta.getPropertyNames().forEach(name -> {
            String value = meta.getProperty(name);
            items.add(StringUtils.isBlank((CharSequence)value) ? new ItemAttributesRQ(name) : new ItemAttributesRQ(name, value));
        });
        return items;
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull Story story) {
        return this.getAttributes(story.getMeta());
    }

    @Nonnull
    protected StartTestItemRQ buildStartStoryRq(@Nonnull Story story, @Nonnull String codeRef, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.getStoryName(story));
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(ItemType.STORY.name());
        rq.setAttributes(this.getAttributes(story));
        rq.setDescription(story.getDescription().asString());
        return rq;
    }

    protected String getScenarioName(Scenario scenario) {
        String title = scenario.getTitle();
        return StringUtils.isBlank((CharSequence)title) ? NO_NAME : title;
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull Scenario scenario) {
        return this.getAttributes(scenario.getMeta());
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRq(@Nonnull Scenario scenario, @Nonnull String codeRef, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.getScenarioName(scenario));
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(ItemType.SCENARIO.name());
        rq.setAttributes(this.getAttributes(scenario));
        return rq;
    }

    @Nullable
    protected List<ParameterResource> getStepParameters(@Nullable Map<String, String> params) {
        return Optional.ofNullable(params).map(p -> p.entrySet().stream().map(e -> this.parameterOf((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList())).orElse(null);
    }

    private ParameterResource parameterOf(String key, String value) {
        ParameterResource param = new ParameterResource();
        param.setKey(key);
        param.setValue(value);
        return param;
    }

    @Nonnull
    protected StartTestItemRQ buildStartExampleRq(@Nonnull Scenario scenario, @Nonnull Map<String, String> example, @Nonnull String codeRef, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.getScenarioName(scenario));
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(ItemType.TEST.name());
        rq.setParameters(this.getStepParameters(example));
        rq.setDescription(String.format(PARAMETERS_PATTERN, MarkdownUtils.formatDataTable(example)));
        return rq;
    }

    @Nonnull
    protected List<String> getUsedParameters(@Nonnull String step) {
        Matcher m = EXAMPLE_VALUE_MATCH.matcher(step);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    @Nonnull
    protected String formatExampleStep(@Nonnull String step, @Nullable Map<String, String> example) {
        if (example == null) {
            return step;
        }
        String result = step;
        for (Map.Entry<String, String> e : example.entrySet()) {
            result = result.replaceAll(String.format(EXAMPLE_VALUE_PATTERN, e.getKey()), Matcher.quoteReplacement(e.getValue()));
        }
        return result;
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<String> params) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, params);
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull String step, @Nonnull String codeRef, @Nullable Map<String, String> params, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.formatExampleStep(step, params));
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(ItemType.STEP.name());
        Optional<List> usedParams = Optional.ofNullable(params).map(p -> this.getUsedParameters(step).stream().filter(params::containsKey).map(pk -> this.parameterOf((String)pk, (String)params.get(pk))).collect(Collectors.toList()));
        usedParams.ifPresent(arg_0 -> ((StartTestItemRQ)rq).setParameters(arg_0));
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, usedParams.map(p -> p.stream().map(ParameterResource::getValue).collect(Collectors.toList())).orElse(null))).map(TestCaseIdEntry::getId).orElse(null));
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildLifecycleSuiteStartRq(@Nonnull String name, @Nullable String codeRef, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(ItemType.TEST.name());
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildLifecycleMethodStartRq(@Nonnull ItemType type, @Nonnull String name, @Nullable String codeRef, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setCodeRef(codeRef);
        rq.setStartTime((Comparable)Optional.ofNullable(startTime).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MICROS)));
        rq.setType(type.name());
        return rq;
    }

    @Nonnull
    protected Maybe<String> startTestItem(@Nullable Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        Launch myLaunch = this.launch.get();
        return Optional.ofNullable(parentId).map(p -> myLaunch.startTestItem(p, rq)).orElseGet(() -> myLaunch.startTestItem(rq));
    }

    @Nonnull
    protected TestItemTree.TestItemLeaf createLeaf(@Nonnull ItemType type, @Nonnull StartTestItemRQ rq, @Nullable TestItemTree.TestItemLeaf parent) {
        Optional<TestItemTree.TestItemLeaf> parentOptional = Optional.ofNullable(parent);
        Optional<Maybe> parentId = parentOptional.map(TestItemTree.TestItemLeaf::getItemId);
        Maybe<String> itemId = this.startTestItem((Maybe<String>)((Maybe)parentId.orElse(null)), rq);
        TestItemTree.TestItemLeaf l = parentId.map(p -> TestItemTree.createTestItemLeaf((Maybe)p, (Maybe)itemId)).orElseGet(() -> TestItemTree.createTestItemLeaf((Maybe)itemId));
        l.setType(type);
        l.setAttribute(START_TIME, (Object)rq.getStartTime());
        l.setAttribute(START_REQUEST, (Object)rq);
        parentOptional.ifPresent(p -> l.setAttribute(PARENT, p));
        Optional.ofNullable(rq.getCodeRef()).ifPresent(r -> l.setAttribute(CODE_REF, r));
        return l;
    }

    @Nonnull
    protected Instant getItemDate(@Nullable TestItemTree.TestItemLeaf parent) {
        Instant currentDate;
        Instant previousDate = Optional.ofNullable(parent).map(p -> (Instant)p.getAttribute(START_TIME)).orElseGet(Instant::now);
        Instant itemDate = previousDate.compareTo(currentDate = Instant.now().truncatedTo(ChronoUnit.MICROS)) <= 0 ? currentDate : previousDate;
        return itemDate;
    }

    @Nullable
    protected TestItemTree.TestItemLeaf retrieveLeaf() {
        ArrayList<ImmutablePair> leafChain = new ArrayList<ImmutablePair>();
        Entity<?> parentEntity = null;
        for (Entity<?> entity : this.structure) {
            ItemType itemType = entity.type();
            Optional<Pair> parent = leafChain.isEmpty() ? Optional.empty() : Optional.of((Pair)leafChain.get(leafChain.size() - 1));
            TestItemTree.TestItemLeaf parentLeaf = parent.map(Pair::getValue).orElse(null);
            Map children = parent.map(p -> ((TestItemTree.TestItemLeaf)p.getValue()).getChildItems()).orElseGet(() -> ((TestItemTree)this.itemTree).getTestItems());
            String parentCodeRef = parent.map(p -> (String)((TestItemTree.TestItemLeaf)p.getValue()).getAttribute(CODE_REF)).orElse(null);
            Instant itemDate = this.getItemDate(parent.map(Pair::getValue).orElse(null));
            switch (itemType) {
                case STORY: {
                    Story story = (Story)entity.get();
                    TestItemTree.ItemTreeKey storyKey = ItemTreeUtils.createKey(story);
                    leafChain.add(ImmutablePair.of((Object)storyKey, (Object)children.computeIfAbsent(storyKey, k -> this.createLeaf(ItemType.STORY, this.buildStartStoryRq(story, this.getCodeRef(parentCodeRef, (TestItemTree.ItemTreeKey)k, ItemType.STORY), itemDate), parentLeaf))));
                    break;
                }
                case SCENARIO: {
                    Scenario scenario = (Scenario)entity.get();
                    if (scenario.hasExamplesTable() && !scenario.getExamplesTable().getRows().isEmpty()) break;
                    TestItemTree.ItemTreeKey scenarioKey = ItemTreeUtils.createKey(this.getScenarioName(scenario));
                    leafChain.add(ImmutablePair.of((Object)scenarioKey, (Object)children.computeIfAbsent(scenarioKey, k -> this.createLeaf(ItemType.SCENARIO, this.buildStartScenarioRq(scenario, this.getCodeRef(parentCodeRef, (TestItemTree.ItemTreeKey)k, ItemType.SCENARIO), itemDate), parentLeaf))));
                    break;
                }
                case SUITE: {
                    if (parentEntity == null) {
                        LOGGER.error("Unable to locate Scenario item for Example, this is not something which is supposed to happen, skipping reporting");
                        break;
                    }
                    Scenario parentScenario = (Scenario)parentEntity.get();
                    Map example = (Map)entity.get();
                    TestItemTree.ItemTreeKey parentScenarioKey = ItemTreeUtils.createKey(this.getScenarioName(parentScenario));
                    TestItemTree.ItemTreeKey exampleKey = ItemTreeUtils.createKey(example);
                    leafChain.add(ImmutablePair.of((Object)exampleKey, (Object)children.computeIfAbsent(exampleKey, k -> {
                        String parentScenarioCodeRef = this.getCodeRef(parentCodeRef, parentScenarioKey, ItemType.SCENARIO);
                        TestItemTree.TestItemLeaf leaf = this.createLeaf(ItemType.SUITE, this.buildStartExampleRq(parentScenario, example, this.getCodeRef(parentScenarioCodeRef, (TestItemTree.ItemTreeKey)k, ItemType.SUITE), itemDate), parentLeaf);
                        leaf.setAttribute(PARAMETERS, (Object)example);
                        return leaf;
                    })));
                    break;
                }
                case TEST: {
                    String lifecycleSuiteName = (String)entity.get();
                    TestItemTree.ItemTreeKey lifecycleSuiteKey = ItemTreeUtils.createKey(lifecycleSuiteName);
                    leafChain.add(ImmutablePair.of((Object)lifecycleSuiteKey, (Object)children.computeIfAbsent(lifecycleSuiteKey, k -> this.createLeaf(itemType, this.buildLifecycleSuiteStartRq(lifecycleSuiteName, this.getCodeRef(parentCodeRef, (TestItemTree.ItemTreeKey)k, ItemType.TEST), itemDate), parentLeaf))));
                }
            }
            parentEntity = entity;
        }
        return leafChain.isEmpty() ? null : (TestItemTree.TestItemLeaf)((Pair)leafChain.get(leafChain.size() - 1)).getValue();
    }

    @Nullable
    protected TestItemTree.TestItemLeaf getLeaf() {
        ArrayList<ImmutablePair> leafChain = new ArrayList<ImmutablePair>();
        block5: for (Entity<?> entity : this.structure) {
            Pair parent;
            ItemType itemType = entity.type();
            Pair pair = parent = leafChain.isEmpty() ? null : (Pair)leafChain.get(leafChain.size() - 1);
            if (parent != null && parent.getValue() == null) {
                return null;
            }
            Map children = Optional.ofNullable(parent).map(p -> ((TestItemTree.TestItemLeaf)p.getValue()).getChildItems()).orElseGet(() -> ((TestItemTree)this.itemTree).getTestItems());
            switch (itemType) {
                case STORY: {
                    TestItemTree.ItemTreeKey storyKey = ItemTreeUtils.createKey((Story)entity.get());
                    leafChain.add(ImmutablePair.of((Object)storyKey, (Object)((TestItemTree.TestItemLeaf)children.get(storyKey))));
                    continue block5;
                }
                case SCENARIO: {
                    Scenario scenario = (Scenario)entity.get();
                    if (scenario.hasExamplesTable() && !scenario.getExamplesTable().getRows().isEmpty()) continue block5;
                    TestItemTree.ItemTreeKey scenarioKey = ItemTreeUtils.createKey(this.getScenarioName(scenario));
                    leafChain.add(ImmutablePair.of((Object)scenarioKey, (Object)((TestItemTree.TestItemLeaf)children.get(scenarioKey))));
                    continue block5;
                }
                case SUITE: {
                    TestItemTree.ItemTreeKey exampleKey = ItemTreeUtils.createKey((Map)entity.get());
                    leafChain.add(ImmutablePair.of((Object)exampleKey, (Object)((TestItemTree.TestItemLeaf)children.get(exampleKey))));
                    continue block5;
                }
            }
            TestItemTree.ItemTreeKey stepKey = ItemTreeUtils.createKey((String)entity.get());
            leafChain.add(ImmutablePair.of((Object)stepKey, (Object)((TestItemTree.TestItemLeaf)children.get(stepKey))));
        }
        return leafChain.isEmpty() ? null : (TestItemTree.TestItemLeaf)((Pair)leafChain.get(leafChain.size() - 1)).getValue();
    }

    protected TestItemTree.TestItemLeaf startStep(@Nonnull String name, @Nonnull TestItemTree.TestItemLeaf parent) {
        TestItemTree.ItemTreeKey key = ItemTreeUtils.createKey(name);
        TestItemTree.TestItemLeaf leaf = this.createLeaf(ItemType.STEP, this.buildStartStepRq(name, this.getCodeRef((String)parent.getAttribute(CODE_REF), key, ItemType.STEP), (Map)parent.getAttribute(PARAMETERS), this.getItemDate(parent)), parent);
        parent.getChildItems().put(key, leaf);
        return leaf;
    }

    @Nonnull
    protected TestItemTree.TestItemLeaf startLifecycleMethod(@Nonnull String name, @Nonnull ItemType itemType, @Nonnull TestItemTree.TestItemLeaf parent) {
        TestItemTree.ItemTreeKey key = ItemTreeUtils.createKey(name);
        String codeRef = this.getCodeRef((String)parent.getAttribute(CODE_REF), key, itemType);
        TestItemTree.TestItemLeaf leaf = this.createLeaf(itemType, this.buildLifecycleMethodStartRq(itemType, name, codeRef, this.getItemDate(parent)), parent);
        parent.getChildItems().put(key, leaf);
        return leaf;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRequest(@Nonnull Maybe<String> id, @Nullable ItemStatus status, @Nullable Issue issue) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime((Comparable)Instant.now());
        rq.setStatus((String)Optional.ofNullable(status).map(Enum::name).orElse(null));
        rq.setIssue(issue);
        return rq;
    }

    protected void finishItem(@Nullable TestItemTree.TestItemLeaf item, @Nullable ItemStatus status) {
        Optional.ofNullable(item).ifPresent(i -> {
            FinishTestItemRQ rq = this.buildFinishTestItemRequest((Maybe<String>)i.getItemId(), status, null);
            Maybe response = this.launch.get().finishTestItem(i.getItemId(), rq);
            i.setStatus(status);
            i.setFinishResponse(response);
            i.setAttribute(FINISH_REQUEST, (Object)rq);
        });
    }

    protected void finishLastItem(@Nullable ItemStatus status) {
        TestItemTree.TestItemLeaf item = this.getLeaf();
        this.finishItem(item, status);
        this.structure.pollLast();
    }

    @Nullable
    protected ItemStatus evaluateStatus(@Nullable ItemStatus currentStatus, @Nullable ItemStatus childStatus) {
        return StatusEvaluation.evaluateStatus((ItemStatus)currentStatus, (ItemStatus)childStatus);
    }

    protected void evaluateAndFinishLastItem() {
        Scenario scenario;
        TestItemTree.TestItemLeaf item = this.getLeaf();
        Entity<?> entity = this.structure.pollLast();
        if (entity != null && ItemType.SCENARIO == entity.type() && (scenario = (Scenario)entity.get()).hasExamplesTable() && !scenario.getExamplesTable().getRows().isEmpty()) {
            return;
        }
        Optional.ofNullable(item).ifPresent(i -> {
            ItemStatus status = i.getStatus();
            for (Map.Entry entry : i.getChildItems().entrySet()) {
                TestItemTree.TestItemLeaf value = (TestItemTree.TestItemLeaf)entry.getValue();
                if (value == null) continue;
                status = this.evaluateStatus(status, value.getStatus());
            }
            i.setStatus(status);
            this.finishItem((TestItemTree.TestItemLeaf)i, status);
        });
    }

    @Nonnull
    protected Function<String, SaveLogRQ> getLogSupplier(@Nonnull LogLevel level, @Nullable String message) {
        return itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            rq.setLevel(level.name());
            rq.setLogTime((Comparable)Instant.now());
            rq.setMessage(message);
            return rq;
        };
    }

    protected void sendStackTraceToRP(@Nonnull Maybe<String> itemId, @Nullable Throwable thrown) {
        Optional.ofNullable(thrown).ifPresent(t -> ReportPortal.emitLog((Maybe)itemId, this.getLogSupplier(LogLevel.ERROR, ExceptionUtils.getStackTrace((Throwable)t))));
    }

    protected void finishItem(@Nonnull Maybe<String> id, @Nonnull ItemStatus status, @Nullable Issue issue) {
        FinishTestItemRQ rq = this.buildFinishTestItemRequest(id, status, issue);
        this.launch.get().finishTestItem(id, rq);
    }

    private void finishStep(@Nonnull TestItemTree.TestItemLeaf step, @Nonnull ItemStatus status, @Nullable Issue issue) {
        this.finishItem((Maybe<String>)step.getItemId(), status, issue);
        step.setStatus(status);
    }

    private void finishStep(@Nonnull TestItemTree.TestItemLeaf step, @Nonnull ItemStatus status) {
        this.finishStep(step, status, null);
    }

    protected void createIgnoredSteps(@Nullable String step, @Nonnull TestItemTree.TestItemLeaf leaf) {
    }

    protected void createNotPerformedSteps(@Nullable String step, @Nonnull TestItemTree.TestItemLeaf leaf) {
        ReportPortal.emitLog((Maybe)leaf.getItemId(), this.getLogSupplier(LogLevel.WARN, "Step execution was skipped by JBehave, see previous steps for errors."));
    }

    protected void createPendingSteps(@Nullable String step, @Nonnull TestItemTree.TestItemLeaf leaf) {
        ReportPortal.emitLog((Maybe)leaf.getItemId(), this.getLogSupplier(LogLevel.WARN, String.format("Unable to locate a step implementation: '%s'", step)));
    }

    protected void simulateStep(@Nonnull String step) {
        TestItemTree.TestItemLeaf item = this.retrieveLeaf();
        Optional.ofNullable(item).ifPresent(i -> {
            TestItemTree.TestItemLeaf leaf = this.startStep(step, (TestItemTree.TestItemLeaf)i);
            this.finishStep(leaf, ItemStatus.SKIPPED);
        });
    }

    public void beforeStory(@Nonnull Story story, boolean givenStory) {
        this.currentLifecycleItemType = ItemType.BEFORE_SUITE;
        this.structure.add(new Entity<Story>(ItemType.STORY, story));
    }

    public void afterStory(boolean givenStory) {
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && previousItem.getType() == ItemType.TEST) {
            this.evaluateAndFinishLastItem();
        }
        this.evaluateAndFinishLastItem();
    }

    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.finishLastItem(ItemStatus.SKIPPED);
    }

    public void beforeScenario(@Nonnull Scenario scenario) {
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && previousItem.getType() == ItemType.TEST) {
            this.evaluateAndFinishLastItem();
        }
        this.currentLifecycleItemType = ItemType.BEFORE_TEST;
        this.structure.add(new Entity<Scenario>(ItemType.SCENARIO, scenario));
    }

    public void afterScenario(Timing timing) {
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && previousItem.getType() == ItemType.TEST) {
            this.evaluateAndFinishLastItem();
        }
        this.currentLifecycleItemType = ItemType.AFTER_SUITE;
        this.evaluateAndFinishLastItem();
    }

    public void beforeStep(@Nonnull Step step) {
        TestItemTree.TestItemLeaf parentItem;
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && previousItem.getType() == ItemType.TEST) {
            this.evaluateAndFinishLastItem();
        }
        if ((parentItem = this.retrieveLeaf()) == null) {
            if (this.itemTree.getTestItems().isEmpty()) {
                this.currentLifecycleTopItemType = ItemType.BEFORE_GROUPS;
                this.structure.add(new Entity<String>(ItemType.TEST, BEFORE_STORIES));
            } else {
                this.currentLifecycleTopItemType = ItemType.AFTER_GROUPS;
                this.structure.add(new Entity<String>(ItemType.TEST, AFTER_STORIES));
            }
        } else if (parentItem.getType() == ItemType.STORY) {
            this.structure.add(new Entity<String>(ItemType.TEST, this.currentLifecycleItemType == ItemType.BEFORE_SUITE ? BEFORE_STORY : AFTER_STORY));
        }
        TestItemTree.TestItemLeaf stepLeaf = Optional.ofNullable(this.retrieveLeaf()).map(i -> {
            if (parentItem == null) {
                return this.startLifecycleMethod(step.getStepAsString(), this.currentLifecycleTopItemType, (TestItemTree.TestItemLeaf)i);
            }
            if (ItemType.TEST == i.getType()) {
                return this.startLifecycleMethod(step.getStepAsString(), this.currentLifecycleItemType, (TestItemTree.TestItemLeaf)i);
            }
            this.currentLifecycleItemType = ItemType.BEFORE_METHOD;
            return this.startStep(step.getStepAsString(), (TestItemTree.TestItemLeaf)i);
        }).orElse(null);
        if (stepLeaf != null) {
            this.stepStack.add(stepLeaf);
            this.lastStep = stepLeaf;
        }
    }

    public void beforeExamples(List<String> steps, ExamplesTable table) {
    }

    public void example(Map<String, String> tableRow, int exampleIndex) {
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && (previousItem.getType() == ItemType.TEST || previousItem.getType() == ItemType.SUITE)) {
            this.evaluateAndFinishLastItem();
        }
        this.structure.add(new Entity<Map<String, String>>(ItemType.SUITE, tableRow));
    }

    public void afterExamples() {
        TestItemTree.TestItemLeaf previousItem = this.getLeaf();
        if (previousItem != null && previousItem.getType() == ItemType.TEST) {
            this.evaluateAndFinishLastItem();
        }
        this.evaluateAndFinishLastItem();
    }

    private void finishBeforeAfterSuites(TestItemTree.TestItemLeaf item) {
        if (item.getType() == ItemType.BEFORE_GROUPS || item.getType() == ItemType.AFTER_GROUPS) {
            Entity<?> parentSuite = this.structure.getLast();
            this.evaluateAndFinishLastItem();
            this.structure.add(parentSuite);
        }
    }

    public void successful(String step) {
        this.currentLifecycleItemType = ItemType.AFTER_TEST;
        Optional.ofNullable(this.stepStack.pollLast()).ifPresent(s -> {
            this.finishStep((TestItemTree.TestItemLeaf)s, ItemStatus.PASSED);
            this.finishBeforeAfterSuites((TestItemTree.TestItemLeaf)s);
        });
    }

    public void failed(String step, Throwable cause) {
        Optional.ofNullable(this.stepStack.pollLast()).ifPresent(i -> {
            this.sendStackTraceToRP((Maybe<String>)i.getItemId(), cause);
            this.finishStep((TestItemTree.TestItemLeaf)i, ItemStatus.FAILED);
            this.finishBeforeAfterSuites((TestItemTree.TestItemLeaf)i);
        });
    }

    public void ignorable(String step) {
        Optional.ofNullable(this.stepStack.pollLast()).ifPresent(i -> {
            this.createIgnoredSteps(step, (TestItemTree.TestItemLeaf)i);
            this.finishStep((TestItemTree.TestItemLeaf)i, ItemStatus.SKIPPED);
            this.finishBeforeAfterSuites((TestItemTree.TestItemLeaf)i);
        });
    }

    public void notPerformed(String step) {
        Optional.ofNullable(this.stepStack.pollLast()).ifPresent(i -> {
            this.createNotPerformedSteps(step, (TestItemTree.TestItemLeaf)i);
            this.finishStep((TestItemTree.TestItemLeaf)i, ItemStatus.SKIPPED, Launch.NOT_ISSUE);
            this.finishBeforeAfterSuites((TestItemTree.TestItemLeaf)i);
        });
    }

    public void pending(StepCreator.PendingStep step) {
        Optional.ofNullable(this.stepStack.pollLast()).ifPresent(i -> {
            this.createPendingSteps(step.stepAsString(), (TestItemTree.TestItemLeaf)i);
            this.finishStep((TestItemTree.TestItemLeaf)i, ItemStatus.SKIPPED);
            this.finishBeforeAfterSuites((TestItemTree.TestItemLeaf)i);
        });
    }

    public void scenarioExcluded(Scenario scenario, String filter) {
        if (null != scenario.getExamplesTable() && scenario.getExamplesTable().getRowCount() > 0) {
            this.beforeExamples(scenario.getSteps(), scenario.getExamplesTable());
            for (int i = 0; i < scenario.getExamplesTable().getRowCount(); ++i) {
                this.example(scenario.getExamplesTable().getRow(i), i);
                for (String step : scenario.getSteps()) {
                    this.simulateStep(step);
                }
            }
        } else {
            for (String step : scenario.getSteps()) {
                this.simulateStep(step);
            }
        }
        this.finishLastItem(ItemStatus.SKIPPED);
    }

    protected static class Entity<T> {
        private final ItemType type;
        private final T value;

        public Entity(ItemType itemType, T itemValue) {
            this.type = itemType;
            this.value = itemValue;
        }

        public ItemType type() {
            return this.type;
        }

        public T get() {
            return this.value;
        }
    }
}

