/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.cucumber.FeatureContext;
import com.epam.reportportal.cucumber.RuleContext;
import com.epam.reportportal.cucumber.ScenarioContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.reportportal.utils.http.ContentType;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.reportportal.utils.reflect.Accessible;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporter
implements ConcurrentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    private static final ThreadLocal<AbstractReporter> INSTANCES = new InheritableThreadLocal<AbstractReporter>();
    private static final String NO_NAME = "No name";
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String GET_LOCATION_METHOD_NAME = "getLocation";
    private static final String COLON_INFIX = ": ";
    private static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    public static final String BACKGROUND_PREFIX = "BACKGROUND: ";
    protected static final URI WORKING_DIRECTORY = new File(System.getProperty("user.dir")).toURI();
    protected static final String METHOD_OPENING_BRACKET = "(";
    protected static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final String ERROR_FORMAT = "Error:\n%s";
    private final Map<URI, FeatureContext> featureContextMap = new ConcurrentHashMap<URI, FeatureContext>();
    private final TestItemTree itemTree = new TestItemTree();
    private final ReportPortal rp = this.buildReportPortal();
    private final Map<URI, Date> featureEndTime = new ConcurrentHashMap<URI, Date>();
    private final Map<Maybe<String>, String> descriptionsMap = new ConcurrentHashMap<Maybe<String>, String>();
    private final Map<Maybe<String>, Throwable> errorMap = new ConcurrentHashMap<Maybe<String>, Throwable>();
    private final Supplier<Launch> launch = new MemoizingSupplier((Supplier)new Supplier<Launch>(){
        private final Date startTime = Calendar.getInstance().getTime();

        @Override
        public Launch get() {
            StartLaunchRQ rq = AbstractReporter.this.buildStartLaunchRq(this.startTime, AbstractReporter.this.getReportPortal().getParameters());
            Launch myLaunch = AbstractReporter.this.getReportPortal().newLaunch(rq);
            AbstractReporter.this.itemTree.setLaunchId(myLaunch.start());
            return myLaunch;
        }
    });

    protected StartLaunchRQ buildStartLaunchRq(Date startTime, ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(startTime);
        rq.setMode(parameters.getLaunchRunningMode());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
        rq.setAttributes(attributes);
        attributes.addAll(SystemAttributesExtractor.extract((String)AGENT_PROPERTIES_FILE, (ClassLoader)AbstractReporter.class.getClassLoader()));
        rq.setDescription(parameters.getDescription());
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (null != parameters.getSkippedAnIssue()) {
            ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
            skippedIssueAttribute.setKey(SKIPPED_ISSUE_KEY);
            skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
            skippedIssueAttribute.setSystem(true);
            attributes.add(skippedIssueAttribute);
        }
        return rq;
    }

    public AbstractReporter() {
        INSTANCES.set(this);
    }

    @Nonnull
    public TestItemTree getItemTree() {
        return this.itemTree;
    }

    @Nonnull
    public static AbstractReporter getCurrent() {
        return INSTANCES.get();
    }

    @Nonnull
    public ReportPortal getReportPortal() {
        return this.rp;
    }

    @Nonnull
    public Launch getLaunch() {
        return this.launch.get();
    }

    protected void beforeLaunch() {
        this.getLaunch();
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        this.getLaunch().finish(finishLaunchRq);
    }

    private void addToTree(Feature feature, TestCase testCase, Maybe<String> scenarioId) {
        ItemTreeUtils.retrieveLeaf(feature.getUri(), this.itemTree).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(testCase.getLocation().getLine()), TestItemTree.createTestItemLeaf((Maybe)scenarioId)));
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull Collection<?> tags) {
        return tags.stream().map(Object::toString).map(tagValue -> new ItemAttributesRQ(null, tagValue)).collect(Collectors.toSet());
    }

    private void execute(@Nonnull URI uri, @Nonnull FeatureContextAware context) {
        Optional<FeatureContext> feature = Optional.ofNullable(this.featureContextMap.get(uri));
        if (feature.isPresent()) {
            context.executeWithContext(feature.get());
        } else {
            LOGGER.warn("Unable to locate corresponding Feature for URI: {}", (Object)uri);
        }
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Argument> arguments) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRequest(@Nonnull TestCase testCase, @Nonnull String name, @Nonnull URI uri, int line) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setDescription(this.getDescription(testCase, uri));
        String codeRef = this.getCodeRef(uri, line);
        rq.setCodeRef(codeRef);
        HashSet tags = new HashSet(testCase.getTags());
        this.execute(uri, (FeatureContext f) -> tags.removeAll(f.getTags()));
        rq.setAttributes(this.extractAttributes(tags));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = this.getScenarioTestItemType();
        rq.setType(type);
        if ("STEP".equals(type)) {
            rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        }
        return rq;
    }

    @Nonnull
    protected Maybe<String> startScenario(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ startScenarioRq) {
        return this.getLaunch().startTestItem(featureId, startScenarioRq);
    }

    private void execute(@Nonnull TestCase testCase, @Nonnull ScenarioContextAware context) {
        URI uri = testCase.getUri();
        int line = testCase.getLocation().getLine();
        this.execute(uri, (FeatureContext f) -> {
            Optional<ScenarioContext> scenario = f.getScenario(line);
            if (scenario.isPresent()) {
                context.executeWithContext(f, scenario.get());
            } else {
                LOGGER.warn("Unable to locate corresponding Feature or Scenario context for URI: {}; line: {}", (Object)uri, (Object)line);
            }
        });
    }

    private void removeFromTree(Feature featureContext, TestCase scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), this.itemTree).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLocation().getLine())));
    }

    protected void afterScenario(TestCaseFinished event) {
        TestCase testCase = event.getTestCase();
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            URI featureUri = f.getUri();
            if (this.mapItemStatus(event.getResult().getStatus()) == ItemStatus.FAILED) {
                Optional.ofNullable(event.getResult().getError()).ifPresent(error -> this.errorMap.put(s.getId(), (Throwable)error));
            }
            Date endTime = this.finishTestItem(s.getId(), this.mapItemStatus(event.getResult().getStatus()), null);
            this.featureEndTime.put(featureUri, endTime);
            this.removeFromTree(f.getFeature(), testCase);
        });
    }

    @Nullable
    protected String getStepName(@Nonnull PickleStepTestStep testStep) {
        return testStep.getStep().getText();
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nonnull TestStep testStep, @Nullable String codeRef) {
        List arguments = ((PickleStepTestStep)testStep).getDefinitionArgument();
        return Optional.ofNullable(codeRef).flatMap(r -> {
            Pair<String, String> splitCodeRef = AbstractReporter.parseJavaCodeRef(codeRef);
            Optional<Class<?>> testStepClass = AbstractReporter.getStepClass((String)splitCodeRef.getKey(), codeRef);
            return testStepClass.flatMap(c -> AbstractReporter.getStepMethod(c, (String)splitCodeRef.getValue())).map(m -> TestCaseIdUtils.getTestCaseId((TestCaseId)m.getAnnotation(TestCaseId.class), (Executable)m, (String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments)));
        }).orElseGet(() -> this.getTestCaseId(codeRef, arguments));
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRequest(@Nonnull PickleStepTestStep testStep, @Nullable String stepPrefix, @Nullable String keyword) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, keyword, this.getStepName(testStep)));
        rq.setDescription(this.buildMultilineArgument((TestStep)testStep));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        String codeRef = this.getCodeRef((TestStep)testStep);
        rq.setParameters(this.getParameters(codeRef, (TestStep)testStep));
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId((TestStep)testStep, codeRef)).map(TestCaseIdEntry::getId).orElse(null));
        Optional.ofNullable(codeRef).ifPresent(c -> rq.setAttributes(this.getAttributes((String)c)));
        return rq;
    }

    @Nonnull
    protected Maybe<String> startStep(@Nonnull Maybe<String> scenarioId, @Nonnull StartTestItemRQ startStepRq) {
        return this.getLaunch().startTestItem(scenarioId, startStepRq);
    }

    private void addToTree(@Nonnull TestCase scenario, @Nullable String text, @Nullable Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenario.getUri(), scenario.getLocation().getLine(), this.itemTree).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void beforeStep(@Nonnull TestCase testCase, @Nonnull PickleStepTestStep step) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            String stepPrefix = step.getStep().getLocation().getLine() < s.getLine() ? BACKGROUND_PREFIX : null;
            StartTestItemRQ rq = this.buildStartStepRequest(step, stepPrefix, step.getStep().getKeyword());
            Maybe<String> stepId = this.startStep(s.getId(), rq);
            if (rq.isHasStats()) {
                this.descriptionsMap.put(stepId, Optional.ofNullable(rq.getDescription()).orElse(""));
            }
            s.setStepId(stepId);
            String stepText = step.getStep().getText();
            if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                this.addToTree(testCase, stepText, stepId);
            }
        });
    }

    protected void afterStep(@Nonnull TestCase testCase, @Nonnull PickleStepTestStep testStep, @Nonnull Result result) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.reportResult(result);
            if (this.mapItemStatus(result.getStatus()) == ItemStatus.FAILED) {
                Optional.ofNullable(result.getError()).ifPresent(error -> this.errorMap.put(s.getStepId(), (Throwable)error));
            }
            this.finishTestItem(s.getStepId(), this.mapItemStatus(result.getStatus()), null);
            s.setStepId((Maybe<String>)Maybe.empty());
        });
    }

    @Nonnull
    protected Pair<String, String> getHookTypeAndName(@Nonnull HookType hookType) {
        switch (hookType) {
            case BEFORE: {
                return Pair.of((Object)ItemType.BEFORE_TEST.name(), (Object)"Before hook");
            }
            case BEFORE_STEP: {
                return Pair.of((Object)ItemType.BEFORE_METHOD.name(), (Object)"Before step");
            }
            case AFTER: {
                return Pair.of((Object)ItemType.AFTER_TEST.name(), (Object)"After hook");
            }
            case AFTER_STEP: {
                return Pair.of((Object)ItemType.AFTER_METHOD.name(), (Object)"After step");
            }
        }
        return Pair.of((Object)ItemType.TEST.name(), (Object)"Hook");
    }

    @Nonnull
    protected StartTestItemRQ buildStartHookRequest(@Nonnull TestCase testCase, @Nonnull HookTestStep testStep) {
        StartTestItemRQ rq = new StartTestItemRQ();
        Pair<String, String> typeName = this.getHookTypeAndName(testStep.getHookType());
        rq.setType((String)typeName.getKey());
        rq.setName(String.format("%s: %s", typeName.getValue(), testStep.getCodeLocation()));
        rq.setStartTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nonnull
    protected Maybe<String> startHook(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return this.getLaunch().startTestItem(parentId, rq);
    }

    protected void beforeHooks(@Nonnull TestCase testCase, @Nonnull HookTestStep testStep) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            StartTestItemRQ rq = this.buildStartHookRequest(testCase, testStep);
            s.setHookId(this.startHook(s.getId(), rq));
        });
    }

    protected void afterHooks(@Nonnull TestCase testCase, @Nonnull HookTestStep step, Result result) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.reportResult(result);
            this.finishTestItem(s.getHookId(), this.mapItemStatus(result.getStatus()));
            s.setHookId((Maybe<String>)Maybe.empty());
        });
    }

    @Nonnull
    protected abstract String getFeatureTestItemType();

    @Nonnull
    protected abstract String getScenarioTestItemType();

    protected void reportResult(@Nonnull Result result) {
        Optional.ofNullable(result.getError()).ifPresent(ReportPortal::sendStackTraceToRP);
    }

    @Nullable
    private static String getDataType(@Nonnull byte[] data, @Nullable String name) {
        try {
            return MimeTypeDetector.detect((ByteSource)ByteSource.wrap((byte[])data), (String)name);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to detect MIME type", (Throwable)e);
            return null;
        }
    }

    protected void embedding(@Nullable String name, @Nullable String mimeType, @Nonnull byte[] data) {
        String type = Optional.ofNullable(mimeType).filter(ContentType::isValidType).orElseGet(() -> AbstractReporter.getDataType(data, name));
        String attachmentName = Optional.ofNullable(name).filter(m -> !m.isEmpty()).orElseGet(() -> Optional.ofNullable(type).map(t -> t.substring(0, t.indexOf("/"))).orElse(""));
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, attachmentName), (String)LogLevel.INFO.name(), (Date)Calendar.getInstance().getTime());
    }

    protected void sendLog(@Nullable String message) {
        ReportPortal.emitLog((String)message, (String)LogLevel.INFO.name(), (Date)Calendar.getInstance().getTime());
    }

    @Nonnull
    protected abstract Optional<Maybe<String>> getRootItemId();

    @Nonnull
    protected StartTestItemRQ buildStartRuleRequest(@Nonnull Node.Rule rule, @Nullable String codeRef) {
        String ruleKeyword = rule.getKeyword().orElse("");
        String ruleName = rule.getName().orElse(NO_NAME);
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(ruleKeyword, COLON_INFIX, ruleName));
        rq.setCodeRef(codeRef);
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("SUITE");
        return rq;
    }

    @Nonnull
    protected Maybe<String> startRule(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ ruleRq) {
        return this.getLaunch().startTestItem(featureId, ruleRq);
    }

    protected void beforeScenario(@Nonnull Feature feature, @Nonnull TestCase scenario) {
        String scenarioName = Utils.buildName(scenario.getKeyword(), COLON_INFIX, scenario.getName());
        this.execute(scenario, (FeatureContext f, ScenarioContext s) -> {
            Optional<RuleContext> rule = s.getRule();
            Optional<RuleContext> currentRule = f.getCurrentRule();
            if (!currentRule.equals(rule)) {
                if (currentRule.isEmpty()) {
                    rule.ifPresent(r -> {
                        r.setId(this.startRule(f.getId(), this.buildStartRuleRequest(r.getRule(), this.getCodeRef(feature.getUri(), r.getLine()))));
                        f.setCurrentRule((RuleContext)r);
                    });
                } else {
                    this.finishTestItem(currentRule.get().getId());
                    rule.ifPresent(r -> {
                        r.setId(this.startRule(f.getId(), this.buildStartRuleRequest(r.getRule(), this.getCodeRef(feature.getUri(), r.getLine()))));
                        f.setCurrentRule((RuleContext)r);
                    });
                }
            }
            Maybe rootId = rule.map(RuleContext::getId).orElseGet(f::getId);
            int codeLine = s.getExample().map(e -> e.getLocation().getLine()).orElse(s.getLine());
            StartTestItemRQ startTestItemRQ = this.buildStartScenarioRequest(scenario, scenarioName, s.getUri(), codeLine);
            s.setId(this.startScenario((Maybe<String>)rootId, startTestItemRQ));
            this.descriptionsMap.put(s.getId(), Optional.ofNullable(startTestItemRQ.getDescription()).orElse(""));
            if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                this.addToTree(feature, scenario, s.getId());
            }
        });
    }

    @Nonnull
    protected StartTestItemRQ buildStartFeatureRequest(@Nonnull Feature feature, @Nonnull URI uri) {
        String featureKeyword = feature.getKeyword().orElse("");
        String featureName = feature.getName().orElse(NO_NAME);
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setCodeRef(this.getCodeRef(uri, 0));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        this.execute(feature.getUri(), (FeatureContext f) -> startFeatureRq.setAttributes(this.extractAttributes(f.getTags())));
        startFeatureRq.setStartTime(Calendar.getInstance().getTime());
        startFeatureRq.setType(this.getFeatureTestItemType());
        return startFeatureRq;
    }

    @Nonnull
    protected Maybe<String> startFeature(@Nonnull StartTestItemRQ startFeatureRq) {
        Optional<Maybe<String>> root = this.getRootItemId();
        return root.map(r -> this.getLaunch().startTestItem(r, startFeatureRq)).orElseGet(() -> this.getLaunch().startTestItem(startFeatureRq));
    }

    private void addToTree(Feature feature, Maybe<String> featureId) {
        this.getItemTree().getTestItems().put(ItemTreeUtils.createKey(feature.getUri()), TestItemTree.createTestItemLeaf(featureId));
    }

    protected void handleStartOfTestCase(@Nonnull TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        URI uri = testCase.getUri();
        this.execute(uri, (FeatureContext f) -> {
            if (f.getId().equals((Object)Maybe.empty())) {
                this.getRootItemId();
                StartTestItemRQ featureRq = this.buildStartFeatureRequest(f.getFeature(), uri);
                f.setId(this.startFeature(featureRq));
                if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                    this.addToTree(f.getFeature(), f.getId());
                }
            }
        });
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            s.setTestCase(testCase);
            this.beforeScenario(f.getFeature(), testCase);
        });
    }

    protected void handleSourceEvents(TestSourceParsed parseEvent) {
        URI uri = parseEvent.getUri();
        parseEvent.getNodes().forEach(n -> {
            if (n instanceof Feature) {
                this.featureContextMap.put(uri, new FeatureContext(uri, (Feature)n));
            } else {
                LOGGER.warn("Unknown node type: {}", (Object)n.getClass().getSimpleName());
            }
        });
    }

    protected EventHandler<TestRunStarted> getTestRunStartedHandler() {
        return event -> this.beforeLaunch();
    }

    protected EventHandler<TestSourceParsed> getTestSourceParsedHandler() {
        return this::handleSourceEvents;
    }

    protected EventHandler<TestCaseStarted> getTestCaseStartedHandler() {
        return this::handleStartOfTestCase;
    }

    protected EventHandler<TestStepStarted> getTestStepStartedHandler() {
        return this::handleTestStepStarted;
    }

    protected EventHandler<TestStepFinished> getTestStepFinishedHandler() {
        return this::handleTestStepFinished;
    }

    protected EventHandler<TestCaseFinished> getTestCaseFinishedHandler() {
        return this::afterScenario;
    }

    protected EventHandler<TestRunFinished> getTestRunFinishedHandler() {
        return event -> {
            this.handleEndOfFeature();
            this.afterLaunch();
        };
    }

    protected EventHandler<EmbedEvent> getEmbedEventHandler() {
        return event -> this.embedding(event.getName(), event.getMediaType(), event.getData());
    }

    protected EventHandler<WriteEvent> getWriteEventHandler() {
        return event -> this.sendLog(event.getText());
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.getTestRunStartedHandler());
        publisher.registerHandlerFor(TestSourceParsed.class, this.getTestSourceParsedHandler());
        publisher.registerHandlerFor(TestCaseStarted.class, this.getTestCaseStartedHandler());
        publisher.registerHandlerFor(TestStepStarted.class, this.getTestStepStartedHandler());
        publisher.registerHandlerFor(TestStepFinished.class, this.getTestStepFinishedHandler());
        publisher.registerHandlerFor(TestCaseFinished.class, this.getTestCaseFinishedHandler());
        publisher.registerHandlerFor(TestRunFinished.class, this.getTestRunFinishedHandler());
        publisher.registerHandlerFor(EmbedEvent.class, this.getEmbedEventHandler());
        publisher.registerHandlerFor(WriteEvent.class, this.getWriteEventHandler());
    }

    private void removeFromTree(Feature feature) {
        this.itemTree.getTestItems().remove(ItemTreeUtils.createKey(feature.getUri()));
    }

    protected void handleEndOfFeature() {
        this.featureContextMap.values().forEach(f -> {
            Date featureCompletionDateTime = this.featureEndTime.get(f.getUri());
            f.getCurrentRule().ifPresent(r -> this.finishTestItem(r.getId(), null, featureCompletionDateTime));
            this.finishTestItem(f.getId(), null, featureCompletionDateTime);
            this.removeFromTree(f.getFeature());
        });
        this.featureContextMap.clear();
    }

    protected void handleTestStepStarted(@Nonnull TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        TestCase testCase = event.getTestCase();
        if (testStep instanceof HookTestStep) {
            this.beforeHooks(testCase, (HookTestStep)testStep);
        } else if (testStep instanceof PickleStepTestStep) {
            this.beforeStep(testCase, (PickleStepTestStep)testStep);
        } else {
            LOGGER.warn("Unable to start unknown step type: {}", (Object)testStep.getClass().getSimpleName());
        }
    }

    protected void handleTestStepFinished(@Nonnull TestStepFinished event) {
        TestStep testStep = event.getTestStep();
        TestCase testCase = event.getTestCase();
        if (testStep instanceof HookTestStep) {
            this.afterHooks(testCase, (HookTestStep)testStep, event.getResult());
        } else if (testStep instanceof PickleStepTestStep) {
            this.afterStep(testCase, (PickleStepTestStep)testStep, event.getResult());
        } else {
            LOGGER.warn("Unable to finish unknown step type: {}", (Object)testStep.getClass().getSimpleName());
        }
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRequest(@Nonnull Maybe<String> itemId, @Nullable Date finishTime, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        if (status == ItemStatus.FAILED) {
            Optional<String> currentDescription = Optional.ofNullable(this.descriptionsMap.remove(itemId));
            Optional<Throwable> currentError = Optional.ofNullable(this.errorMap.remove(itemId));
            currentDescription.flatMap(description -> currentError.map(errorMessage -> this.resolveDescriptionErrorMessage((String)description, (Throwable)errorMessage))).ifPresent(arg_0 -> ((FinishTestItemRQ)rq).setDescription(arg_0));
        }
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(finishTime);
        return rq;
    }

    private String resolveDescriptionErrorMessage(String currentDescription, Throwable error) {
        String errorStr = this.getReportPortal().getParameters().isExceptionTruncate() ? String.format(ERROR_FORMAT, com.epam.reportportal.utils.formatting.ExceptionUtils.getStackTrace((Throwable)error, (Throwable)new Throwable())) : String.format(ERROR_FORMAT, ExceptionUtils.getStackTrace((Throwable)error));
        return Optional.ofNullable(currentDescription).filter(StringUtils::isNotBlank).map(description -> MarkdownUtils.asTwoParts((String)currentDescription, (String)errorStr)).orElse(errorStr);
    }

    protected Date finishTestItem(@Nullable Maybe<String> itemId, @Nullable ItemStatus status, @Nullable Date dateTime) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return null;
        }
        Date endTime = Optional.ofNullable(dateTime).orElse(Calendar.getInstance().getTime());
        FinishTestItemRQ rq = this.buildFinishTestItemRequest(itemId, endTime, status);
        this.getLaunch().finishTestItem(itemId, rq);
        return endTime;
    }

    @Nullable
    protected ItemStatus mapItemStatus(@Nullable Status status) {
        if (status == null) {
            return null;
        }
        if (Utils.STATUS_MAPPING.get(status) == null) {
            LOGGER.error("Unable to find direct mapping between Cucumber and ReportPortal for TestItem with status: '{}'.", (Object)status);
            return ItemStatus.SKIPPED;
        }
        return Utils.STATUS_MAPPING.get(status);
    }

    protected void finishTestItem(@Nullable Maybe<String> itemId, @Nullable ItemStatus status) {
        this.finishTestItem(itemId, status, null);
    }

    protected void finishTestItem(@Nullable Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    @Nonnull
    protected String formatDataTable(@Nonnull List<List<String>> table) {
        return MarkdownUtils.formatDataTable(table);
    }

    @Nonnull
    protected String buildMultilineArgument(@Nonnull TestStep step) {
        List table = null;
        String docString = null;
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        if (pickleStep.getStep().getArgument() != null) {
            StepArgument argument = pickleStep.getStep().getArgument();
            if (argument instanceof DocStringArgument) {
                docString = ((DocStringArgument)argument).getContent();
            } else if (argument instanceof DataTableArgument) {
                table = ((DataTableArgument)argument).cells();
            }
        }
        StringBuilder marg = new StringBuilder();
        if (table != null) {
            marg.append(this.formatDataTable(table));
        }
        if (docString != null) {
            marg.append(DOCSTRING_DECORATOR).append(docString).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }

    @Nullable
    protected String getCodeRef(@Nonnull TestStep testStep) {
        String cucumberLocation = testStep.getCodeLocation();
        try {
            String codeLocation;
            Object codeLocationObject;
            Object javaStepDefinition;
            Object stepDefinitionMatch = Accessible.on((Object)testStep).field(DEFINITION_MATCH_FIELD_NAME).getValue();
            if (stepDefinitionMatch != null && (javaStepDefinition = Accessible.on((Object)stepDefinitionMatch).field(STEP_DEFINITION_FIELD_NAME).getValue()) != null && (codeLocationObject = Accessible.on((Object)javaStepDefinition).method(GET_LOCATION_METHOD_NAME, new Class[0]).invoke(new Object[0])) != null && StringUtils.isNotBlank((CharSequence)(codeLocation = codeLocationObject.toString()))) {
                int openingBracketIndex = codeLocation.indexOf(METHOD_OPENING_BRACKET);
                if (openingBracketIndex > 0) {
                    return codeLocation.substring(0, codeLocation.indexOf(METHOD_OPENING_BRACKET));
                }
                return codeLocation;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Unable to get java code reference for the Test Step: {}", (Object)cucumberLocation, (Object)e);
            return cucumberLocation;
        }
        return cucumberLocation;
    }

    @Nonnull
    protected String getCodeRef(@Nonnull URI uri, int line) {
        return String.valueOf(WORKING_DIRECTORY.relativize(uri)) + ":" + line;
    }

    @Nonnull
    private static Pair<String, String> parseJavaCodeRef(@Nonnull String codeRef) {
        int lastDelimiterIndex = codeRef.lastIndexOf(46);
        String className = codeRef.substring(0, lastDelimiterIndex);
        String methodName = codeRef.substring(lastDelimiterIndex + 1);
        return Pair.of((Object)className, (Object)methodName);
    }

    @Nonnull
    private static Optional<Class<?>> getStepClass(String classCodeRef, String fullCodeRef) {
        try {
            return Optional.of(Class.forName(classCodeRef));
        }
        catch (ClassNotFoundException e1) {
            try {
                return Optional.of(Class.forName(fullCodeRef));
            }
            catch (ClassNotFoundException e2) {
                return Optional.empty();
            }
        }
    }

    @Nonnull
    private static Optional<Method> getStepMethod(@Nonnull Class<?> stepClass, @Nullable String methodName) {
        return Arrays.stream(stepClass.getMethods()).filter(m -> m.getName().equals(methodName)).findAny();
    }

    @Nullable
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull String codeRef) {
        Pair<String, String> splitCodeRef = AbstractReporter.parseJavaCodeRef(codeRef);
        Optional<Class<?>> testStepClass = AbstractReporter.getStepClass((String)splitCodeRef.getKey(), codeRef);
        return testStepClass.flatMap(c -> AbstractReporter.getStepMethod(c, (String)splitCodeRef.getValue())).map(m -> m.getAnnotation(Attributes.class)).map(AttributeParser::retrieveAttributes).orElse(null);
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nullable String codeRef, @Nonnull TestStep testStep) {
        if (!(testStep instanceof PickleStepTestStep)) {
            return Collections.emptyList();
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        List arguments = pickleStepTestStep.getDefinitionArgument();
        List params = Optional.ofNullable(arguments).map(a -> a.stream().map(arg -> Pair.of((Object)arg.getParameterTypeName(), (Object)arg.getValue())).collect(Collectors.toList())).orElse(new ArrayList());
        Optional.ofNullable(pickleStepTestStep.getStep().getArgument()).ifPresent(a -> {
            String value = a instanceof DocStringArgument ? ((DocStringArgument)a).getContent() : (a instanceof DataTableArgument ? this.formatDataTable(((DataTableArgument)a).cells()) : a.toString());
            params.add(Pair.of((Object)"arg", (Object)value));
        });
        return ParameterUtils.getParameters((String)codeRef, (List)params);
    }

    @Nonnull
    protected String getDescription(Feature feature, @Nonnull URI uri) {
        return uri.toString();
    }

    @Nonnull
    protected String getDescription(@Nonnull TestCase testCase, @Nonnull URI uri) {
        return uri.toString();
    }

    @FunctionalInterface
    private static interface ScenarioContextAware {
        public void executeWithContext(@Nonnull FeatureContext var1, @Nonnull ScenarioContext var2);
    }

    @FunctionalInterface
    private static interface FeatureContextAware {
        public void executeWithContext(@Nonnull FeatureContext var1);
    }
}

