/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.Status;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Utils {
    private static final String EMPTY = "";
    public static final String TAG_KEY = "@";
    public static final Map<Status, ItemStatus> STATUS_MAPPING = Map.of(Status.PASSED, ItemStatus.PASSED, Status.FAILED, ItemStatus.FAILED, Status.SKIPPED, ItemStatus.SKIPPED, Status.PENDING, ItemStatus.SKIPPED, Status.AMBIGUOUS, ItemStatus.SKIPPED, Status.UNDEFINED, ItemStatus.SKIPPED, Status.UNUSED, ItemStatus.SKIPPED);
    public static final Map<Status, String> LOG_LEVEL_MAPPING = Map.of(Status.PASSED, "INFO", Status.FAILED, "ERROR", Status.SKIPPED, "WARN", Status.PENDING, "WARN", Status.AMBIGUOUS, "WARN", Status.UNDEFINED, "WARN", Status.UNUSED, "WARN");
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getValue).collect(Collectors.toList())).orElse(null);

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(@Nullable String prefix, @Nullable String infix, @Nullable String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    @Nonnull
    public static Set<String> getTags(@Nonnull Feature feature) {
        return feature.getKeyword().map(k -> {
            HashSet<String> tags = new HashSet<String>();
            for (String line : feature.getSource().split("\\r?\\n")) {
                String bareLine = line.trim();
                if (bareLine.startsWith((String)k)) {
                    return tags;
                }
                if (!line.startsWith(TAG_KEY)) continue;
                tags.addAll(Arrays.asList(line.split("\\s+")));
            }
            return tags;
        }).orElse(Collections.emptySet());
    }
}

