/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.RuleContext;
import com.epam.reportportal.cucumber.ScenarioContext;
import com.epam.reportportal.cucumber.Utils;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.event.Node;
import io.reactivex.Maybe;
import java.net.URI;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class FeatureContext {
    private final URI uri;
    private final Feature feature;
    private final Map<Integer, ScenarioContext> scenarios = new HashMap<Integer, ScenarioContext>();
    private final Set<String> tags;
    private Maybe<String> id = Maybe.empty();
    private RuleContext currentRule;

    private void handleNode(@Nonnull Deque<RuleContext> ruleQueue, @Nonnull URI uri, @Nonnull Node node) {
        if (node instanceof Node.Rule) {
            Node.Rule rule = (Node.Rule)node;
            RuleContext ruleContext = new RuleContext(uri, (Node.Rule)node);
            ruleQueue.add(ruleContext);
            rule.elements().forEach(n -> this.handleNode(ruleQueue, uri, (Node)n));
        }
        if (node instanceof Node.Scenario) {
            Node.Scenario scenario = (Node.Scenario)node;
            int line = scenario.getLocation().getLine();
            this.scenarios.put(line, new ScenarioContext(uri, ruleQueue.peekLast(), scenario));
        }
        if (node instanceof Node.ScenarioOutline) {
            Node.ScenarioOutline scenarioOutline = (Node.ScenarioOutline)node;
            scenarioOutline.elements().stream().flatMap(e -> e.elements().stream()).forEach(e -> this.scenarios.put(e.getLocation().getLine(), new ScenarioContext(uri, (RuleContext)ruleQueue.peekLast(), scenarioOutline, (Node.Example)e)));
        }
    }

    private <T extends Node> void handleNodes(@Nonnull URI uri, @Nonnull Collection<T> nodes) {
        LinkedList ruleQueue = new LinkedList();
        nodes.forEach(n -> this.handleNode(ruleQueue, uri, (Node)n));
    }

    public FeatureContext(@Nonnull URI featureUri, @Nonnull Feature featureNode) {
        this.uri = featureUri;
        this.feature = featureNode;
        this.handleNodes(featureUri, featureNode.elements());
        this.tags = Utils.getTags(featureNode);
    }

    @Nonnull
    public Feature getFeature() {
        return this.feature;
    }

    @Nonnull
    public URI getUri() {
        return this.uri;
    }

    @Nonnull
    public Set<String> getTags() {
        return this.tags;
    }

    @Nonnull
    public Maybe<String> getId() {
        return this.id;
    }

    public void setId(@Nonnull Maybe<String> id) {
        this.id = id;
    }

    @Nonnull
    public Optional<ScenarioContext> getScenario(@Nonnull Integer line) {
        return Optional.ofNullable(this.scenarios.get(line));
    }

    @Nonnull
    public Optional<RuleContext> getCurrentRule() {
        return Optional.ofNullable(this.currentRule);
    }

    public void setCurrentRule(@Nonnull RuleContext rule) {
        this.currentRule = rule;
    }
}

