/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import cucumber.api.Argument;
import cucumber.api.Result;
import cucumber.api.TestStep;
import cucumber.runtime.StepDefinitionMatch;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class Utils {
    private static final String EMPTY = "";
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    public static final String ONE_SPACE = "\u00a0";
    private static final String NEW_LINE = "\r\n";
    public static final String TABLE_INDENT = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TABLE_COLUMN_SEPARATOR = "|";
    public static final String TABLE_ROW_SEPARATOR = "-";
    private static final Map<Result.Type, ItemStatus> COMMON_STATUS_MAPPING = new HashMap<Result.Type, ItemStatus>(){
        {
            this.put(Result.Type.PASSED, ItemStatus.PASSED);
            this.put(Result.Type.FAILED, ItemStatus.FAILED);
            this.put(Result.Type.SKIPPED, ItemStatus.SKIPPED);
            this.put(Result.Type.PENDING, ItemStatus.SKIPPED);
            this.put(Result.Type.AMBIGUOUS, ItemStatus.SKIPPED);
            this.put(Result.Type.UNDEFINED, ItemStatus.SKIPPED);
        }
    };
    private static final Map<Result.Type, String> COMMON_LOG_LEVEL_MAPPING = new HashMap<Result.Type, String>(){
        {
            this.put(Result.Type.PASSED, LogLevel.INFO.name());
            this.put(Result.Type.FAILED, LogLevel.ERROR.name());
            this.put(Result.Type.SKIPPED, LogLevel.WARN.name());
            this.put(Result.Type.PENDING, LogLevel.WARN.name());
            this.put(Result.Type.AMBIGUOUS, LogLevel.WARN.name());
            this.put(Result.Type.UNDEFINED, LogLevel.WARN.name());
        }
    };
    public static final Map<Result.Type, ItemStatus> STATUS_MAPPING;
    public static final Map<Result.Type, String> LOG_LEVEL_MAPPING;
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM;

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(String prefix, String infix, String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    public static Method retrieveMethod(Field definitionMatchField, TestStep testStep) throws IllegalAccessException, NoSuchFieldException {
        StepDefinitionMatch stepDefinitionMatch = (StepDefinitionMatch)definitionMatchField.get(testStep);
        Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
        Field methodField = javaStepDefinition.getClass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }

    public static Field getDefinitionMatchField(TestStep testStep) {
        Class<?> clazz = testStep.getClass();
        try {
            return clazz.getField(DEFINITION_MATCH_FIELD_NAME);
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    Field definitionMatchField = clazz.getDeclaredField(DEFINITION_MATCH_FIELD_NAME);
                    definitionMatchField.setAccessible(true);
                    return definitionMatchField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    return null;
                }
                break;
            }
        }
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table) {
        StringBuilder result = new StringBuilder();
        int tableLength = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        List colSizes = IntStream.range(0, tableLength).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).map(col -> col.stream().mapToInt(String::length).max().orElse(0)).collect(Collectors.toList());
        boolean header = true;
        for (List<String> row : table) {
            int i;
            result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
            for (i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                int maxSize = (Integer)colSizes.get(i) - cell.length() + 2;
                int lSpace = maxSize / 2;
                int rSpace = maxSize - lSpace;
                IntStream.range(0, lSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(cell);
                IntStream.range(0, rSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(TABLE_COLUMN_SEPARATOR);
            }
            if (header) {
                header = false;
                result.append(NEW_LINE);
                result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
                for (i = 0; i < row.size(); ++i) {
                    int maxSize = (Integer)colSizes.get(i) + 2;
                    IntStream.range(0, maxSize).forEach(j -> result.append(TABLE_ROW_SEPARATOR));
                    result.append(TABLE_COLUMN_SEPARATOR);
                }
            }
            result.append(NEW_LINE);
        }
        return result.toString().trim();
    }

    static {
        Optional<Result.Type> unused = Arrays.stream(Result.Type.values()).filter(e -> "UNUSED".equals(e.name())).findAny();
        if (unused.isPresent()) {
            COMMON_STATUS_MAPPING.put(unused.get(), ItemStatus.SKIPPED);
            COMMON_LOG_LEVEL_MAPPING.put(unused.get(), LogLevel.WARN.name());
        }
        STATUS_MAPPING = Collections.unmodifiableMap(COMMON_STATUS_MAPPING);
        LOG_LEVEL_MAPPING = Collections.unmodifiableMap(COMMON_LOG_LEVEL_MAPPING);
        ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getValue).collect(Collectors.toList())).orElse(null);
    }
}

