/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.TestStep;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Function;
import rp.com.google.common.collect.ImmutableMap;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String TABLE_SEPARATOR = "|";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final Map<String, String> STATUS_MAPPING = ImmutableMap.builder().put((Object)"passed", (Object)"PASSED").put((Object)"skipped", (Object)"SKIPPED").put((Object)"undefined", (Object)"SKIPPED").build();

    private Utils() {
    }

    public static void finishTestItem(Launch rp, Maybe<String> itemId) {
        Utils.finishTestItem(rp, itemId, null);
    }

    public static void finishTestItem(Launch rp, Maybe<String> itemId, String status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setStatus(status);
        rq.setEndTime(Calendar.getInstance().getTime());
        rp.finishTestItem(itemId, rq);
    }

    public static Maybe<String> startNonLeafNode(Launch rp, Maybe<String> rootItemId, String name, String description, Set<String> tags, String type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setDescription(description);
        rq.setName(name);
        rq.setTags(tags);
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(type);
        return rp.startTestItem(rootItemId, rq);
    }

    public static void sendLog(final String message, final String level, final SaveLogRQ.File file) {
        ReportPortal.emitLog((Function)new Function<String, SaveLogRQ>(){

            public SaveLogRQ apply(String item) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setMessage(message);
                rq.setTestItemId(item);
                rq.setLevel(level);
                rq.setLogTime(Calendar.getInstance().getTime());
                if (file != null) {
                    rq.setFile(file);
                }
                return rq;
            }
        });
    }

    public static Set<String> extractPickleTags(List<PickleTag> tags) {
        HashSet<String> returnTags = new HashSet<String>();
        for (PickleTag tag : tags) {
            returnTags.add(tag.getName());
        }
        return returnTags;
    }

    public static Set<String> extractTags(List<Tag> tags) {
        HashSet<String> returnTags = new HashSet<String>();
        for (Tag tag : tags) {
            returnTags.add(tag.getName());
        }
        return returnTags;
    }

    public static String mapLevel(String cukesStatus) {
        String mapped = null;
        mapped = cukesStatus.equalsIgnoreCase("passed") ? "INFO" : (cukesStatus.equalsIgnoreCase("skipped") ? "WARN" : "ERROR");
        return mapped;
    }

    public static String buildNodeName(String prefix, String infix, String argument, String suffix) {
        return Utils.buildName(prefix, infix, argument, suffix);
    }

    private static String buildName(String prefix, String infix, String argument, String suffix) {
        return (prefix == null ? "" : prefix) + infix + argument + (suffix == null ? "" : suffix);
    }

    public static String buildMultilineArgument(TestStep step) {
        List table = null;
        String dockString = "";
        StringBuilder marg = new StringBuilder();
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        if (!pickleStep.getStepArgument().isEmpty()) {
            Argument argument = (Argument)pickleStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                dockString = ((PickleString)argument).getContent();
            } else if (argument instanceof PickleTable) {
                table = ((PickleTable)argument).getRows();
            }
        }
        if (table != null) {
            marg.append("\r\n");
            for (PickleRow row : table) {
                marg.append(TABLE_SEPARATOR);
                for (PickleCell cell : row.getCells()) {
                    marg.append(" ").append(cell.getValue()).append(" ").append(TABLE_SEPARATOR);
                }
                marg.append("\r\n");
            }
        }
        if (!dockString.isEmpty()) {
            marg.append(DOCSTRING_DECORATOR).append(dockString).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }

    public static String getStepName(TestStep step) {
        String stepName = step instanceof HookTestStep ? "Hook: " + ((HookTestStep)step).getHookType().toString() : ((PickleStepTestStep)step).getPickleStep().getText();
        return stepName;
    }
}

