/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.google.common.collect.ImmutableMap;
import cucumber.api.Result;
import cucumber.api.TestStep;
import cucumber.runtime.Argument;
import cucumber.runtime.StepDefinitionMatch;
import io.reactivex.annotations.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class Utils {
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    private static final String ONE_SPACE = "&nbsp;";
    private static final String NEW_LINE = "\r\n";
    private static final String TABLE_INDENT = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String TABLE_SEPARATOR = "|";
    public static final Map<Result.Type, ItemStatus> STATUS_MAPPING = ImmutableMap.builder().put((Object)Result.Type.PASSED, (Object)ItemStatus.PASSED).put((Object)Result.Type.FAILED, (Object)ItemStatus.FAILED).put((Object)Result.Type.SKIPPED, (Object)ItemStatus.SKIPPED).put((Object)Result.Type.PENDING, (Object)ItemStatus.SKIPPED).put((Object)Result.Type.UNDEFINED, (Object)ItemStatus.SKIPPED).put((Object)Result.Type.AMBIGUOUS, (Object)ItemStatus.SKIPPED).build();
    public static final Map<Result.Type, String> LOG_LEVEL_MAPPING = ImmutableMap.builder().put((Object)Result.Type.PASSED, (Object)"INFO").put((Object)Result.Type.FAILED, (Object)"ERROR").put((Object)Result.Type.SKIPPED, (Object)"WARN").put((Object)Result.Type.PENDING, (Object)"WARN").put((Object)Result.Type.UNDEFINED, (Object)"WARN").put((Object)Result.Type.AMBIGUOUS, (Object)"WARN").build();
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getVal).collect(Collectors.toList())).orElse(null);

    private Utils() {
    }

    public static String buildName(String prefix, String infix, String argument) {
        return (prefix == null ? "" : prefix) + infix + argument;
    }

    public static Method retrieveMethod(Field definitionMatchField, TestStep testStep) throws NoSuchFieldException, IllegalAccessException {
        StepDefinitionMatch stepDefinitionMatch = (StepDefinitionMatch)definitionMatchField.get(testStep);
        Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
        Field methodField = javaStepDefinition.getClass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }

    @Nullable
    public static Field getDefinitionMatchField(@Nonnull TestStep testStep) {
        Class<?> clazz = testStep.getClass();
        try {
            return clazz.getField(DEFINITION_MATCH_FIELD_NAME);
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    Field definitionMatchField = clazz.getDeclaredField(DEFINITION_MATCH_FIELD_NAME);
                    definitionMatchField.setAccessible(true);
                    return definitionMatchField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    return null;
                }
                break;
            }
        }
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table) {
        StringBuilder result = new StringBuilder();
        int tableLength = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        List colSizes = IntStream.range(0, tableLength).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).map(col -> col.stream().mapToInt(String::length).max().orElse(0)).collect(Collectors.toList());
        for (List<String> row : table) {
            result.append(TABLE_INDENT).append(TABLE_SEPARATOR);
            for (int i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                int maxSize = (Integer)colSizes.get(i) - cell.length() + 2;
                int lSpace = maxSize / 2;
                int rSpace = maxSize - lSpace;
                IntStream.range(0, lSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(cell);
                IntStream.range(0, rSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(TABLE_SEPARATOR);
            }
            result.append(NEW_LINE);
        }
        return result.toString().trim();
    }
}

