/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.AbstractReporter;
import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Step;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioReporter
extends AbstractReporter {
    private static final String RP_STORY_TYPE = "SUITE";
    private static final String RP_TEST_TYPE = "STORY";
    private static final String RP_STEP_TYPE = "STEP";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioReporter.class);
    protected MemoizingSupplier<Maybe<String>> rootSuiteId = new MemoizingSupplier(() -> {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName("Root User Story");
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(RP_STORY_TYPE);
        return ((Launch)this.launch.get()).startTestItem(rq);
    });

    @Override
    @Nonnull
    protected StartTestItemRQ buildStartStepRequest(@Nonnull Step step, @Nullable String stepPrefix, @Nonnull Match match) {
        StartTestItemRQ rq = super.buildStartStepRequest(step, stepPrefix, match);
        rq.setHasStats(false);
        return rq;
    }

    @Override
    protected void beforeStep(Step step, Match match) {
        super.beforeStep(step, match);
        String description = this.buildMultilineArgument(step).trim();
        if (!description.isEmpty()) {
            this.sendLog(description);
        }
    }

    @Override
    protected StartTestItemRQ buildStartHookRequest(boolean isBefore) {
        StartTestItemRQ rq = super.buildStartHookRequest(isBefore);
        rq.setHasStats(false);
        return rq;
    }

    @Override
    @Nonnull
    protected String getFeatureTestItemType() {
        return RP_TEST_TYPE;
    }

    @Override
    @Nonnull
    protected String getScenarioTestItemType() {
        return RP_STEP_TYPE;
    }

    @Override
    @Nonnull
    protected Optional<Maybe<String>> getRootItemId() {
        return Optional.of(this.rootSuiteId.get());
    }

    protected void finishRootItem() {
        if (this.rootSuiteId.isInitialized()) {
            this.finishTestItem((Maybe<String>)((Maybe)this.rootSuiteId.get()));
            this.rootSuiteId = null;
        }
    }

    @Override
    protected void afterLaunch() {
        if (this.currentFeatureContext.get() == null || ((RunningContext.FeatureContext)this.currentFeatureContext.get()).getId() == null) {
            LOGGER.debug("There is no scenarios in the launch");
            return;
        }
        this.finishRootItem();
        super.afterLaunch();
    }
}

