/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import gherkin.formatter.model.Step;
import io.reactivex.Maybe;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nonnull;

public class RunningContext {
    private RunningContext() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static class ScenarioContext {
        private boolean inBackground;
        private String stepPrefix = "";
        private Maybe<String> currentStepId;
        private Maybe<String> hookStepId;
        private ItemStatus hookStatus;
        private final Queue<Step> steps = new ArrayDeque<Step>();
        private final Queue<String> outlineIterations = new ArrayDeque<String>();
        private Maybe<String> id;
        private ItemStatus status = ItemStatus.PASSED;
        private Integer line;
        private String featureUri;

        @Nonnull
        public Queue<String> getOutlineIterations() {
            return this.outlineIterations;
        }

        public void setId(Maybe<String> id) {
            this.id = id;
        }

        public boolean isInBackground() {
            return this.inBackground;
        }

        public void setInBackground(boolean inBackground) {
            this.inBackground = inBackground;
        }

        public String getStepPrefix() {
            return this.stepPrefix;
        }

        public void setStepPrefix(String prefix) {
            this.stepPrefix = prefix;
        }

        public Maybe<String> getCurrentStepId() {
            return this.currentStepId;
        }

        public void setCurrentStepId(Maybe<String> currentStepId) {
            this.currentStepId = currentStepId;
        }

        public Maybe<String> getHookStepId() {
            return this.hookStepId;
        }

        public void setHookStepId(Maybe<String> hookStepId) {
            this.hookStepId = hookStepId;
        }

        public ItemStatus getHookStatus() {
            return this.hookStatus;
        }

        public void setHookStatus(ItemStatus hookStatus) {
            this.hookStatus = hookStatus;
        }

        public Maybe<String> getId() {
            return this.id;
        }

        public void addStep(Step step) {
            this.steps.add(step);
        }

        public Step getNextStep() {
            return this.steps.poll();
        }

        public boolean noMoreSteps() {
            return this.steps.isEmpty();
        }

        public void updateStatus(ItemStatus newStatus) {
            if (this.status != newStatus && ItemStatus.FAILED != this.status) {
                this.status = newStatus;
            }
        }

        public ItemStatus getStatus() {
            return this.status;
        }

        public Integer getLine() {
            return this.line;
        }

        public void setLine(Integer scenarioLine) {
            this.line = scenarioLine;
        }

        public void setFeatureUri(String featureUri) {
            this.featureUri = featureUri;
        }

        public String getFeatureUri() {
            return this.featureUri;
        }
    }

    public static class FeatureContext {
        private final String uri;
        private Maybe<String> id;
        private StartTestItemRQ itemRq;

        public FeatureContext(String featureUri) {
            this.uri = featureUri;
        }

        public void setId(Maybe<String> newId) {
            this.id = newId;
        }

        public Maybe<String> getId() {
            return this.id;
        }

        public StartTestItemRQ getItemRq() {
            return this.itemRq;
        }

        public void setItemRq(StartTestItemRQ startRq) {
            this.itemRq = startRq;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

