/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Function;
import rp.com.google.common.base.Strings;
import rp.com.google.common.collect.ImmutableMap;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String TABLE_SEPARATOR = "|";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final Map<String, String> STATUS_MAPPING = ImmutableMap.builder().put((Object)"passed", (Object)"PASSED").put((Object)"skipped", (Object)"SKIPPED").put((Object)"pending", (Object)"SKIPPED").put((Object)"undefined", (Object)"SKIPPED").build();

    private Utils() {
    }

    public static void finishTestItem(Launch rp, Maybe<String> itemId) {
        Utils.finishTestItem(rp, itemId, null);
    }

    public static void finishTestItem(Launch rp, Maybe<String> itemId, String status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setStatus(status);
        rq.setEndTime(Calendar.getInstance().getTime());
        rp.finishTestItem(itemId, rq);
    }

    public static Maybe<String> startNonLeafNode(Launch rp, Maybe<String> rootItemId, String name, String description, List<Tag> tags, String type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setDescription(description);
        rq.setName(name);
        rq.setTags(Utils.extractTags(tags));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(type);
        return rp.startTestItem(rootItemId, rq);
    }

    public static void sendLog(final String message, final String level, final SaveLogRQ.File file) {
        ReportPortal.emitLog((Function)new Function<String, SaveLogRQ>(){

            public SaveLogRQ apply(String item) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setMessage(message);
                rq.setTestItemId(item);
                rq.setLevel(level);
                rq.setLogTime(Calendar.getInstance().getTime());
                if (file != null) {
                    rq.setFile(file);
                }
                return rq;
            }
        });
    }

    public static Set<String> extractTags(List<Tag> tags) {
        HashSet<String> returnTags = new HashSet<String>();
        for (Tag tag : tags) {
            returnTags.add(tag.getName());
        }
        return returnTags;
    }

    public static String mapLevel(String cukesStatus) {
        String mapped = null;
        mapped = cukesStatus.equalsIgnoreCase("passed") ? "INFO" : (cukesStatus.equalsIgnoreCase("skipped") ? "WARN" : "ERROR");
        return mapped;
    }

    public static String mapStatus(String cukesStatus) {
        if (Strings.isNullOrEmpty((String)cukesStatus)) {
            return "FAILED";
        }
        String status = STATUS_MAPPING.get(cukesStatus.toLowerCase());
        return null == status ? "FAILED" : status;
    }

    public static String buildStatementName(BasicStatement stmt, String prefix, String infix, String suffix) {
        return (prefix == null ? "" : prefix) + stmt.getKeyword() + infix + stmt.getName() + (suffix == null ? "" : suffix);
    }

    public static String buildMultilineArgument(Step step) {
        List table = step.getRows();
        DocString ds = step.getDocString();
        StringBuilder marg = new StringBuilder();
        if (table != null) {
            marg.append("\r\n");
            for (Row row : table) {
                marg.append(TABLE_SEPARATOR);
                for (String cell : row.getCells()) {
                    marg.append(" ").append(cell).append(" ").append(TABLE_SEPARATOR);
                }
                marg.append("\r\n");
            }
        }
        if (ds != null) {
            marg.append(DOCSTRING_DECORATOR).append(ds.getValue()).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }
}

