/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.AbstractReporter;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import io.reactivex.Maybe;
import java.util.Calendar;

public class StepReporter
extends AbstractReporter {
    protected Maybe<String> currentStepId = null;
    protected Maybe<String> hookStepId = null;
    protected String hookStatus = null;

    @Override
    protected Maybe<String> getRootItemId() {
        return null;
    }

    @Override
    protected void beforeStep(Step step) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildStatementName((BasicStatement)step, this.stepPrefix, " ", null));
        rq.setDescription(Utils.buildMultilineArgument(step));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        this.currentStepId = ((Launch)this.RP.get()).startTestItem(this.currentScenario.getId(), rq);
    }

    @Override
    protected void afterStep(Result result) {
        this.reportResult(result, null);
        Utils.finishTestItem((Launch)this.RP.get(), this.currentStepId, Utils.mapStatus(result.getStatus()));
        this.currentStepId = null;
    }

    @Override
    protected void beforeHooks(Boolean isBefore) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(isBefore != false ? "Before hooks" : "After hooks");
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(isBefore != false ? "BEFORE_TEST" : "AFTER_TEST");
        this.hookStepId = ((Launch)this.RP.get()).startTestItem(this.currentScenario.getId(), rq);
        this.hookStatus = "PASSED";
    }

    @Override
    protected void afterHooks(Boolean isBefore) {
        Utils.finishTestItem((Launch)this.RP.get(), this.hookStepId, this.hookStatus);
        this.hookStepId = null;
    }

    @Override
    protected void hookFinished(Match match, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + match.getLocation());
        if (result.getStatus().equals("failed")) {
            this.hookStatus = "FAILED";
        }
    }

    @Override
    protected String getFeatureTestItemType() {
        return "SUITE";
    }

    @Override
    protected String getScenarioTestItemType() {
        return "SCENARIO";
    }
}

