/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\r5q!B#G\u0011\u0003\tf!B*G\u0011\u0003!\u0006BB6\u0002\t\u0003\u00119\u0010C\u0004\u0003z\u0006!\tEa>\t\u000f\tm\u0018\u0001\"\u0011\u0003~\"91\u0011A\u0001\u0005B\r\ra\u0001B*G\u0001\rD\u0001b\u001a\u0004\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\u0006W\u001a!\t\u0001\u001c\u0005\b]\u001a\u0011\r\u0011\"\u0003p\u0011\u00191h\u0001)A\u0005a\")qO\u0002C\u0001q\"I\u0011\u0011\u0002\u0004C\u0002\u0013E\u00111\u0002\u0005\t\u0003/1\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\u0004\u0004C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003G1\u0001\u0015!\u0003\u0002\u001e!I\u0011Q\u0005\u0004C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003O1\u0001\u0015!\u0003\u0002\u001e!I\u0011\u0011\u0006\u0004C\u0002\u0013\u0005\u00111\u0006\u0005\t\u0003g1\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0004C\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u00132\u0001\u0015!\u0003\u0002:!I\u00111\n\u0004C\u0002\u0013\u0005\u0011Q\n\u0005\t\u0003K2\u0001\u0015!\u0003\u0002P!I\u0011q\r\u0004C\u0002\u0013\u0005\u0011\u0011\u000e\u0005\t\u0003w2\u0001\u0015!\u0003\u0002l!9\u0011Q\u0010\u0004\u0005\u0002\u0005}\u0004bBAD\r\u0011\u0005\u00111\u0006\u0005\b\u0003\u00133A\u0011AAF\u0011\u001d\tiI\u0002C\u0001\u0003WAq!a$\u0007\t\u0003\t\t\nC\u0004\u0002$\u001a!\t!a \t\u000f\u0005\u0015f\u0001\"\u0001\u0002(\"I\u0011Q\u0016\u0004\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\b\u0003\u000b4A\u0011AAd\u0011\u001d\tYM\u0002C\u0001\u0003\u001bDq!!5\u0007\t\u0003\ty\bC\u0004\u0002T\u001a!\t!!6\t\u000f\u0005eg\u0001\"\u0001\u0002\\\"I\u0011q \u0004\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u000b1\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\u0002\u0007#\u0003%\tA!\u0003\t\u000f\t5a\u0001\"\u0001\u0003\u0010!I!q\u0004\u0004\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005C1\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\t\u0007#\u0003%\tA!\u0003\t\u000f\t\u0015b\u0001\"\u0001\u0003(!9!1\u0006\u0004\u0005\u0002\t5\u0002b\u0002B\u0019\r\u0011\u0005!1\u0007\u0005\n\u0005\u007f1\u0011\u0013!C\u0001\u0005\u0003A\u0011B!\u0011\u0007#\u0003%\tA!\u0001\t\u0013\t\rc!%A\u0005\u0002\t%\u0001b\u0002B#\r\u0011\u0005!q\t\u0005\n\u0005/2\u0011\u0013!C\u0001\u0005\u0003A\u0011B!\u0017\u0007#\u0003%\tA!\u0001\t\u0013\tmc!%A\u0005\u0002\t%\u0001b\u0002B/\r\u0011%!q\f\u0005\b\u0005G2A\u0011\u0001B3\u0011\u001d\u0011\u0019G\u0002C\u0001\u0005[BqAa\u0019\u0007\t\u0003\u0011Y\bC\u0004\u0003d\u0019!\tA!#\t\u000f\t\rd\u0001\"\u0001\u0003\u0016\"9!1\r\u0004\u0005\u0002\t}\u0005b\u0002BU\r\u0011%!1\u0016\u0005\b\u0005k3A\u0011\u0003B\\\u0011\u001d\u0011)M\u0002C\t\u0003\u007fB!Ba2\u0007\u0011\u000b\u0007I\u0011\u0003Be\u0011)\u00119N\u0002EC\u0002\u0013E!\u0011\u001c\u0005\u000b\u0005O4\u0001R1A\u0005\u0012\t%\u0018\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u0011q\tS\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005%S\u0015!C3yi\u0016t7/[8o\u0015\tYE*\u0001\u0003bW.\f'BA'O\u0003!!\u0018\u0010]3tC\u001a,'\"A(\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005I\u000bQ\"\u0001$\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gnE\u0003\u0002+n\u0013\t\u0010\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VM\u001a\t\u00049\u0002\u0014W\"A/\u000b\u0005y{\u0016!B1di>\u0014(\"A&\n\u0005\u0005l&aC#yi\u0016t7/[8o\u0013\u0012\u0004\"A\u0015\u0004\u0014\u0007\u0019)F\r\u0005\u0002]K&\u0011a-\u0018\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016l\u0007C\u0001/j\u0013\tQWLA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0003E6DQa\u001a\u0005A\u0002!\f1\u0001\\8h+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:`\u0003\u0015)g/\u001a8u\u0013\t)(O\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000eg\u000eDW\rZ;mKJt\u0015-\\3\u0016\u0003e\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}/6\tQP\u0003\u0002\u007f!\u00061AH]8pizJ1!!\u0001X\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A,\u0002\r\r|gNZ5h+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005MQBAA\t\u0015\r\tI\u0001T\u0005\u0005\u0003+\t\tB\u0001\u0004D_:4\u0017nZ\u0001\bG>tg-[4!\u0003-!\bN]3bI\u000e{WO\u001c;\u0016\u0005\u0005u\u0001c\u0001,\u0002 %\u0019\u0011\u0011E,\u0003\u0007%sG/\u0001\u0007uQJ,\u0017\rZ\"pk:$\b%\u0001\buQJ,\u0017\r\u001a)sS>\u0014\u0018\u000e^=\u0002\u001fQD'/Z1e!JLwN]5us\u0002\nA\u0003Z1f[>tG\u000b\u001b:fC\u0012\u001cx\fJ9nCJ\\WCAA\u0017!\r1\u0016qF\u0005\u0004\u0003c9&a\u0002\"p_2,\u0017M\\\u0001\u0016I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6!\u0003=!WMZ1vYR$\u0016.\\3{_:,WCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA!\u001e;jY*\u0011\u00111I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005u\"\u0001\u0003+j[\u0016TvN\\3\u0002!\u0011,g-Y;miRKW.\u001a>p]\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3t+\t\ty\u0005E\u0004\u0002R\u0005m\u00130a\u0018\u000e\u0005\u0005M#\u0002BA+\u0003/\n!bY8oGV\u0014(/\u001a8u\u0015\r\tIfV\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003'\u0012q\u0001\u0016:jK6\u000b\u0007\u000fE\u0002S\u0003CJ1!a\u0019G\u00059\tV/\u0019:uuN\u001b\u0007.\u001a3vY\u0016\f!b]2iK\u0012,H.Z:!\u0003-\u0011XO\u001c8j]\u001eTuNY:\u0016\u0005\u0005-\u0004cBA)\u00037J\u0018Q\u000e\t\u0005\u0003_\n9(\u0004\u0002\u0002r)\u0019q)a\u001d\u000b\u0005\u0005U\u0014aA8sO&!\u0011\u0011PA9\u0005\u0019QuNY&fs\u0006a!/\u001e8oS:<'j\u001c2tA\u000591\u000f^1oI\nLHCAAA!\r1\u00161Q\u0005\u0004\u0003\u000b;&\u0001B+oSR\fq\"[:J]N#\u0018M\u001c3cs6{G-Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003[\t\u0011\"[:Ti\u0006\u0014H/\u001a3\u0002\u00179,\u0007\u0010\u001e+sS\u001e<WM\u001d\u000b\u0005\u0003'\u000by\nE\u0003W\u0003+\u000bI*C\u0002\u0002\u0018^\u0013aa\u00149uS>t\u0007\u0003BA\u001e\u00037KA!!(\u0002>\t!A)\u0019;f\u0011\u0019\t\tK\ba\u0001s\u0006!a.Y7f\u0003)\u0019Xo\u001d9f]\u0012\fE\u000e\\\u0001\tg\",H\u000fZ8x]R!\u0011\u0011QAU\u0011%\tY\u000b\tI\u0001\u0002\u0004\ti#A\u000bxC&$hi\u001c:K_\n\u001cHk\\\"p[BdW\r^3\u0002%MDW\u000f\u001e3po:$C-\u001a4bk2$H%M\u000b\u0003\u0003cSC!!\f\u00024.\u0012\u0011Q\u0017\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003%)hn\u00195fG.,GMC\u0002\u0002@^\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019-!/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006tkN\u0004XM\u001c3K_\n$B!!\f\u0002J\"1\u0011\u0011\u0015\u0012A\u0002e\f\u0011B]3tk6,'j\u001c2\u0015\t\u00055\u0012q\u001a\u0005\u0007\u0003C\u001b\u0003\u0019A=\u0002\u0013I,7/^7f\u00032d\u0017!C2b]\u000e,GNS8c)\u0011\ti#a6\t\r\u0005\u0005V\u00051\u0001z\u0003E\u0019'/Z1uK*{'mU2iK\u0012,H.\u001a\u000b\u0011\u00033\u000bi.a8\u0002j\u00065\u00181_A|\u0003wDa!!)'\u0001\u0004I\bbBAqM\u0001\u0007\u00111]\u0001\te\u0016\u001cW-\u001b<feB\u0019A,!:\n\u0007\u0005\u001dXL\u0001\u0005BGR|'OU3g\u0011\u0019\tYO\na\u0001+\u0006\u0019Qn]4\t\u0013\u0005=h\u0005%AA\u0002\u0005E\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004BAVAKs\"1\u0011Q\u001f\u0014A\u0002e\fab\u0019:p]\u0016C\bO]3tg&|g\u000eC\u0005\u0002z\u001a\u0002\n\u00111\u0001\u0002r\u0006A1-\u00197f]\u0012\f'\u000fC\u0005\u0002~\u001a\u0002\n\u00111\u0001\u0002:\u0005AA/[7fu>tW-A\u000ede\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0007QC!!=\u00024\u0006Y2M]3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIY\n1d\u0019:fCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u0012:TC\u0001B\u0006U\u0011\tI$a-\u0002#U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\u0006\t\u0002\u001a\nE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e!1\u0011\u0011\u0015\u0016A\u0002eDq!!9+\u0001\u0004\t\u0019\u000f\u0003\u0004\u0002l*\u0002\r!\u0016\u0005\n\u0003_T\u0003\u0013!a\u0001\u0003cDa!!>+\u0001\u0004I\b\"CA}UA\u0005\t\u0019AAy\u0011%\tiP\u000bI\u0001\u0002\u0004\tI$A\u000eva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u0001\u001ckB$\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001c\u00027U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00138\u0003E!W\r\\3uK*{'mU2iK\u0012,H.\u001a\u000b\u0005\u0003[\u0011I\u0003\u0003\u0004\u0002\":\u0002\r!_\u0001\u000ek:\u001c8\r[3ek2,'j\u001c2\u0015\t\u00055\"q\u0006\u0005\u0007\u0003C{\u0003\u0019A=\u0002\u001d\r\u0014X-\u0019;f'\u000eDW\rZ;mKRa\u0011\u0011\u0011B\u001b\u0005o\u0011IDa\u000f\u0003>!1\u0011\u0011\u0015\u0019A\u0002eD\u0011\"a<1!\u0003\u0005\r!!=\t\r\u0005U\b\u00071\u0001z\u0011%\tI\u0010\rI\u0001\u0002\u0004\t\t\u0010C\u0005\u0002~B\u0002\n\u00111\u0001\u0002:\u0005A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001a\u00021\r\u0014X-\u0019;f'\u000eDW\rZ;mK\u0012\"WMZ1vYR$C'\u0001\rde\u0016\fG/Z*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIU\nQB]3tG\",G-\u001e7f\u0015>\u0014G\u0003EAM\u0005\u0013\u0012YE!\u0014\u0003P\tE#1\u000bB+\u0011\u0019\t\t\u000b\u000ea\u0001s\"9\u0011\u0011\u001d\u001bA\u0002\u0005\r\bBBAvi\u0001\u0007Q\u000bC\u0005\u0002pR\u0002\n\u00111\u0001\u0002r\"1\u0011Q\u001f\u001bA\u0002eD\u0011\"!?5!\u0003\u0005\r!!=\t\u0013\u0005uH\u0007%AA\u0002\u0005e\u0012a\u0006:fg\u000eDW\rZ;mK*{'\r\n3fM\u0006,H\u000e\u001e\u00135\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$c'A\fsKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0013eK\u001a\fW\u000f\u001c;%o\u0005q!/Z7pm\u0016\u001c6\r[3ek2,G\u0003BA(\u0005CBa!!)9\u0001\u0004I\u0018\u0001C:dQ\u0016$W\u000f\\3\u0015\u0011\u0005e%q\rB5\u0005WBa!!):\u0001\u0004I\bbBAqs\u0001\u0007\u00111\u001d\u0005\u0007\u0003WL\u0004\u0019A+\u0015\u0011\u0005e%q\u000eB9\u0005sBa!!);\u0001\u0004I\bbBAqu\u0001\u0007!1\u000f\t\u00049\nU\u0014b\u0001B<;\nq\u0011i\u0019;peN+G.Z2uS>t\u0007BBAvu\u0001\u0007Q\u000b\u0006\u0005\u0002\u001a\nu$q\u0010BD\u0011\u0019\t\tk\u000fa\u0001s\"9\u0011\u0011]\u001eA\u0002\t\u0005\u0005cA9\u0003\u0004&\u0019!Q\u0011:\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\u001c\u0005\u0007\u0003W\\\u0004\u0019A+\u0015\u0015\u0005e%1\u0012BG\u0005\u001f\u0013\t\n\u0003\u0004\u0002\"r\u0002\r!\u001f\u0005\b\u0003Cd\u0004\u0019AAr\u0011\u0019\tY\u000f\u0010a\u0001+\"9!1\u0013\u001fA\u0002\u0005M\u0015!C:uCJ$H)\u0019;f))\tIJa&\u0003\u001a\nm%Q\u0014\u0005\u0007\u0003Ck\u0004\u0019A=\t\u000f\u0005\u0005X\b1\u0001\u0003t!1\u00111^\u001fA\u0002UCqAa%>\u0001\u0004\t\u0019\n\u0006\u0006\u0002\u001a\n\u0005&1\u0015BS\u0005OCa!!)?\u0001\u0004I\bbBAq}\u0001\u0007!\u0011\u0011\u0005\u0007\u0003Wt\u0004\u0019A+\t\u000f\tMe\b1\u0001\u0002\u0014\u0006\u00012o\u00195fIVdW-\u00138uKJt\u0017\r\u001c\u000b\u000b\u00033\u0013iKa,\u00032\nM\u0006BBAQ\u007f\u0001\u0007\u0011\u0010\u0003\u0004\u0002b~\u0002\r!\u0016\u0005\u0007\u0003W|\u0004\u0019A+\t\u000f\tMu\b1\u0001\u0002\u0014\u0006Y1o\u00195fIVdWMS8c))\u0011IL!0\u0003@\n\u0005'1\u0019\u000b\u0005\u00033\u0013Y\fC\u0004\u0003d\u0001\u0003\r!a\u0018\t\r\u0005\u0005\u0006\t1\u0001z\u0011\u0019\t\t\u000f\u0011a\u0001+\"1\u00111\u001e!A\u0002UCqAa%A\u0001\u0004\t\u0019*A\nj]&$\u0018.\u00197jg\u0016\u001c\u0015\r\\3oI\u0006\u00148/\u0001\u0006uQJ,\u0017\r\u001a)p_2,\"Aa3\u0011\t\t5'1[\u0007\u0003\u0005\u001fTAA!5\u0002r\u0005)1/[7qY&!!Q\u001bBh\u0005A\u0019\u0016.\u001c9mKRC'/Z1e!>|G.\u0001\u0005k_\n\u001cFo\u001c:f+\t\u0011Y\u000e\u0005\u0003\u0003^\n\rXB\u0001Bp\u0015\u0011\u0011\t/!\u001d\u0002\u0007M\u0004\u0018.\u0003\u0003\u0003f\n}'\u0001\u0003&pEN#xN]3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XC\u0001Bv!\u0011\tyG!<\n\t\t=\u0018\u0011\u000f\u0002\n'\u000eDW\rZ;mKJ\u00042\u0001\u0018Bz\u0013\r\u0011)0\u0018\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u000b\u0002#\u00061An\\8lkB\fqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004E\n}\b\"B4\u0005\u0001\u0004A\u0017aA4fiR\u0019!m!\u0002\t\r\u001d,\u0001\u0019AB\u0004!\ra6\u0011B\u0005\u0004\u0007\u0017i&aC!di>\u00148+_:uK6\u0004")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Config config;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap<String, QuartzSchedule> schedules;
    private final TrieMap<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.config;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        boolean bl2 = this.isStarted();
        if (bl2) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else if (!bl2) {
            this.scheduler().start();
            bl = true;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        boolean isJobCancelled = this.cancelJob(name);
        TrieMap<String, QuartzSchedule> trieMap = isJobCancelled ? this.removeSchedule(name) : BoxedUnit.UNIT;
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression expr;
        Either either = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable)() -> new CronExpression(cronExpression));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        CronExpression cronExpression2 = expr = (CronExpression)right.value();
        CronExpression expression = cronExpression2;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option option = this.schedules().putIfAbsent((Object)name, (Object)schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq((Object)name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name, calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.config = system.settings().config().getConfig("akka.quartz").root().toConfig();
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable)() -> "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq(QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

