/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs.io;

import com.emc.ecs.nfsclient.nfs.Nfs;
import com.emc.ecs.nfsclient.nfs.NfsAccessRequest;
import com.emc.ecs.nfsclient.nfs.NfsAccessResponse;
import com.emc.ecs.nfsclient.nfs.NfsCommitRequest;
import com.emc.ecs.nfsclient.nfs.NfsCommitResponse;
import com.emc.ecs.nfsclient.nfs.NfsCreateMode;
import com.emc.ecs.nfsclient.nfs.NfsCreateRequest;
import com.emc.ecs.nfsclient.nfs.NfsCreateResponse;
import com.emc.ecs.nfsclient.nfs.NfsDirectoryEntry;
import com.emc.ecs.nfsclient.nfs.NfsDirectoryPlusEntry;
import com.emc.ecs.nfsclient.nfs.NfsException;
import com.emc.ecs.nfsclient.nfs.NfsFsInfoRequest;
import com.emc.ecs.nfsclient.nfs.NfsFsInfoResponse;
import com.emc.ecs.nfsclient.nfs.NfsFsStatRequest;
import com.emc.ecs.nfsclient.nfs.NfsFsStatResponse;
import com.emc.ecs.nfsclient.nfs.NfsGetAttrRequest;
import com.emc.ecs.nfsclient.nfs.NfsGetAttrResponse;
import com.emc.ecs.nfsclient.nfs.NfsGetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsLinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsLinkResponse;
import com.emc.ecs.nfsclient.nfs.NfsLookupRequest;
import com.emc.ecs.nfsclient.nfs.NfsLookupResponse;
import com.emc.ecs.nfsclient.nfs.NfsMkdirRequest;
import com.emc.ecs.nfsclient.nfs.NfsMkdirResponse;
import com.emc.ecs.nfsclient.nfs.NfsMknodRequest;
import com.emc.ecs.nfsclient.nfs.NfsMknodResponse;
import com.emc.ecs.nfsclient.nfs.NfsPathconfRequest;
import com.emc.ecs.nfsclient.nfs.NfsPathconfResponse;
import com.emc.ecs.nfsclient.nfs.NfsReadRequest;
import com.emc.ecs.nfsclient.nfs.NfsReadResponse;
import com.emc.ecs.nfsclient.nfs.NfsReaddirRequest;
import com.emc.ecs.nfsclient.nfs.NfsReaddirResponse;
import com.emc.ecs.nfsclient.nfs.NfsReaddirplusRequest;
import com.emc.ecs.nfsclient.nfs.NfsReaddirplusResponse;
import com.emc.ecs.nfsclient.nfs.NfsReadlinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsReadlinkResponse;
import com.emc.ecs.nfsclient.nfs.NfsRemoveRequest;
import com.emc.ecs.nfsclient.nfs.NfsRemoveResponse;
import com.emc.ecs.nfsclient.nfs.NfsRenameRequest;
import com.emc.ecs.nfsclient.nfs.NfsRenameResponse;
import com.emc.ecs.nfsclient.nfs.NfsRmdirRequest;
import com.emc.ecs.nfsclient.nfs.NfsRmdirResponse;
import com.emc.ecs.nfsclient.nfs.NfsSetAttrRequest;
import com.emc.ecs.nfsclient.nfs.NfsSetAttrResponse;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsStatus;
import com.emc.ecs.nfsclient.nfs.NfsSymlinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsSymlinkResponse;
import com.emc.ecs.nfsclient.nfs.NfsTime;
import com.emc.ecs.nfsclient.nfs.NfsType;
import com.emc.ecs.nfsclient.nfs.NfsWriteRequest;
import com.emc.ecs.nfsclient.nfs.NfsWriteResponse;
import com.emc.ecs.nfsclient.nfs.io.LinkTracker;
import com.emc.ecs.nfsclient.nfs.io.NfsFile;
import com.emc.ecs.nfsclient.nfs.io.NfsFileFilter;
import com.emc.ecs.nfsclient.nfs.io.NfsFilenameFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class NfsFileBase<N extends Nfs<F>, F extends NfsFile<N, F>>
implements NfsFile<N, F> {
    private String _absolutePath;
    private F _backingFile;
    private boolean _isRootFile = false;
    private byte[] _fileHandle;
    private String _name;
    private final N _nfs;
    private String _parent;
    private F _parentFile;
    private String _path;

    public NfsFileBase(N nfs, String path, LinkTracker<N, F> linkTracker) throws IOException {
        if (nfs == null) {
            throw new IllegalArgumentException("Nfs instance can not be null");
        }
        this._nfs = nfs;
        this._parent = NfsFileBase.makeParentPath(path);
        F parent = this.isRootPath(path) ? null : (F)this.newFile(this._parent, linkTracker);
        this.setParentFileAndName(parent, NfsFileBase.makeName(path), linkTracker);
    }

    public NfsFileBase(F parentFile, String childName) throws IOException {
        this._nfs = parentFile.getNfs();
        this.setParentFileAndName(parentFile, childName, null);
    }

    public static String makeParentPath(String path) {
        int firstParentSeparatorIndex;
        for (firstParentSeparatorIndex = NfsFileBase.getParentSeparatorIndex(path); firstParentSeparatorIndex > 0 && '/' == path.charAt(firstParentSeparatorIndex); --firstParentSeparatorIndex) {
        }
        int lengthOfParentName = firstParentSeparatorIndex == 0 ? 1 : firstParentSeparatorIndex + 2;
        return path.substring(0, lengthOfParentName);
    }

    public static String makeName(String path) {
        int nameStartIndex = NfsFileBase.getParentSeparatorIndex(path) + 1;
        int endOfNameIndex = path.indexOf(47, nameStartIndex);
        if (endOfNameIndex < 0) {
            endOfNameIndex = path.length();
        }
        return path.substring(nameStartIndex, endOfNameIndex);
    }

    public static String makeChildPath(String parent, String child) {
        StringBuilder stringBuilder = new StringBuilder(parent.replaceAll("/+", "/"));
        if (!parent.endsWith("/")) {
            stringBuilder.append('/');
        }
        return stringBuilder.append(child).toString();
    }

    private static int getParentSeparatorIndex(String path) {
        int firstTerminalSeparatorIndex;
        for (firstTerminalSeparatorIndex = path.length() - 1; firstTerminalSeparatorIndex > 0 && '/' == path.charAt(firstTerminalSeparatorIndex); --firstTerminalSeparatorIndex) {
        }
        return path.lastIndexOf(47, firstTerminalSeparatorIndex);
    }

    @Override
    public boolean canDelete() throws IOException {
        return this.canAccess(16L);
    }

    @Override
    public boolean canExecute() throws IOException {
        return this.canAccess(32L);
    }

    @Override
    public boolean canExtend() throws IOException {
        return this.canAccess(8L);
    }

    @Override
    public boolean canLookup() throws IOException {
        return this.canAccess(2L);
    }

    @Override
    public boolean canModify() throws IOException {
        return this.canAccess(4L);
    }

    @Override
    public boolean canRead() throws IOException {
        return this.canAccess(1L);
    }

    @Override
    public final int compareTo(F o) {
        if (o == null) {
            return 1;
        }
        return this.getAbsolutePath().compareTo(o.getAbsolutePath());
    }

    @Override
    public boolean createNewFile() throws IOException {
        try {
            this.create(NfsCreateMode.GUARDED, new NfsSetAttributes(), null);
        }
        catch (NfsException e) {
            if (e.getStatus() == NfsStatus.NFS3ERR_EXIST) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public void delete() throws IOException {
        if (this.isDirectory()) {
            this.rmdir();
        } else {
            this.remove();
        }
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof NfsFile)) {
            return false;
        }
        return this.getAbsolutePath().equals(((NfsFile)obj).getAbsolutePath());
    }

    @Override
    public boolean exists() throws IOException {
        boolean exists = false;
        try {
            this.setFileHandle(null);
            exists = this.getFileHandle() != null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return exists;
    }

    @Override
    public F followLinks() throws IOException {
        return this.followLinks(null);
    }

    @Override
    public F followLinks(LinkTracker<N, F> linkTracker) throws IOException {
        if (this._backingFile == null) {
            NfsFileBase<N, F> backingFile = this;
            NfsGetAttributes attributes = this.safeGetAttributes(backingFile);
            while (NfsType.NFS_LNK == attributes.getType()) {
                F newBackingFile;
                if (linkTracker == null) {
                    linkTracker = new LinkTracker();
                }
                backingFile = (newBackingFile = linkTracker.addLink(backingFile.getPath())) != null ? newBackingFile : this.followLink(backingFile.readlink().getData(), linkTracker);
                attributes = this.safeGetAttributes(backingFile);
            }
            this._backingFile = backingFile;
            if (linkTracker != null) {
                linkTracker.addResolvedPath(this.getPath(), this._backingFile);
            }
        }
        return this._backingFile;
    }

    private NfsGetAttributes safeGetAttributes(F file) {
        if (file != null) {
            try {
                return file.getAttributes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NfsGetAttributes();
    }

    private F followLink(String target, LinkTracker<N, F> linkTracker) throws IOException {
        String path;
        if (StringUtils.isBlank((String)target)) {
            throw new IOException("blank link target");
        }
        if (!target.contains("/")) {
            return this.getParentFile().newChildFile(target);
        }
        if (target.startsWith("/")) {
            if (!target.startsWith(this.getNfs().getExportedPath())) {
                throw new IOException("unreachable link target: " + target);
            }
            path = target.substring(this.getNfs().getExportedPath().length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
        } else {
            String parentPath = this.getParentFile().getPath();
            path = parentPath.endsWith("/") ? parentPath + target : parentPath + "/" + target;
        }
        return this.newFile(path, linkTracker);
    }

    @Override
    public final String getAbsolutePath() {
        return this._absolutePath;
    }

    @Override
    public long getAccess(long accessToCheck) throws IOException {
        return this.access(accessToCheck).getAccess();
    }

    @Override
    public NfsGetAttributes getAttributes() throws IOException {
        return this.getNfs().wrapped_getAttr(this.getNfs().makeGetAttrRequest(this.getFileHandle())).getAttributes();
    }

    @Override
    public F getChildFile(String childName) throws IOException {
        return this.newChildFile(childName);
    }

    @Override
    public byte[] getFileHandle() throws IOException {
        if (this._isRootFile) {
            return this.getNfs().getRootFileHandle();
        }
        if (this._fileHandle == null) {
            this.setFileHandle();
        }
        return this._fileHandle == null ? null : (byte[])this._fileHandle.clone();
    }

    @Override
    public long getFreeSpace() throws IOException {
        return this.fsstat().getFsStat().fbytes;
    }

    @Override
    public long getMode() throws IOException {
        return this.getAttributes().getMode();
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final N getNfs() {
        return this._nfs;
    }

    @Override
    public final String getParent() {
        return this._parent;
    }

    @Override
    public F getParentFile() {
        return this._parentFile;
    }

    @Override
    public final String getPath() {
        return this._path;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.fsstat().getFsStat().tbytes;
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.fsstat().getFsStat().bytes;
    }

    public final int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getAttributes().getType() == NfsType.NFS_DIR;
    }

    @Override
    public boolean isFile() throws IOException {
        return this.getAttributes().getType() == NfsType.NFS_REG;
    }

    @Override
    public boolean isRootFile() throws IOException {
        return this._isRootFile;
    }

    @Override
    public long lastModified() throws IOException {
        return this.getAttributes().getMtime().getTimeInMillis();
    }

    @Override
    public long length() {
        try {
            return this.lengthEx();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public long lengthEx() throws IOException {
        return this.getAttributes().getSize();
    }

    @Override
    public List<String> list() throws IOException {
        boolean eof = false;
        long cookie = 0L;
        long cookieverf = 0L;
        int count = 8192;
        ArrayList<NfsDirectoryEntry> entries = new ArrayList<NfsDirectoryEntry>(32);
        do {
            NfsReaddirResponse response = this.readdir(cookie, cookieverf, 8192, entries);
            eof = response.isEof();
            cookie = response.getCookie();
            cookieverf = response.getCookieverf();
        } while (!eof);
        ArrayList<String> children = new ArrayList<String>();
        for (NfsDirectoryEntry entry : entries) {
            if (".".equals(entry.getFileName()) || "..".equals(entry.getFileName())) continue;
            children.add(entry.getFileName());
        }
        return children;
    }

    @Override
    public List<String> list(NfsFilenameFilter filter) throws IOException {
        List<String> children = this.list();
        if (children == null || children.size() == 0 || filter == null) {
            return children;
        }
        ArrayList<String> filteredChildren = new ArrayList<String>();
        for (String child : children) {
            if (!filter.accept(this, child)) continue;
            filteredChildren.add(child);
        }
        return filteredChildren;
    }

    @Override
    public List<F> listFiles() throws IOException {
        return this.getChildFiles(this.list());
    }

    @Override
    public List<F> listFiles(NfsFilenameFilter filter) throws IOException {
        return this.getChildFiles(this.list(filter));
    }

    @Override
    public List<F> listFiles(NfsFileFilter filter) throws IOException {
        List<F> childFiles = this.listFiles();
        if (childFiles == null || childFiles.size() == 0 || filter == null) {
            return childFiles;
        }
        ArrayList<NfsFile> filteredFiles = new ArrayList<NfsFile>();
        for (NfsFile childFile : childFiles) {
            if (!filter.accept(childFile)) continue;
            filteredFiles.add(childFile);
        }
        return filteredFiles;
    }

    @Override
    public void mkdir() throws IOException {
        this.mkdir(new NfsSetAttributes());
    }

    @Override
    public void mkdirs() throws IOException {
        if (!this.getParent().equals("/") && !this.getParentFile().exists()) {
            this.getParentFile().mkdirs();
        }
        this.mkdir();
    }

    @Override
    public boolean renameTo(F destination) throws IOException {
        return this.rename(destination).stateIsOk();
    }

    @Override
    public void setLastModified(long millis) throws IOException {
        this.setAttributes(new NfsSetAttributes(null, null, null, NfsTime.DO_NOT_CHANGE, new NfsTime(millis)));
    }

    public final String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public void setAttributes(NfsSetAttributes nfsSetAttr) throws IOException {
        this.setattr(nfsSetAttr, null);
    }

    @Override
    public void setMode(long mode) throws IOException {
        this.setAttributes(new NfsSetAttributes(mode, null, null, NfsTime.DO_NOT_CHANGE, NfsTime.DO_NOT_CHANGE));
    }

    @Override
    public NfsGetAttrResponse getattr() throws IOException {
        return this.getNfs().wrapped_getAttr(this.makeGetAttrRequest());
    }

    @Override
    public NfsGetAttrRequest makeGetAttrRequest() throws IOException {
        return this.getNfs().makeGetAttrRequest(this.getFileHandle());
    }

    @Override
    public NfsSetAttrResponse setattr(NfsSetAttributes attributes, NfsTime guardTime) throws IOException {
        return this.getNfs().wrapped_setAttr(this.makeSetAttrRequest(attributes, guardTime));
    }

    @Override
    public NfsSetAttrRequest makeSetAttrRequest(NfsSetAttributes attributes, NfsTime guardTime) throws IOException {
        return this.getNfs().makeSetAttrRequest(this.getFileHandle(), attributes, guardTime);
    }

    @Override
    public NfsLookupResponse lookup() throws IOException {
        return this.getNfs().wrapped_getLookup(this.makeLookupRequest());
    }

    @Override
    public NfsLookupRequest makeLookupRequest() throws IOException {
        return this.getNfs().makeLookupRequest(this.getParentFile().getFileHandle(), this.getName());
    }

    @Override
    public NfsAccessResponse access(long accessToCheck) throws IOException {
        return this.getNfs().wrapped_getAccess(this.makeAccessRequest(accessToCheck));
    }

    @Override
    public NfsAccessRequest makeAccessRequest(long accessToCheck) throws IOException {
        return this.getNfs().makeAccessRequest(this.getFileHandle(), accessToCheck);
    }

    @Override
    public NfsReadlinkResponse readlink() throws IOException {
        return this.getNfs().wrapped_getReadlink(this.makeReadlinkRequest());
    }

    @Override
    public NfsReadlinkRequest makeReadlinkRequest() throws IOException {
        return this.getNfs().makeReadlinkRequest(this.getFileHandle());
    }

    @Override
    public NfsReadResponse read(long offset, int size, byte[] bytes, int position) throws IOException {
        return this.getNfs().wrapped_getRead(this.makeReadRequest(offset, size), bytes, position);
    }

    @Override
    public NfsReadRequest makeReadRequest(long offset, int size) throws IOException {
        return this.getNfs().makeReadRequest(this.getFileHandle(), offset, size);
    }

    @Override
    public NfsWriteResponse write(long offset, List<ByteBuffer> payload, int syncType) throws IOException {
        return this.getNfs().wrapped_sendWrite(this.makeWriteRequest(offset, payload, syncType));
    }

    @Override
    public NfsWriteResponse write(long offset, List<ByteBuffer> payload, int syncType, Long verifier) throws IOException {
        return this.getNfs().wrapped_sendWrite(this.makeWriteRequest(offset, payload, syncType), verifier);
    }

    @Override
    public NfsWriteRequest makeWriteRequest(long offset, List<ByteBuffer> payload, int syncType) throws IOException {
        return this.getNfs().makeWriteRequest(this.getFileHandle(), offset, payload, syncType);
    }

    @Override
    public NfsCreateResponse create(NfsCreateMode createMode, NfsSetAttributes attributes, byte[] verifier) throws IOException {
        NfsCreateResponse response = this.getNfs().wrapped_sendCreate(this.getNfs().makeCreateRequest(createMode, this.getParentFile().getFileHandle(), this.getName(), attributes, verifier));
        this.setFileHandle(response.getFileHandle());
        return response;
    }

    @Override
    public NfsCreateRequest makeCreateRequest(NfsCreateMode createMode, NfsSetAttributes attributes, byte[] verifier) throws IOException {
        return this.getNfs().makeCreateRequest(createMode, this.getParentFile().getFileHandle(), this.getName(), attributes, verifier);
    }

    @Override
    public NfsMkdirResponse mkdir(NfsSetAttributes attributes) throws IOException {
        NfsMkdirResponse response = this.getNfs().wrapped_sendMkdir(this.makeMkdirRequest(attributes));
        this.setFileHandle(response.getFileHandle());
        return response;
    }

    @Override
    public NfsMkdirRequest makeMkdirRequest(NfsSetAttributes attributes) throws IOException {
        return this.getNfs().makeMkdirRequest(this.getParentFile().getFileHandle(), this.getName(), attributes);
    }

    @Override
    public NfsSymlinkResponse symlink(String symbolicLinkData, NfsSetAttributes attributes) throws IOException {
        NfsSymlinkResponse response = this.getNfs().wrapped_sendSymlink(this.makeSymlinkRequest(symbolicLinkData, attributes));
        this.setFileHandle(response.getFileHandle());
        return response;
    }

    @Override
    public NfsSymlinkRequest makeSymlinkRequest(String symbolicLinkData, NfsSetAttributes attributes) throws IOException {
        return this.getNfs().makeSymlinkRequest(symbolicLinkData, this.getParentFile().getFileHandle(), this.getName(), attributes);
    }

    @Override
    public NfsMknodResponse mknod(NfsType type, NfsSetAttributes attributes, long[] rdev) throws IOException {
        NfsMknodResponse response = this.getNfs().wrapped_sendMknod(this.makeMknodRequest(type, attributes, rdev));
        this.setFileHandle(response.getFileHandle());
        return response;
    }

    @Override
    public NfsMknodRequest makeMknodRequest(NfsType type, NfsSetAttributes attributes, long[] rdev) throws IOException {
        return this.getNfs().makeMknodRequest(this.getParentFile().getFileHandle(), this.getName(), type, attributes, rdev);
    }

    @Override
    public NfsRemoveResponse remove() throws IOException {
        NfsRemoveResponse response = this.getNfs().wrapped_sendRemove(this.makeRemoveRequest());
        this.setFileHandle(null);
        return response;
    }

    @Override
    public NfsRemoveRequest makeRemoveRequest() throws IOException {
        return this.getNfs().makeRemoveRequest(this.getParentFile().getFileHandle(), this.getName());
    }

    @Override
    public NfsRmdirResponse rmdir() throws IOException {
        NfsRmdirResponse response = this.getNfs().wrapped_sendRmdir(this.makeRmdirRequest());
        this.setFileHandle(null);
        return response;
    }

    @Override
    public NfsRmdirRequest makeRmdirRequest() throws IOException {
        return this.getNfs().makeRmdirRequest(this.getParentFile().getFileHandle(), this.getName());
    }

    @Override
    public NfsRenameResponse rename(F toFile) throws IOException {
        NfsRenameResponse response = this.getNfs().wrapped_sendRename(this.makeRenameRequest(toFile));
        if (response.stateIsOk()) {
            this.setPathFields(toFile);
        }
        return response;
    }

    @Override
    public NfsRenameRequest makeRenameRequest(F toFile) throws IOException {
        return this.getNfs().makeRenameRequest(this.getParentFile().getFileHandle(), this.getName(), toFile.getParentFile().getFileHandle(), toFile.getName());
    }

    @Override
    public NfsLinkResponse link(F source) throws IOException {
        NfsLinkResponse response = this.getNfs().wrapped_sendLink(this.makeLinkRequest(source));
        this.setFileHandle(source.getFileHandle());
        return response;
    }

    @Override
    public NfsLinkRequest makeLinkRequest(F source) throws IOException {
        return this.getNfs().makeLinkRequest(source.getFileHandle(), this.getParentFile().getFileHandle(), this.getName());
    }

    @Override
    public NfsReaddirResponse readdir(long cookie, long cookieverf, int count) throws IOException {
        return this.getNfs().wrapped_getReaddir(this.makeReaddirRequest(cookie, cookieverf, count));
    }

    @Override
    public NfsReaddirResponse readdir(long cookie, long cookieverf, int count, List<NfsDirectoryEntry> entries) throws IOException {
        return this.getNfs().wrapped_getReaddir(this.makeReaddirRequest(cookie, cookieverf, count), entries);
    }

    @Override
    public NfsReaddirRequest makeReaddirRequest(long cookie, long cookieverf, int count) throws IOException {
        return this.getNfs().makeReaddirRequest(this.followLinks().getFileHandle(), cookie, cookieverf, count);
    }

    @Override
    public NfsReaddirplusResponse readdirplus(long cookie, long cookieverf, int dircount, int maxcount) throws IOException {
        return this.getNfs().wrapped_getReaddirplus(this.makeReaddirplusRequest(cookie, cookieverf, dircount, maxcount));
    }

    @Override
    public NfsReaddirplusResponse readdirplus(long cookie, long cookieverf, int dircount, int maxcount, List<NfsDirectoryPlusEntry> entries) throws IOException {
        return this.getNfs().wrapped_getReaddirplus(this.makeReaddirplusRequest(cookie, cookieverf, dircount, maxcount), entries);
    }

    @Override
    public NfsReaddirplusRequest makeReaddirplusRequest(long cookie, long cookieverf, int dircount, int maxcount) throws IOException {
        return this.getNfs().makeReaddirplusRequest(this.followLinks().getFileHandle(), cookie, cookieverf, dircount, maxcount);
    }

    @Override
    public NfsFsStatResponse fsstat() throws IOException {
        return this.getNfs().wrapped_getFsStat(this.getNfs().makeFsStatRequest());
    }

    @Override
    public NfsFsStatRequest makeFsStatRequest() throws IOException {
        return this.getNfs().makeFsStatRequest(this.getFileHandle());
    }

    @Override
    public NfsFsInfoResponse fsinfo() throws IOException {
        return this.getNfs().wrapped_getFsInfo(this.getNfs().makeFsInfoRequest());
    }

    @Override
    public NfsFsInfoRequest makeFsInfoRequest() throws IOException {
        return this.getNfs().makeFsInfoRequest(this.getFileHandle());
    }

    @Override
    public NfsPathconfResponse pathconf() throws IOException {
        return this.getNfs().wrapped_getPathconf(this.makePathconfRequest());
    }

    @Override
    public NfsPathconfRequest makePathconfRequest() throws IOException {
        return this.getNfs().makePathconfRequest(this.getFileHandle());
    }

    @Override
    public NfsCommitResponse commit(long offsetToCommit, int dataSizeToCommit) throws IOException {
        return this.getNfs().wrapped_sendCommit(this.makeCommitRequest(offsetToCommit, dataSizeToCommit));
    }

    @Override
    public NfsCommitRequest makeCommitRequest(long offsetToCommit, int dataSizeToCommit) throws IOException {
        return this.getNfs().makeCommitRequest(this.getFileHandle(), offsetToCommit, dataSizeToCommit);
    }

    protected List<F> getChildFiles(List<String> childNames) throws IOException {
        if (childNames == null) {
            return null;
        }
        ArrayList<F> childFiles = new ArrayList<F>(childNames.size());
        for (String childName : childNames) {
            childFiles.add(this.getChildFile(childName));
        }
        return childFiles;
    }

    private final boolean isRootPath(String path) {
        return path == null || "".equals(path) || "/".equals(path);
    }

    protected final void setFileHandle(byte[] fileHandle) {
        this._fileHandle = fileHandle;
    }

    protected final F newFile(String path) throws IOException {
        return this.newFile(path, null);
    }

    protected abstract F newFile(String var1, LinkTracker<N, F> var2) throws IOException;

    private void setParentFileAndName(F parentFile, String name, LinkTracker<N, F> linkTracker) throws IOException {
        if (parentFile != null) {
            parentFile = parentFile.followLinks(linkTracker);
            if (StringUtils.isBlank((String)name) || ".".equals(name)) {
                name = parentFile.getName();
                parentFile = parentFile.getParentFile();
            } else if ("..".equals(name)) {
                if ((parentFile = parentFile.getParentFile()) == null) {
                    name = "";
                } else {
                    name = parentFile.getName();
                    parentFile = parentFile.getParentFile();
                }
            }
        }
        this._parentFile = parentFile;
        this._name = name;
        this.setPathFields();
    }

    private void setPathFields() {
        String absolutePathBase;
        if (this._parentFile == null) {
            this._parent = "/";
        } else {
            this._parent = this._parentFile.getPath();
            if (!this._parent.endsWith("/")) {
                this._parent = this._parent + "/";
            }
            if (StringUtils.isEmpty((String)this._name)) {
                this._path = this._parent;
                this._absolutePath = this._parentFile.getAbsolutePath();
            } else {
                this._path = this._parent + "/" + this._name;
                this._absolutePath = this._parentFile.getAbsolutePath() + "/" + this._name;
            }
        }
        this._isRootFile = this._parentFile == null;
        String string = absolutePathBase = this._parentFile != null ? this._parentFile.getAbsolutePath() : this.getNfs().getServer() + ":" + this.getNfs().getExportedPath();
        if (!absolutePathBase.endsWith("/")) {
            absolutePathBase = absolutePathBase + "/";
        }
        if (StringUtils.isEmpty((String)this._name)) {
            this._path = this._parent;
            this._absolutePath = absolutePathBase;
        } else {
            this._path = this._parent + this._name;
            this._absolutePath = absolutePathBase + this._name;
        }
    }

    protected final void setPathFields(F toFile) {
        this._parentFile = toFile.getParentFile();
        this._parent = toFile.getParent();
        this._path = toFile.getPath();
        this._absolutePath = toFile.getAbsolutePath();
        this._name = toFile.getName();
    }

    private boolean canAccess(long accessToCheck) throws IOException {
        return (accessToCheck & this.getAccess(accessToCheck)) != 0L;
    }

    private void setFileHandle() {
        byte[] fileHandle = null;
        if (this._isRootFile) {
            fileHandle = this.getNfs().getRootFileHandle();
        } else {
            try {
                if (this.getParentFile().getFileHandle() != null) {
                    fileHandle = this.getNfs().wrapped_getLookup(this.makeLookupRequest()).getFileHandle();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setFileHandle(fileHandle);
    }
}

