/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs.io;

import com.emc.ecs.nfsclient.nfs.Nfs;
import com.emc.ecs.nfsclient.nfs.io.NfsFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LinkTracker<N extends Nfs<?>, F extends NfsFile<N, F>> {
    private static final int MAXSYMLINKS = 40;
    private Set<String> _unresolvedPaths = new HashSet<String>();
    private Map<String, F> _resolvedPaths = new HashMap<String, F>();
    private int linksTraversed = 0;

    final synchronized F addLink(String path) throws IOException {
        if (++this.linksTraversed > 40) {
            throw new IllegalArgumentException("Too many links to follow (> 40).");
        }
        NfsFile resolvedPath = (NfsFile)this._resolvedPaths.get(path);
        if (resolvedPath == null) {
            for (String unresolvedPath : this._unresolvedPaths) {
                if (!path.equals(unresolvedPath) && !path.startsWith(unresolvedPath + "/")) continue;
                throw new IOException("Links form a loop: " + path);
            }
            this._unresolvedPaths.add(path);
        }
        return (F)resolvedPath;
    }

    synchronized void addResolvedPath(String path, F file) {
        this._resolvedPaths.put(path, file);
        this._unresolvedPaths.remove(path);
    }
}

