/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsTime;
import com.emc.ecs.nfsclient.rpc.Xdr;

public class NfsSetAttributes {
    private Long _mode;
    private Long _uid;
    private Long _gid;
    private Long _size;
    private NfsTime _atime;
    private NfsTime _mtime;

    public void setMode(Long mode) {
        this._mode = mode;
    }

    public void setUid(Long uid) {
        this._uid = uid;
    }

    public void setGid(Long gid) {
        this._gid = gid;
    }

    public void setSize(Long size) {
        this._size = size;
    }

    public void setAtime(NfsTime atime) {
        this._atime = atime;
    }

    public void setMtime(NfsTime mtime) {
        this._mtime = mtime;
    }

    public NfsSetAttributes() {
        this(null, null, null, null, NfsTime.DO_NOT_CHANGE, NfsTime.DO_NOT_CHANGE);
    }

    public NfsSetAttributes(Long mode, Long uid, Long gid, NfsTime atime, NfsTime mtime) {
        this(mode, uid, gid, null, atime, mtime);
    }

    public NfsSetAttributes(Long mode, Long uid, Long gid, Long size, NfsTime atime, NfsTime mtime) {
        this._mode = mode;
        this._uid = uid;
        this._gid = gid;
        this._size = size;
        this._atime = atime;
        this._mtime = mtime;
    }

    public void marshalling(Xdr xdr) {
        NfsSetAttributes.marshalling(xdr, this._mode);
        NfsSetAttributes.marshalling(xdr, this._uid);
        NfsSetAttributes.marshalling(xdr, this._gid);
        if (this._size != null) {
            xdr.putBoolean(true);
            xdr.putLong(this._size);
        } else {
            xdr.putBoolean(false);
        }
        this.marshalling(xdr, this._atime);
        this.marshalling(xdr, this._mtime);
    }

    private void marshalling(Xdr xdr, NfsTime nfsTime) {
        if (nfsTime != null) {
            nfsTime.marshalling(xdr);
        } else {
            xdr.putInt(0);
        }
    }

    private static void marshalling(Xdr xdr, Long longValue) {
        if (longValue != null) {
            xdr.putBoolean(true);
            xdr.putUnsignedInt(longValue);
        } else {
            xdr.putBoolean(false);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" [mode :").append(this._mode);
        sb.append(" uid: ").append(this._uid);
        sb.append(" gid: ").append(this._gid);
        sb.append(" size: ").append(this._size);
        sb.append(" atime: ").append(this._atime);
        sb.append(" mtime: ").append(this._mtime);
        sb.append("]");
        return sb.toString();
    }
}

