/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsDirectoryEntry;
import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.util.ArrayList;
import java.util.List;

public class NfsReaddirResponse
extends NfsResponseBase {
    private long _cookie;
    private long _cookieverf;
    List<NfsDirectoryEntry> _entries;
    private boolean _eof;

    public NfsReaddirResponse(int nfsVersion) {
        this(new ArrayList<NfsDirectoryEntry>(), nfsVersion);
    }

    public NfsReaddirResponse(List<NfsDirectoryEntry> entries, int nfsVersion) {
        this._entries = entries;
    }

    @Override
    public void unmarshalling(Xdr xdr) throws RpcException {
        super.unmarshalling(xdr);
        this.unmarshallingAttributes(xdr);
        if (this.stateIsOk()) {
            this._cookieverf = xdr.getLong();
            while (xdr.getBoolean()) {
                NfsDirectoryEntry entry = new NfsDirectoryEntry(xdr);
                this._entries.add(entry);
                this._cookie = entry.getCookie();
            }
            this._eof = xdr.getBoolean();
        }
    }

    public long getCookie() {
        return this._cookie;
    }

    public long getCookieverf() {
        return this._cookieverf;
    }

    public List<NfsDirectoryEntry> getEntries() {
        return this._entries;
    }

    public boolean isEof() {
        return this._eof;
    }
}

