/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.util.Arrays;

public class NfsLinkRequest
extends NfsRequestBase {
    private final byte[] _parentDirectoryFileHandle;
    private final String _name;

    public NfsLinkRequest(byte[] fileHandle, byte[] parentDirectoryFileHandle, String name, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 15, credential, fileHandle);
        this._parentDirectoryFileHandle = NfsLinkRequest.cloneFileHandle(parentDirectoryFileHandle);
        this._name = NfsLinkRequest.trimFileName(name);
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        xdr.putByteArray(this._parentDirectoryFileHandle);
        xdr.putString(this._name);
    }

    public String toString() {
        return this.startToString("NfsLinkRequest").append(" parentDirectoryFileHandle:").append(Arrays.toString(this._parentDirectoryFileHandle)).append(" name:").append(this._name).toString();
    }
}

