/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsCreateMode;
import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.util.Random;

public class NfsCreateRequest
extends NfsRequestBase {
    private static final int NFS3_CREATEVERFSIZE = 8;
    private NfsCreateMode _createMode;
    private String _name;
    NfsSetAttributes _attributes;
    private byte[] _verifier;

    public NfsCreateRequest(NfsCreateMode createMode, byte[] parentDirectoryFileHandle, String name, NfsSetAttributes attributes, byte[] verifier, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 8, credential, parentDirectoryFileHandle);
        this._createMode = createMode;
        this._name = NfsCreateRequest.trimFileName(name);
        this._attributes = attributes;
        if (this._createMode == NfsCreateMode.EXCLUSIVE) {
            if (verifier != null) {
                this._verifier = verifier;
            } else {
                this._verifier = new byte[8];
                new Random().nextBytes(this._verifier);
            }
        }
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        xdr.putString(this._name);
        xdr.putInt(this._createMode.getValue());
        if (this._createMode != NfsCreateMode.EXCLUSIVE) {
            this._attributes.marshalling(xdr);
        } else {
            xdr.putByteArray(this._verifier);
        }
    }

    public String toString() {
        return this.startToString("NfsCreateRequest").append(" name:").append(this._name).toString();
    }

    public byte[] getVerifier() {
        return this._verifier;
    }
}

