/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.network;

import com.emc.ecs.nfsclient.network.RecordMarkingUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class RPCRecordDecoder
extends FrameDecoder {
    private int _recordLength = 0;

    protected Object decode(ChannelHandlerContext channelHandlerContext, Channel channel, ChannelBuffer channelBuffer) throws Exception {
        if (channelBuffer.readableBytes() < 4) {
            return null;
        }
        channelBuffer.markReaderIndex();
        long fragSize = channelBuffer.readUnsignedInt();
        boolean lastFragment = RecordMarkingUtil.isLastFragment(fragSize);
        fragSize = RecordMarkingUtil.maskFragmentSize(fragSize);
        if ((long)channelBuffer.readableBytes() < fragSize) {
            channelBuffer.resetReaderIndex();
            return null;
        }
        channelBuffer.skipBytes((int)fragSize);
        this._recordLength += 4 + (int)fragSize;
        if (!lastFragment) {
            return null;
        }
        byte[] rpcResponse = new byte[this._recordLength];
        channelBuffer.readerIndex(channelBuffer.readerIndex() - this._recordLength);
        channelBuffer.readBytes(rpcResponse, 0, this._recordLength);
        this._recordLength = 0;
        return rpcResponse;
    }
}

