/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.mount;

import com.emc.ecs.nfsclient.mount.MountStatus;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.RpcResponse;
import com.emc.ecs.nfsclient.rpc.Xdr;

public class MountResponse
extends RpcResponse {
    private int _mountStatus;
    private byte[] _rootFileHandle;
    private int[] _authenticationFlavors;

    public MountResponse(int nfsVersion) {
    }

    @Override
    public void unmarshalling(Xdr xdr) throws RpcException {
        super.unmarshalling(xdr);
        this._mountStatus = xdr.getInt();
        if (this._mountStatus == MountStatus.MNT3_OK.getValue()) {
            this._rootFileHandle = xdr.getByteArray();
            int numsec = xdr.getInt();
            this._authenticationFlavors = new int[numsec];
            for (int i = 0; i < numsec; ++i) {
                this._authenticationFlavors[i] = xdr.getInt();
            }
        }
    }

    public int getMountStatus() {
        return this._mountStatus;
    }

    public byte[] getRootFileHandle() {
        return (byte[])this._rootFileHandle.clone();
    }

    public int[] getAuthenticationFlavors() {
        return this._authenticationFlavors == null ? null : (int[])this._authenticationFlavors.clone();
    }
}

