/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.mgmt.jersey;

import com.emc.atmos.AbstractJerseyClient;
import com.emc.atmos.mgmt.TenantMgmtApi;
import com.emc.atmos.mgmt.TenantMgmtConfig;
import com.emc.atmos.mgmt.bean.GetSubtenantResponse;
import com.emc.atmos.mgmt.bean.GetTenantInfoResponse;
import com.emc.atmos.mgmt.bean.ListPoliciesResponse;
import com.emc.atmos.mgmt.bean.ListSubtenantsResponse;
import com.emc.atmos.mgmt.bean.ListUidsResponse;
import com.emc.atmos.mgmt.bean.PoxTenant;
import com.emc.atmos.mgmt.bean.SharedSecret;
import com.emc.atmos.mgmt.bean.SubtenantDetails;
import com.emc.atmos.mgmt.jersey.AuthFilter;
import com.emc.atmos.mgmt.jersey.JerseyUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;

public class TenantMgmtClient
extends AbstractJerseyClient<TenantMgmtConfig>
implements TenantMgmtApi {
    public TenantMgmtClient(TenantMgmtConfig config) {
        super(config);
    }

    @Override
    protected Client createClient(TenantMgmtConfig config) {
        return JerseyUtil.createClient(config);
    }

    @Override
    public GetTenantInfoResponse getTenantInfo() {
        URI uri = ((TenantMgmtConfig)this.config).resolveHost("/tenant_admin/get_tenant_info", null);
        WebResource resource = this.client.resource(uri);
        resource.setProperty(AuthFilter.PROP_POX_REQUEST, (Object)Boolean.TRUE);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        GetTenantInfoResponse tenantResponse = new GetTenantInfoResponse();
        tenantResponse.setTenant((PoxTenant)response.getEntity(PoxTenant.class));
        response.close();
        this.fillResponse(tenantResponse, response);
        return tenantResponse;
    }

    @Override
    public ListSubtenantsResponse listSubtenants() {
        return this.executeAndClose(this.buildRequest(this.tenantPrefix() + "/subtenants", null), ListSubtenantsResponse.class);
    }

    @Override
    public GetSubtenantResponse getSubtenant(String subtenantName) {
        ClientResponse response = (ClientResponse)this.buildRequest(this.tenantPrefix() + "/subtenants/" + subtenantName, null).get(ClientResponse.class);
        GetSubtenantResponse subtenantResponse = new GetSubtenantResponse();
        subtenantResponse.setSubtenant((SubtenantDetails)response.getEntity(SubtenantDetails.class));
        response.close();
        this.fillResponse(subtenantResponse, response);
        return subtenantResponse;
    }

    @Override
    public ListPoliciesResponse listPolicies() {
        return this.executeAndClose(this.buildRequest("/" + ((TenantMgmtConfig)this.config).getTenant() + "/policies", null), ListPoliciesResponse.class);
    }

    @Override
    public ListUidsResponse listUids(String subtenantName) {
        return this.executeAndClose(this.buildRequest(this.tenantPrefix() + "/subtenants/" + subtenantName + "/uids", null), ListUidsResponse.class);
    }

    @Override
    public SharedSecret getSharedSecret(String subtenantName, String uid) {
        return this.executeAndClose(this.buildRequest(this.tenantPrefix() + "/subtenants/" + subtenantName + "/uids/" + uid, null), SharedSecret.class);
    }

    protected String tenantPrefix() {
        return "/tenants/" + ((TenantMgmtConfig)this.config).getTenant();
    }
}

