/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.multipart;

import com.emc.atmos.api.Range;
import com.emc.atmos.api.multipart.MultipartException;
import com.emc.atmos.api.multipart.MultipartPart;
import com.emc.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultipartEntity
extends ArrayList<MultipartPart> {
    private static final long serialVersionUID = -4788353053749563899L;
    private static final Pattern PATTERN_CONTENT_TYPE = Pattern.compile("^Content-Type: (.+)$");
    private static final Pattern PATTERN_CONTENT_RANGE = Pattern.compile("^Content-Range: bytes (\\d+)-(\\d+)/(\\d+)$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartEntity fromStream(InputStream is, String boundary) throws IOException {
        ArrayList<MultipartPart> parts;
        block14: {
            if (boundary.startsWith("--")) {
                boundary = boundary.substring(2);
            }
            parts = new ArrayList<MultipartPart>();
            try {
                do {
                    int read;
                    String line;
                    if ("".equals(line = StreamUtil.readLine(is))) {
                        line = StreamUtil.readLine(is);
                    }
                    if (("--" + boundary + "--").equals(line)) {
                        break block14;
                    }
                    if (!("--" + boundary).equals(line)) {
                        throw new MultipartException("Parse error: expected [--" + boundary + "], instead got [" + line + "]");
                    }
                    String contentType = null;
                    int start = -1;
                    int end = 0;
                    int length = 0;
                    while (!"".equals(line = StreamUtil.readLine(is))) {
                        Matcher matcher = PATTERN_CONTENT_TYPE.matcher(line);
                        if (matcher.find()) {
                            contentType = matcher.group(1);
                            continue;
                        }
                        matcher = PATTERN_CONTENT_RANGE.matcher(line);
                        if (matcher.find()) {
                            start = Integer.parseInt(matcher.group(1));
                            end = Integer.parseInt(matcher.group(2));
                            length = end - start + 1;
                            continue;
                        }
                        throw new MultipartException("Unrecognized header line: " + line);
                    }
                    if (contentType == null) {
                        throw new MultipartException("Parse error: No content-type specified in part");
                    }
                    if (start == -1) {
                        throw new MultipartException("Parse error: No content-range specified in part");
                    }
                    byte[] data = new byte[length];
                    for (int count = 0; count < length; count += read) {
                        read = is.read(data, 0, length - count);
                    }
                    parts.add(new MultipartPart(contentType, new Range(start, end), data));
                } while ("".equals(StreamUtil.readLine(is)));
                throw new MultipartException("Parse error: expected EOL before boundary");
            }
            finally {
                is.close();
            }
        }
        return new MultipartEntity((List<MultipartPart>)parts);
    }

    public MultipartEntity(List<MultipartPart> parts) {
        super(parts);
    }

    public byte[] aggregateBytes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (MultipartPart part : this) {
                baos.write(part.getData());
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }
}

