/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.jersey.MeasuredInputStream;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFilter
extends ClientFilter {
    private static final int ATMOS_1040_DELAY_MS = 300;
    private static final Logger log = LoggerFactory.getLogger(RetryFilter.class);
    private AtmosConfig config;

    public RetryFilter(AtmosConfig config) {
        this.config = config;
    }

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        int retryCount = 0;
        InputStream entityStream = null;
        if (clientRequest.getEntity() instanceof InputStream) {
            entityStream = (InputStream)clientRequest.getEntity();
        }
        while (true) {
            try {
                if (entityStream != null && entityStream.markSupported()) {
                    entityStream.mark(this.config.getRetryBufferSize());
                }
                return this.getNext().handle(clientRequest);
            }
            catch (RuntimeException orig) {
                Throwable t = orig;
                if (t instanceof ClientHandlerException) {
                    t = t.getCause();
                }
                if (t instanceof AtmosException) {
                    AtmosException ae = (AtmosException)t;
                    if (ae.getHttpCode() < 500) {
                        throw orig;
                    }
                    if (ae.getErrorCode() == 1040) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            log.warn("Interrupted while waiting after a 1040 response: " + e.getMessage());
                        }
                    }
                } else if (!(t instanceof IOException) || clientRequest.getHeaders().getFirst((Object)"x-emc-wschecksum") != null) {
                    throw orig;
                }
                if (++retryCount > this.config.getMaxRetries()) {
                    throw orig;
                }
                if (!(entityStream == null || entityStream instanceof MeasuredInputStream && ((MeasuredInputStream)entityStream).getRead() <= 0L)) {
                    try {
                        if (!entityStream.markSupported()) {
                            throw new IOException("Mark is not supported");
                        }
                        entityStream.reset();
                    }
                    catch (IOException e) {
                        log.warn("Could not reset entity stream for retry: " + e.getMessage());
                        throw orig;
                    }
                }
                log.info("Error received in response (" + t + "), retrying...");
                if (this.config.getRetryDelayMillis() <= 0) continue;
                try {
                    Thread.sleep(this.config.getRetryDelayMillis());
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting to retry: " + e.getMessage());
                    continue;
                }
            }
            break;
        }
    }
}

