/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStreamReader;
import java.io.Reader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);
    public static final String NO_EXCEPTIONS = "ErrorFilter.noExceptions";

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(clientRequest);
        if (response.getStatus() > 299 && this.shouldThrowExceptions(clientRequest)) {
            Document d;
            SAXReader saxReader = new SAXReader();
            try {
                d = saxReader.read((Reader)new InputStreamReader(response.getEntityInputStream()));
            }
            catch (Throwable t) {
                throw new AtmosException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            String code = d.getRootElement().elementText("Code");
            String message = d.getRootElement().elementText("Message");
            if (code == null && message == null) {
                throw new AtmosException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            log.debug("Error: " + code + " message: " + message);
            throw new AtmosException(message, response.getStatus(), code == null ? 0 : Integer.parseInt(code));
        }
        return response;
    }

    private boolean shouldThrowExceptions(ClientRequest request) {
        Boolean noExceptions = (Boolean)request.getProperties().get(NO_EXCEPTIONS);
        return noExceptions == null || noExceptions == false;
    }
}

