/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.ImportDescType;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.ValueType;

public class ImportDesc {
    private int index;
    private ImportDescType type;
    private MutabilityType mutabilityType;
    private ValueType valType;
    private Limits limits;

    public ImportDesc(ImportDescType type, int index) {
        this.type = type;
        this.index = index;
    }

    public ImportDesc(ImportDescType type, MutabilityType mutabilityType, ValueType valType) {
        this.type = type;
        this.mutabilityType = mutabilityType;
        this.valType = valType;
    }

    public ImportDesc(ImportDescType type, Limits limits) {
        this.type = type;
        this.limits = limits;
        this.valType = null;
    }

    public ImportDesc(ImportDescType type, Limits limits, ValueType valType) {
        assert (valType == ValueType.FuncRef || valType == ValueType.ExternRef);
        this.type = type;
        this.limits = limits;
        this.valType = valType;
    }

    public long index() {
        return this.index;
    }

    public ImportDescType type() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case FuncIdx: {
                return "func[]";
            }
            case TableIdx: {
                return "table[]";
            }
            case MemIdx: {
                return "memory[]";
            }
            case GlobalIdx: {
                return "global[] " + this.valType + " mutability=" + this.mutabilityType;
            }
        }
        return "unknown[]";
    }
}

