/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.ValueType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class Value {
    public static final Value TRUE = Value.i32(1);
    public static final Value FALSE = Value.i32(0);
    public static final int REF_NULL_VALUE = -1;
    public static final Value EXTREF_NULL = Value.externRef(-1);
    public static final Value FUNCREF_NULL = Value.funcRef(-1);
    public static final Value[] EMPTY_VALUES = new Value[0];
    private final ValueType type;
    private final long data;

    public static Value fromFloat(float data) {
        return Value.f32(Float.floatToRawIntBits(data));
    }

    public static Value fromDouble(double data) {
        return Value.f64(Double.doubleToRawLongBits(data));
    }

    public static Value i32(int data) {
        return Value.i32((long)data);
    }

    public static Value i32(long data) {
        return new Value(ValueType.I32, data);
    }

    public static Value i64(long data) {
        return new Value(ValueType.I64, data);
    }

    public static Value f32(long data) {
        return new Value(ValueType.F32, data);
    }

    public static Value f64(long data) {
        return new Value(ValueType.F64, data);
    }

    public static Value externRef(int data) {
        return new Value(ValueType.ExternRef, data);
    }

    public static Value funcRef(int data) {
        return new Value(ValueType.FuncRef, data);
    }

    public Value(ValueType type, int value) {
        this.type = Objects.requireNonNull(Value.ensure32bitValueType(type), "type");
        this.data = value;
    }

    public Value(ValueType type, long value) {
        this.type = Objects.requireNonNull(type, "type");
        this.data = value;
    }

    private static ValueType ensure32bitValueType(ValueType type) {
        switch (type) {
            case I32: 
            case F32: 
            case ExternRef: 
            case FuncRef: {
                return type;
            }
        }
        throw new IllegalArgumentException("Invalid type for 32 bit value: " + type);
    }

    public static Value zero(ValueType valueType) {
        switch (valueType) {
            case I32: {
                return Value.i32(0);
            }
            case F32: {
                return Value.f32(0L);
            }
            case I64: {
                return Value.i64(0L);
            }
            case F64: {
                return Value.f64(0L);
            }
            case FuncRef: {
                return FUNCREF_NULL;
            }
            case ExternRef: {
                return EXTREF_NULL;
            }
        }
        throw new IllegalArgumentException("Can't create a zero value for type " + valueType);
    }

    public int asInt() {
        switch (this.type) {
            case I32: 
            case F32: 
            case I64: 
            case F64: {
                return (int)this.data;
            }
        }
        throw new IllegalArgumentException("Can't turn wasm value of type " + this.type + " to a int");
    }

    public long asUInt() {
        switch (this.type) {
            case I32: 
            case F32: 
            case I64: 
            case F64: {
                return this.data & 0xFFFFFFFFL;
            }
        }
        throw new IllegalArgumentException("Can't turn wasm value of type " + this.type + " to a uint");
    }

    public long asLong() {
        switch (this.type) {
            case I32: 
            case F32: 
            case I64: 
            case F64: {
                return this.data;
            }
        }
        throw new IllegalArgumentException("Can't turn wasm value of type " + this.type + " to a long");
    }

    public byte asByte() {
        switch (this.type) {
            case I32: 
            case F32: 
            case I64: 
            case F64: {
                return (byte)(this.data & 0xFFL);
            }
        }
        throw new IllegalArgumentException("Can't turn wasm value of type " + this.type + " to a byte");
    }

    public short asShort() {
        switch (this.type) {
            case I32: 
            case I64: {
                return (short)(this.data & 0xFFFFL);
            }
        }
        throw new IllegalArgumentException("Can't turn wasm value of type " + this.type + " to a short");
    }

    public int asExtRef() {
        return (int)this.data;
    }

    public int asFuncRef() {
        return (int)this.data;
    }

    public float asFloat() {
        return Float.intBitsToFloat(this.asInt());
    }

    public double asDouble() {
        return Double.longBitsToDouble(this.asLong());
    }

    public ValueType type() {
        return this.type;
    }

    public byte[] data() {
        switch (this.type) {
            case I64: 
            case F64: {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putLong(this.data);
                return buffer.array();
            }
        }
        ByteBuffer buffer2 = ByteBuffer.allocate(4);
        buffer2.order(ByteOrder.LITTLE_ENDIAN);
        buffer2.putInt((int)this.data);
        return buffer2.array();
    }

    public String toString() {
        switch (this.type) {
            case I32: {
                return this.asInt() + "@i32";
            }
            case I64: {
                return this.asLong() + "@i64";
            }
            case F32: {
                return this.asFloat() + "@f32";
            }
            case F64: {
                return this.asDouble() + "@f64";
            }
            case FuncRef: {
                return "func[" + (int)this.data + "]";
            }
            case ExternRef: {
                return "ext[" + (int)this.data + "]";
            }
        }
        throw new RuntimeException("TODO handle missing types");
    }

    public final boolean equals(Object v) {
        if (v == this) {
            return true;
        }
        if (!(v instanceof Value)) {
            return false;
        }
        Value other = (Value)v;
        return Objects.equals(this.type.id(), other.type.id()) && this.data == other.data;
    }

    public final int hashCode() {
        return Objects.hash(this.type.id(), this.data);
    }
}

