/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.wasm.exceptions.MalformedException;
import java.nio.ByteBuffer;

public final class Encoding {
    public static final int MAX_VARINT_LEN_32 = 5;
    public static final int MAX_VARINT_LEN_64 = 10;

    public static long readUnsignedLeb128(ByteBuffer byteBuffer, int maxVarInt) {
        long result = 0L;
        int shift = 0;
        int i = 0;
        while (true) {
            ++i;
            if (byteBuffer.remaining() == 0) {
                throw new MalformedException("length out of bounds");
            }
            byte b = byteBuffer.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            if (i >= maxVarInt) {
                throw new MalformedException("integer representation too long");
            }
            shift += 7;
        }
        return result;
    }

    public static long readSigned32Leb128(ByteBuffer byteBuffer) {
        byte currentByte;
        long result = 0L;
        int shift = 0;
        int i = 0;
        do {
            ++i;
            if (byteBuffer.remaining() == 0) {
                throw new MalformedException("length out of bounds");
            }
            currentByte = byteBuffer.get();
            if ((currentByte & 0x80) != 0 && i >= 5) {
                throw new MalformedException("integer representation too long");
            }
            result |= (long)(currentByte & 0x7F) << shift;
            shift += 7;
        } while ((currentByte & 0x80) != 0);
        if ((currentByte & 0x40) != 0) {
            result |= -(1L << shift);
        }
        return result;
    }

    public static long readSigned64Leb128(ByteBuffer byteBuffer) {
        byte currentByte;
        long result = 0L;
        int shift = 0;
        int i = 0;
        int size = 64;
        do {
            ++i;
            if (byteBuffer.remaining() == 0) {
                throw new MalformedException("length out of bounds");
            }
            currentByte = byteBuffer.get();
            if ((currentByte & 0x80) != 0 && i >= 10) {
                throw new MalformedException("integer representation too long");
            }
            result |= (long)(currentByte & 0x7F) << shift;
            shift += 7;
        } while ((currentByte & 0x80) != 0);
        if (shift < size && (currentByte & 0x40) != 0) {
            result |= -1L << shift;
        }
        if (i >= 10 && currentByte != 0 && currentByte < 127) {
            throw new MalformedException("integer too large");
        }
        return result;
    }
}

