/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.WasmEncoding;
import java.util.HashMap;
import java.util.Map;

public enum OpCode {
    UNREACHABLE(0),
    NOP(1),
    BLOCK(2),
    LOOP(3),
    IF(4),
    ELSE(5),
    END(11),
    BR(12),
    BR_IF(13),
    BR_TABLE(14),
    RETURN(15),
    CALL(16),
    CALL_INDIRECT(17),
    CALL_REF(20),
    DROP(26),
    SELECT(27),
    SELECT_T(28),
    LOCAL_GET(32),
    LOCAL_SET(33),
    LOCAL_TEE(34),
    GLOBAL_GET(35),
    GLOBAL_SET(36),
    TABLE_GET(37),
    TABLE_SET(38),
    I32_LOAD(40),
    I64_LOAD(41),
    F32_LOAD(42),
    F64_LOAD(43),
    I32_LOAD8_S(44),
    I32_LOAD8_U(45),
    I32_LOAD16_S(46),
    I32_LOAD16_U(47),
    I64_LOAD8_S(48),
    I64_LOAD8_U(49),
    I64_LOAD16_S(50),
    I64_LOAD16_U(51),
    I64_LOAD32_S(52),
    I64_LOAD32_U(53),
    I32_STORE(54),
    I64_STORE(55),
    F32_STORE(56),
    F64_STORE(57),
    I32_STORE8(58),
    I32_STORE16(59),
    I64_STORE8(60),
    I64_STORE16(61),
    I64_STORE32(62),
    MEMORY_SIZE(63),
    MEMORY_GROW(64),
    I32_CONST(65),
    I64_CONST(66),
    F32_CONST(67),
    F64_CONST(68),
    I32_EQZ(69),
    I32_EQ(70),
    I32_NE(71),
    I32_LT_S(72),
    I32_LT_U(73),
    I32_GT_S(74),
    I32_GT_U(75),
    I32_LE_S(76),
    I32_LE_U(77),
    I32_GE_S(78),
    I32_GE_U(79),
    I64_EQZ(80),
    I64_EQ(81),
    I64_NE(82),
    I64_LT_S(83),
    I64_LT_U(84),
    I64_GT_S(85),
    I64_GT_U(86),
    I64_LE_S(87),
    I64_LE_U(88),
    I64_GE_S(89),
    I64_GE_U(90),
    F32_EQ(91),
    F32_NE(92),
    F32_LT(93),
    F32_GT(94),
    F32_LE(95),
    F32_GE(96),
    F64_EQ(97),
    F64_NE(98),
    F64_LT(99),
    F64_GT(100),
    F64_LE(101),
    F64_GE(102),
    I32_CLZ(103),
    I32_CTZ(104),
    I32_POPCNT(105),
    I32_ADD(106),
    I32_SUB(107),
    I32_MUL(108),
    I32_DIV_S(109),
    I32_DIV_U(110),
    I32_REM_S(111),
    I32_REM_U(112),
    I32_AND(113),
    I32_OR(114),
    I32_XOR(115),
    I32_SHL(116),
    I32_SHR_S(117),
    I32_SHR_U(118),
    I32_ROTL(119),
    I32_ROTR(120),
    I64_CLZ(121),
    I64_CTZ(122),
    I64_POPCNT(123),
    I64_ADD(124),
    I64_SUB(125),
    I64_MUL(126),
    I64_DIV_S(127),
    I64_DIV_U(128),
    I64_REM_S(129),
    I64_REM_U(130),
    I64_AND(131),
    I64_OR(132),
    I64_XOR(133),
    I64_SHL(134),
    I64_SHR_S(135),
    I64_SHR_U(136),
    I64_ROTL(137),
    I64_ROTR(138),
    F32_ABS(139),
    F32_NEG(140),
    F32_CEIL(141),
    F32_FLOOR(142),
    F32_TRUNC(143),
    F32_NEAREST(144),
    F32_SQRT(145),
    F32_ADD(146),
    F32_SUB(147),
    F32_MUL(148),
    F32_DIV(149),
    F32_MIN(150),
    F32_MAX(151),
    F32_COPYSIGN(152),
    F64_ABS(153),
    F64_NEG(154),
    F64_CEIL(155),
    F64_FLOOR(156),
    F64_TRUNC(157),
    F64_NEAREST(158),
    F64_SQRT(159),
    F64_ADD(160),
    F64_SUB(161),
    F64_MUL(162),
    F64_DIV(163),
    F64_MIN(164),
    F64_MAX(165),
    F64_COPYSIGN(166),
    I32_WRAP_I64(167),
    I32_TRUNC_F32_S(168),
    I32_TRUNC_F32_U(169),
    I32_TRUNC_F64_S(170),
    I32_TRUNC_F64_U(171),
    I64_EXTEND_I32_S(172),
    I64_EXTEND_I32_U(173),
    I64_TRUNC_F32_S(174),
    I64_TRUNC_F32_U(175),
    I64_TRUNC_F64_S(176),
    I64_TRUNC_F64_U(177),
    F32_CONVERT_I32_S(178),
    F32_CONVERT_I32_U(179),
    F32_CONVERT_I64_S(180),
    F32_CONVERT_I64_U(181),
    F32_DEMOTE_F64(182),
    F64_CONVERT_I32_S(183),
    F64_CONVERT_I32_U(184),
    F64_CONVERT_I64_S(185),
    F64_CONVERT_I64_U(186),
    F64_PROMOTE_F32(187),
    I32_REINTERPRET_F32(188),
    I64_REINTERPRET_F64(189),
    F32_REINTERPRET_I32(190),
    F64_REINTERPRET_I64(191),
    I32_EXTEND_8_S(192),
    I32_EXTEND_16_S(193),
    I64_EXTEND_8_S(194),
    I64_EXTEND_16_S(195),
    I64_EXTEND_32_S(196),
    REF_NULL(208),
    REF_IS_NULL(209),
    REF_FUNC(210),
    I32_TRUNC_SAT_F32_S(64512),
    I32_TRUNC_SAT_F32_U(64513),
    I32_TRUNC_SAT_F64_S(64514),
    I32_TRUNC_SAT_F64_U(64515),
    I64_TRUNC_SAT_F32_S(64516),
    I64_TRUNC_SAT_F32_U(64517),
    I64_TRUNC_SAT_F64_S(64518),
    I64_TRUNC_SAT_F64_U(64519),
    MEMORY_INIT(64520),
    DATA_DROP(64521),
    MEMORY_COPY(64522),
    MEMORY_FILL(64523),
    TABLE_INIT(64524),
    ELEM_DROP(64525),
    TABLE_COPY(64526),
    TABLE_GROW(64527),
    TABLE_SIZE(64528),
    TABLE_FILL(64529);

    private final int opcode;
    private static final Map<Integer, OpCode> byOpCode;
    private static final Map<OpCode, WasmEncoding[]> signature;

    private OpCode(int opcode) {
        this.opcode = opcode;
    }

    public int opcode() {
        return this.opcode;
    }

    public static OpCode byOpCode(int opcode) {
        return byOpCode.get(opcode);
    }

    public static WasmEncoding[] getSignature(OpCode o) {
        return signature.get((Object)o);
    }

    static {
        byOpCode = new HashMap<Integer, OpCode>();
        signature = new HashMap<OpCode, WasmEncoding[]>();
        for (OpCode e : OpCode.values()) {
            byOpCode.put(e.opcode(), e);
        }
        signature.put(UNREACHABLE, new WasmEncoding[0]);
        signature.put(NOP, new WasmEncoding[0]);
        signature.put(BLOCK, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(LOOP, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(IF, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(ELSE, new WasmEncoding[0]);
        signature.put(END, new WasmEncoding[0]);
        signature.put(BR, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(BR_IF, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(BR_TABLE, new WasmEncoding[]{WasmEncoding.VEC_VARUINT, WasmEncoding.VARUINT});
        signature.put(RETURN, new WasmEncoding[0]);
        signature.put(CALL, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(CALL_INDIRECT, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(CALL_REF, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(DROP, new WasmEncoding[0]);
        signature.put(SELECT, new WasmEncoding[0]);
        signature.put(SELECT_T, new WasmEncoding[]{WasmEncoding.VEC_VARUINT});
        signature.put(LOCAL_GET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(LOCAL_SET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(LOCAL_TEE, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(GLOBAL_GET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(GLOBAL_SET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_GET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_SET, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(I32_LOAD, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(F32_LOAD, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(F64_LOAD, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_LOAD8_S, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_LOAD8_U, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_LOAD16_S, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_LOAD16_U, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD8_S, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD8_U, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD16_S, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD16_U, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD32_S, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_LOAD32_U, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_STORE, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_STORE, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(F32_STORE, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(F64_STORE, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_STORE8, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I32_STORE16, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_STORE8, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_STORE16, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(I64_STORE32, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(MEMORY_SIZE, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(MEMORY_GROW, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(I32_CONST, new WasmEncoding[]{WasmEncoding.VARSINT32});
        signature.put(I64_CONST, new WasmEncoding[]{WasmEncoding.VARSINT64});
        signature.put(F32_CONST, new WasmEncoding[]{WasmEncoding.FLOAT32});
        signature.put(F64_CONST, new WasmEncoding[]{WasmEncoding.FLOAT64});
        signature.put(I32_EQZ, new WasmEncoding[0]);
        signature.put(I32_EQ, new WasmEncoding[0]);
        signature.put(I32_NE, new WasmEncoding[0]);
        signature.put(I32_LT_S, new WasmEncoding[0]);
        signature.put(I32_LT_U, new WasmEncoding[0]);
        signature.put(I32_GT_S, new WasmEncoding[0]);
        signature.put(I32_GT_U, new WasmEncoding[0]);
        signature.put(I32_LE_S, new WasmEncoding[0]);
        signature.put(I32_LE_U, new WasmEncoding[0]);
        signature.put(I32_GE_S, new WasmEncoding[0]);
        signature.put(I32_GE_U, new WasmEncoding[0]);
        signature.put(I64_EQZ, new WasmEncoding[0]);
        signature.put(I64_EQ, new WasmEncoding[0]);
        signature.put(I64_NE, new WasmEncoding[0]);
        signature.put(I64_LT_S, new WasmEncoding[0]);
        signature.put(I64_LT_U, new WasmEncoding[0]);
        signature.put(I64_GT_S, new WasmEncoding[0]);
        signature.put(I64_GT_U, new WasmEncoding[0]);
        signature.put(I64_LE_S, new WasmEncoding[0]);
        signature.put(I64_LE_U, new WasmEncoding[0]);
        signature.put(I64_GE_S, new WasmEncoding[0]);
        signature.put(I64_GE_U, new WasmEncoding[0]);
        signature.put(F32_EQ, new WasmEncoding[0]);
        signature.put(F32_NE, new WasmEncoding[0]);
        signature.put(F32_LT, new WasmEncoding[0]);
        signature.put(F32_GT, new WasmEncoding[0]);
        signature.put(F32_LE, new WasmEncoding[0]);
        signature.put(F32_GE, new WasmEncoding[0]);
        signature.put(F64_EQ, new WasmEncoding[0]);
        signature.put(F64_NE, new WasmEncoding[0]);
        signature.put(F64_LT, new WasmEncoding[0]);
        signature.put(F64_GT, new WasmEncoding[0]);
        signature.put(F64_LE, new WasmEncoding[0]);
        signature.put(F64_GE, new WasmEncoding[0]);
        signature.put(I32_CLZ, new WasmEncoding[0]);
        signature.put(I32_CTZ, new WasmEncoding[0]);
        signature.put(I32_POPCNT, new WasmEncoding[0]);
        signature.put(I32_ADD, new WasmEncoding[0]);
        signature.put(I32_SUB, new WasmEncoding[0]);
        signature.put(I32_MUL, new WasmEncoding[0]);
        signature.put(I32_DIV_S, new WasmEncoding[0]);
        signature.put(I32_DIV_U, new WasmEncoding[0]);
        signature.put(I32_REM_S, new WasmEncoding[0]);
        signature.put(I32_REM_U, new WasmEncoding[0]);
        signature.put(I32_AND, new WasmEncoding[0]);
        signature.put(I32_OR, new WasmEncoding[0]);
        signature.put(I32_XOR, new WasmEncoding[0]);
        signature.put(I32_SHL, new WasmEncoding[0]);
        signature.put(I32_SHR_S, new WasmEncoding[0]);
        signature.put(I32_SHR_U, new WasmEncoding[0]);
        signature.put(I32_ROTL, new WasmEncoding[0]);
        signature.put(I32_ROTR, new WasmEncoding[0]);
        signature.put(I64_CLZ, new WasmEncoding[0]);
        signature.put(I64_CTZ, new WasmEncoding[0]);
        signature.put(I64_POPCNT, new WasmEncoding[0]);
        signature.put(I64_ADD, new WasmEncoding[0]);
        signature.put(I64_SUB, new WasmEncoding[0]);
        signature.put(I64_MUL, new WasmEncoding[0]);
        signature.put(I64_DIV_S, new WasmEncoding[0]);
        signature.put(I64_DIV_U, new WasmEncoding[0]);
        signature.put(I64_REM_S, new WasmEncoding[0]);
        signature.put(I64_REM_U, new WasmEncoding[0]);
        signature.put(I64_AND, new WasmEncoding[0]);
        signature.put(I64_OR, new WasmEncoding[0]);
        signature.put(I64_XOR, new WasmEncoding[0]);
        signature.put(I64_SHL, new WasmEncoding[0]);
        signature.put(I64_SHR_S, new WasmEncoding[0]);
        signature.put(I64_SHR_U, new WasmEncoding[0]);
        signature.put(I64_ROTL, new WasmEncoding[0]);
        signature.put(I64_ROTR, new WasmEncoding[0]);
        signature.put(F32_ABS, new WasmEncoding[0]);
        signature.put(F32_NEG, new WasmEncoding[0]);
        signature.put(F32_CEIL, new WasmEncoding[0]);
        signature.put(F32_FLOOR, new WasmEncoding[0]);
        signature.put(F32_TRUNC, new WasmEncoding[0]);
        signature.put(F32_NEAREST, new WasmEncoding[0]);
        signature.put(F32_SQRT, new WasmEncoding[0]);
        signature.put(F32_ADD, new WasmEncoding[0]);
        signature.put(F32_SUB, new WasmEncoding[0]);
        signature.put(F32_MUL, new WasmEncoding[0]);
        signature.put(F32_DIV, new WasmEncoding[0]);
        signature.put(F32_MIN, new WasmEncoding[0]);
        signature.put(F32_MAX, new WasmEncoding[0]);
        signature.put(F32_COPYSIGN, new WasmEncoding[0]);
        signature.put(F64_ABS, new WasmEncoding[0]);
        signature.put(F64_NEG, new WasmEncoding[0]);
        signature.put(F64_CEIL, new WasmEncoding[0]);
        signature.put(F64_FLOOR, new WasmEncoding[0]);
        signature.put(F64_TRUNC, new WasmEncoding[0]);
        signature.put(F64_NEAREST, new WasmEncoding[0]);
        signature.put(F64_SQRT, new WasmEncoding[0]);
        signature.put(F64_ADD, new WasmEncoding[0]);
        signature.put(F64_SUB, new WasmEncoding[0]);
        signature.put(F64_MUL, new WasmEncoding[0]);
        signature.put(F64_DIV, new WasmEncoding[0]);
        signature.put(F64_MIN, new WasmEncoding[0]);
        signature.put(F64_MAX, new WasmEncoding[0]);
        signature.put(F64_COPYSIGN, new WasmEncoding[0]);
        signature.put(I32_WRAP_I64, new WasmEncoding[0]);
        signature.put(I32_TRUNC_F32_S, new WasmEncoding[0]);
        signature.put(I32_TRUNC_F32_U, new WasmEncoding[0]);
        signature.put(I32_TRUNC_F64_S, new WasmEncoding[0]);
        signature.put(I32_TRUNC_F64_U, new WasmEncoding[0]);
        signature.put(I64_EXTEND_I32_S, new WasmEncoding[0]);
        signature.put(I64_EXTEND_I32_U, new WasmEncoding[0]);
        signature.put(I64_TRUNC_F32_S, new WasmEncoding[0]);
        signature.put(I64_TRUNC_F32_U, new WasmEncoding[0]);
        signature.put(I64_TRUNC_F64_S, new WasmEncoding[0]);
        signature.put(I64_TRUNC_F64_U, new WasmEncoding[0]);
        signature.put(F32_CONVERT_I32_S, new WasmEncoding[0]);
        signature.put(F32_CONVERT_I32_U, new WasmEncoding[0]);
        signature.put(F32_CONVERT_I64_S, new WasmEncoding[0]);
        signature.put(F32_CONVERT_I64_U, new WasmEncoding[0]);
        signature.put(F32_DEMOTE_F64, new WasmEncoding[0]);
        signature.put(F64_CONVERT_I32_S, new WasmEncoding[0]);
        signature.put(F64_CONVERT_I32_U, new WasmEncoding[0]);
        signature.put(F64_CONVERT_I64_S, new WasmEncoding[0]);
        signature.put(F64_CONVERT_I64_U, new WasmEncoding[0]);
        signature.put(F64_PROMOTE_F32, new WasmEncoding[0]);
        signature.put(I32_REINTERPRET_F32, new WasmEncoding[0]);
        signature.put(I64_REINTERPRET_F64, new WasmEncoding[0]);
        signature.put(F32_REINTERPRET_I32, new WasmEncoding[0]);
        signature.put(F64_REINTERPRET_I64, new WasmEncoding[0]);
        signature.put(I32_EXTEND_8_S, new WasmEncoding[0]);
        signature.put(I32_EXTEND_16_S, new WasmEncoding[0]);
        signature.put(I64_EXTEND_8_S, new WasmEncoding[0]);
        signature.put(I64_EXTEND_16_S, new WasmEncoding[0]);
        signature.put(I64_EXTEND_32_S, new WasmEncoding[0]);
        signature.put(REF_NULL, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(REF_IS_NULL, new WasmEncoding[0]);
        signature.put(REF_FUNC, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(I32_TRUNC_SAT_F32_S, new WasmEncoding[0]);
        signature.put(I32_TRUNC_SAT_F32_U, new WasmEncoding[0]);
        signature.put(I32_TRUNC_SAT_F64_S, new WasmEncoding[0]);
        signature.put(I32_TRUNC_SAT_F64_U, new WasmEncoding[0]);
        signature.put(I64_TRUNC_SAT_F32_S, new WasmEncoding[0]);
        signature.put(I64_TRUNC_SAT_F32_U, new WasmEncoding[0]);
        signature.put(I64_TRUNC_SAT_F64_S, new WasmEncoding[0]);
        signature.put(I64_TRUNC_SAT_F64_U, new WasmEncoding[0]);
        signature.put(MEMORY_INIT, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(DATA_DROP, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(MEMORY_COPY, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(MEMORY_FILL, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_INIT, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(ELEM_DROP, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_COPY, new WasmEncoding[]{WasmEncoding.VARUINT, WasmEncoding.VARUINT});
        signature.put(TABLE_GROW, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_SIZE, new WasmEncoding[]{WasmEncoding.VARUINT});
        signature.put(TABLE_FILL, new WasmEncoding[]{WasmEncoding.VARUINT});
    }
}

