/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.types.CustomSection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public class NameCustomSection
extends CustomSection {
    private String moduleName;
    private final ArrayList<NameEntry> funcNames = new ArrayList();
    private final ArrayList<ListEntry<NameEntry>> localNames = new ArrayList();
    private final ArrayList<ListEntry<NameEntry>> labelNames = new ArrayList();
    private final ArrayList<NameEntry> tableNames = new ArrayList();
    private final ArrayList<NameEntry> memoryNames = new ArrayList();
    private final ArrayList<NameEntry> globalNames = new ArrayList();
    private final ArrayList<NameEntry> elementNames = new ArrayList();
    private final ArrayList<NameEntry> dataNames = new ArrayList();
    private final ArrayList<NameEntry> tagNames = new ArrayList();

    public NameCustomSection() {
    }

    public NameCustomSection(byte[] bytes) {
        this();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        while (buf.hasRemaining()) {
            byte id = buf.get();
            ByteBuffer slice = this.slice(buf, (int)Parser.readVarUInt32(buf));
            switch (id) {
                case 0: {
                    this.setModuleName(Parser.readName(slice));
                    break;
                }
                case 1: {
                    this.oneLevelParse(slice, this.funcNames);
                    break;
                }
                case 2: {
                    this.twoLevelParse(slice, this.localNames);
                    break;
                }
                case 3: {
                    this.twoLevelParse(slice, this.labelNames);
                    break;
                }
                case 5: {
                    this.oneLevelParse(slice, this.tableNames);
                    break;
                }
                case 6: {
                    this.oneLevelParse(slice, this.memoryNames);
                    break;
                }
                case 7: {
                    this.oneLevelParse(slice, this.globalNames);
                    break;
                }
                case 8: {
                    this.oneLevelParse(slice, this.elementNames);
                    break;
                }
                case 9: {
                    this.oneLevelParse(slice, this.dataNames);
                    break;
                }
                case 11: {
                    this.oneLevelParse(slice, this.tagNames);
                    break;
                }
            }
        }
    }

    @Override
    public String name() {
        return "name";
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String nameOfFunction(int functionIdx) {
        return NameCustomSection.oneLevelSearch(this.funcNames, functionIdx);
    }

    public int functionNameCount() {
        return this.funcNames.size();
    }

    public String nameOfLocal(int functionIdx, int localIdx) {
        return NameCustomSection.twoLevelSearch(this.localNames, functionIdx, localIdx);
    }

    public String nameOfLabel(int functionIdx, int labelIdx) {
        return NameCustomSection.twoLevelSearch(this.labelNames, functionIdx, labelIdx);
    }

    public String nameOfTable(int tableIdx) {
        return NameCustomSection.oneLevelSearch(this.tableNames, tableIdx);
    }

    public String nameOfMemory(int memoryIdx) {
        return NameCustomSection.oneLevelSearch(this.memoryNames, memoryIdx);
    }

    public String nameOfGlobal(int globalIdx) {
        return NameCustomSection.oneLevelSearch(this.globalNames, globalIdx);
    }

    public String nameOfElement(int elementIdx) {
        return NameCustomSection.oneLevelSearch(this.elementNames, elementIdx);
    }

    public String nameOfData(int dataIdx) {
        return NameCustomSection.oneLevelSearch(this.dataNames, dataIdx);
    }

    public String nameOfTag(int tagIdx) {
        return NameCustomSection.oneLevelSearch(this.tagNames, tagIdx);
    }

    public String setModuleName(String moduleName) {
        try {
            String string = this.moduleName;
            return string;
        }
        finally {
            this.moduleName = Objects.requireNonNull(moduleName, "moduleName");
        }
    }

    public String addFunctionName(int functionIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, functionIdx, name);
    }

    public String addLocalName(int functionIdx, int localIdx, String name) {
        return NameCustomSection.twoLevelStore(this.localNames, functionIdx, localIdx, name);
    }

    public String addLabelName(int functionIdx, int labelIdx, String name) {
        return NameCustomSection.twoLevelStore(this.labelNames, functionIdx, labelIdx, name);
    }

    public String addTableName(int tableIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, tableIdx, name);
    }

    public String addMemoryName(int memoryIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, memoryIdx, name);
    }

    public String addGlobalName(int globalIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, globalIdx, name);
    }

    public String addElementName(int elementIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, elementIdx, name);
    }

    public String addDataName(int dataIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, dataIdx, name);
    }

    public String addTagName(int tagIdx, String name) {
        return NameCustomSection.oneLevelStore(this.funcNames, tagIdx, name);
    }

    private void oneLevelParse(ByteBuffer slice, ArrayList<NameEntry> list) {
        int cnt = (int)Parser.readVarUInt32(slice);
        for (int i = 0; i < cnt; ++i) {
            NameCustomSection.oneLevelStore(list, (int)Parser.readVarUInt32(slice), Parser.readName(slice));
        }
    }

    private void twoLevelParse(ByteBuffer slice, ArrayList<ListEntry<NameEntry>> list) {
        int listCnt = (int)Parser.readVarUInt32(slice);
        for (int i = 0; i < listCnt; ++i) {
            int groupIdx = (int)Parser.readVarUInt32(slice);
            int cnt = (int)Parser.readVarUInt32(slice);
            for (int j = 0; j < cnt; ++j) {
                NameCustomSection.twoLevelStore(list, groupIdx, (int)Parser.readVarUInt32(slice), Parser.readName(slice));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer slice(ByteBuffer buf, int size) {
        int pos = buf.position();
        int lim = buf.limit();
        try {
            buf.limit(pos + size);
            ByteBuffer byteBuffer = buf.slice();
            return byteBuffer;
        }
        finally {
            buf.limit(lim);
            buf.position(pos + size);
        }
    }

    private static String oneLevelSearch(ArrayList<NameEntry> list, int searchIdx) {
        int idx = NameCustomSection.binarySearch(list, searchIdx, NameEntry::index);
        return idx < 0 ? null : list.get(idx).name();
    }

    private static String twoLevelSearch(ArrayList<ListEntry<NameEntry>> listList, int groupIdx, int subIdx) {
        int fi = NameCustomSection.binarySearch(listList, groupIdx, ListEntry::index);
        if (fi < 0) {
            return null;
        }
        ListEntry<NameEntry> subList = listList.get(fi);
        int li = NameCustomSection.binarySearch(subList, subIdx, NameEntry::index);
        return li < 0 ? null : ((NameEntry)subList.get((int)li)).name;
    }

    private static String oneLevelStore(ArrayList<NameEntry> list, int storeIdx, String name) {
        Objects.requireNonNull(name);
        int idx = NameCustomSection.binarySearch(list, storeIdx, NameEntry::index);
        if (idx < 0) {
            list.add(-idx - 1, new NameEntry(storeIdx, name));
            return null;
        }
        return list.set(idx, new NameEntry(storeIdx, name)).name();
    }

    private static String twoLevelStore(ArrayList<ListEntry<NameEntry>> listList, int groupIdx, int subIdx, String name) {
        ListEntry<NameEntry> subList;
        Objects.requireNonNull(name);
        int fi = NameCustomSection.binarySearch(listList, groupIdx, ListEntry::index);
        if (fi < 0) {
            subList = new ListEntry(groupIdx);
            listList.add(-fi - 1, subList);
        } else {
            subList = listList.get(fi);
        }
        int li = NameCustomSection.binarySearch(subList, subIdx, NameEntry::index);
        if (li < 0) {
            subList.add(-li - 1, new NameEntry(subIdx, name));
            return null;
        }
        return subList.set(li, new NameEntry(subIdx, name)).name();
    }

    private static <T> int binarySearch(List<T> list, int idx, ToIntFunction<T> indexExtractor) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = Integer.compare(indexExtractor.applyAsInt(list.get(mid)), idx);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    static final class ListEntry<T>
    extends ArrayList<T> {
        private final int index;

        ListEntry(int index) {
            this.index = index;
        }

        int index() {
            return this.index;
        }

        @Override
        public String toString() {
            return "[" + this.index + "] -> " + super.toString();
        }
    }

    static final class NameEntry {
        private final int index;
        private final String name;

        NameEntry(int index, String name) {
            this.index = index;
            this.name = name;
        }

        int index() {
            return this.index;
        }

        String name() {
            return this.name;
        }

        public String toString() {
            return "[" + this.index + "] -> " + this.name;
        }
    }
}

