/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.OpCode;
import java.util.Arrays;

public class Instruction {
    private final int address;
    private final OpCode opcode;
    private final long[] operands;
    private Integer labelTrue;
    private Integer labelFalse;
    private int[] labelTable;
    private int depth;
    private Instruction scope;

    public Instruction(int address, OpCode opcode, long[] operands) {
        this.address = address;
        this.opcode = opcode;
        this.operands = operands;
    }

    public OpCode opcode() {
        return this.opcode;
    }

    public long[] operands() {
        return this.operands;
    }

    public String toString() {
        String result = String.format("0x%08X", this.address) + ": ";
        if (this.operands.length > 0) {
            return result + this.opcode + " " + Arrays.toString(this.operands);
        }
        return result + this.opcode.toString();
    }

    public int address() {
        return this.address;
    }

    public Integer labelTrue() {
        return this.labelTrue;
    }

    public void setLabelTrue(Integer labelTrue) {
        this.labelTrue = labelTrue;
    }

    public Integer labelFalse() {
        return this.labelFalse;
    }

    public void setLabelFalse(Integer labelFalse) {
        this.labelFalse = labelFalse;
    }

    public int[] labelTable() {
        return this.labelTable;
    }

    public void setLabelTable(int[] labelTable) {
        this.labelTable = labelTable;
    }

    public int depth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public Instruction scope() {
        return this.scope;
    }

    public void setScope(Instruction scope) {
        this.scope = scope;
    }
}

