/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.wasm.exceptions.MalformedException;
import java.nio.ByteBuffer;

public final class Encoding {
    public static long readUnsignedLeb128(ByteBuffer byteBuffer) {
        long result = 0L;
        int shift = 0;
        while (true) {
            if (byteBuffer.remaining() == 0) {
                throw new MalformedException("unexpected end");
            }
            byte b = byteBuffer.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public static long readSigned32Leb128(ByteBuffer byteBuffer) {
        byte currentByte;
        long result = 0L;
        int shift = 0;
        do {
            if (byteBuffer.remaining() == 0) {
                throw new IllegalArgumentException("SLEB128 reached the end of the buffer");
            }
            currentByte = byteBuffer.get();
            result |= (long)(currentByte & 0x7F) << shift;
            shift += 7;
        } while ((currentByte & 0x80) != 0);
        if ((currentByte & 0x40) != 0) {
            result |= -(1L << shift);
        }
        return result;
    }

    public static long readSigned64Leb128(ByteBuffer byteBuffer) {
        byte currentByte;
        long result = 0L;
        int shift = 0;
        int size = 64;
        do {
            if (byteBuffer.remaining() == 0) {
                throw new IllegalArgumentException("LEB128 reached the end of the buffer");
            }
            currentByte = byteBuffer.get();
            result |= (long)(currentByte & 0x7F) << shift;
            shift += 7;
        } while ((currentByte & 0x80) != 0);
        if (shift < size && (currentByte & 0x40) != 0) {
            result |= -1L << shift;
        }
        return result;
    }

    public static int computeLeb128Size(int value) {
        int size = 0;
        do {
            ++size;
        } while ((value >>>= 7) != 0);
        return size;
    }
}

