/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ConstantEvaluators;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.WasmRuntimeException;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.UninstantiableException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public final class ByteBufferMemory
implements Memory {
    private final MemoryLimits limits;
    private DataSegment[] dataSegments;
    private ByteBuffer buffer;
    private int nPages;

    public ByteBufferMemory(MemoryLimits limits) {
        this.limits = limits;
        this.buffer = ByteBufferMemory.allocateByteBuffer(65536 * limits.initialPages());
        this.nPages = limits.initialPages();
    }

    private static ByteBuffer allocateByteBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int pages() {
        return this.nPages;
    }

    @Override
    public int grow(int size) {
        int prevPages = this.nPages;
        int numPages = prevPages + size;
        if (numPages > this.maximumPages() || numPages < prevPages) {
            return -1;
        }
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = ByteBufferMemory.allocateByteBuffer(oldBuffer.capacity() + 65536 * size);
        int position = oldBuffer.position();
        oldBuffer.rewind();
        newBuffer.put(oldBuffer);
        newBuffer.position(position);
        this.buffer = newBuffer;
        this.nPages = numPages;
        return prevPages;
    }

    @Override
    public int initialPages() {
        return this.limits.initialPages();
    }

    @Override
    public int maximumPages() {
        return Math.min(this.limits.maximumPages(), Short.MAX_VALUE);
    }

    @Override
    public void initialize(Instance instance, DataSegment[] dataSegments) {
        this.dataSegments = dataSegments;
        if (dataSegments == null) {
            return;
        }
        for (DataSegment s : dataSegments) {
            if (s instanceof ActiveDataSegment) {
                ActiveDataSegment segment = (ActiveDataSegment)s;
                List offsetExpr = segment.offsetInstructions();
                byte[] data = segment.data();
                int offset = (int)ConstantEvaluators.computeConstantValue(instance, offsetExpr);
                ByteBufferMemory.checkBounds(offset, data.length, this.buffer.limit(), msg -> new UninstantiableException(msg));
                this.buffer.position(offset);
                this.buffer.put(data, 0, data.length);
                continue;
            }
            if (s instanceof PassiveDataSegment) continue;
            throw new ChicoryException("Data segment should be active or passive: " + String.valueOf(s));
        }
    }

    private static void checkBounds(int addr, int size, int limit, Function<String, ChicoryException> exceptionFactory) {
        if (addr < 0 || size < 0 || addr > limit || size > 0 && addr + size > limit) {
            String errorMsg = "out of bounds memory access: attempted to access address: " + addr + " but limit is: " + limit;
            throw exceptionFactory.apply(errorMsg);
        }
    }

    private static void checkBounds(int addr, int size, int limit) {
        ByteBufferMemory.checkBounds(addr, size, limit, msg -> new WasmRuntimeException((String)msg));
    }

    @Override
    public void initPassiveSegment(int segmentId, int dest, int offset, int size) {
        DataSegment segment = this.dataSegments[segmentId];
        this.write(dest, segment.data(), offset, size);
    }

    @Override
    public void write(int addr, byte[] data, int offset, int size) {
        ByteBufferMemory.checkBounds(addr, size, this.buffer.limit());
        if (data.length < offset + size) {
            throw new WasmRuntimeException("out of bounds memory access: attempted to access data with length: " + data.length + " at address: " + (offset + size));
        }
        this.buffer.position(addr);
        this.buffer.put(data, offset, size);
    }

    @Override
    public byte read(int addr) {
        ByteBufferMemory.checkBounds(addr, 1, this.buffer.limit());
        return this.buffer.get(addr);
    }

    @Override
    public byte[] readBytes(int addr, int len) {
        ByteBufferMemory.checkBounds(addr, len, this.buffer.limit());
        byte[] bytes = new byte[len];
        this.buffer.position(addr);
        this.buffer.get(bytes);
        return bytes;
    }

    @Override
    public void writeI32(int addr, int data) {
        ByteBufferMemory.checkBounds(addr, 4, this.buffer.limit());
        this.buffer.putInt(addr, data);
    }

    @Override
    public int readInt(int addr) {
        ByteBufferMemory.checkBounds(addr, 4, this.buffer.limit());
        return this.buffer.getInt(addr);
    }

    @Override
    public void writeLong(int addr, long data) {
        ByteBufferMemory.checkBounds(addr, 8, this.buffer.limit());
        this.buffer.putLong(addr, data);
    }

    @Override
    public long readLong(int addr) {
        ByteBufferMemory.checkBounds(addr, 8, this.buffer.limit());
        return this.buffer.getLong(addr);
    }

    @Override
    public void writeShort(int addr, short data) {
        ByteBufferMemory.checkBounds(addr, 2, this.buffer.limit());
        this.buffer.putShort(addr, data);
    }

    @Override
    public short readShort(int addr) {
        ByteBufferMemory.checkBounds(addr, 2, this.buffer.limit());
        return this.buffer.getShort(addr);
    }

    @Override
    public long readU16(int addr) {
        ByteBufferMemory.checkBounds(addr, 2, this.buffer.limit());
        return this.buffer.getShort(addr) & 0xFFFF;
    }

    @Override
    public void writeByte(int addr, byte data) {
        ByteBufferMemory.checkBounds(addr, 1, this.buffer.limit());
        this.buffer.put(addr, data);
    }

    @Override
    public void writeF32(int addr, float data) {
        ByteBufferMemory.checkBounds(addr, 4, this.buffer.limit());
        this.buffer.putFloat(addr, data);
    }

    @Override
    public long readF32(int addr) {
        ByteBufferMemory.checkBounds(addr, 4, this.buffer.limit());
        return this.buffer.getInt(addr);
    }

    @Override
    public float readFloat(int addr) {
        ByteBufferMemory.checkBounds(addr, 4, this.buffer.limit());
        return this.buffer.getFloat(addr);
    }

    @Override
    public void writeF64(int addr, double data) {
        ByteBufferMemory.checkBounds(addr, 8, this.buffer.limit());
        this.buffer.putDouble(addr, data);
    }

    @Override
    public double readDouble(int addr) {
        ByteBufferMemory.checkBounds(addr, 8, this.buffer.limit());
        return this.buffer.getDouble(addr);
    }

    @Override
    public long readF64(int addr) {
        ByteBufferMemory.checkBounds(addr, 8, this.buffer.limit());
        return this.buffer.getLong(addr);
    }

    @Override
    public void zero() {
        this.fill((byte)0, 0, this.buffer.capacity());
    }

    @Override
    public void fill(byte value, int fromIndex, int toIndex) {
        ByteBufferMemory.checkBounds(fromIndex, toIndex - fromIndex, this.buffer.limit());
        Arrays.fill(this.buffer.array(), fromIndex, toIndex, value);
        this.buffer.position(0);
    }

    @Override
    public void drop(int segment) {
        this.dataSegments[segment] = PassiveDataSegment.EMPTY;
    }
}

