/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.wasm.types.ElementType;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Table;
import java.util.Map;

public class HostTable
implements FromHost {
    private final String moduleName;
    private final String fieldName;
    private final Table table;

    public HostTable(String moduleName, String fieldName, Table table) {
        this.moduleName = moduleName;
        this.fieldName = fieldName;
        this.table = table;
    }

    public HostTable(String moduleName, String fieldName, Map<Integer, Integer> funcRefs) {
        this.moduleName = moduleName;
        this.fieldName = fieldName;
        long maxFuncRef = 0L;
        for (Integer k : funcRefs.keySet()) {
            if ((long)k.intValue() <= maxFuncRef) continue;
            maxFuncRef = k.intValue();
        }
        this.table = new Table(ElementType.FuncRef, new Limits(maxFuncRef, maxFuncRef));
        int i = 0;
        while ((long)i < maxFuncRef) {
            this.table.setRef(i, funcRefs.getOrDefault(i, -1).intValue());
            ++i;
        }
    }

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public FromHost.FromHostType type() {
        return FromHost.FromHostType.TABLE;
    }

    public Table table() {
        return this.table;
    }
}

