/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.runtime.exceptions.WASMRuntimeException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import com.dylibso.chicory.wasm.types.Value;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Memory {
    public static final int PAGE_SIZE = 65536;
    private final MemoryLimits limits;
    private DataSegment[] dataSegments;
    private ByteBuffer buffer;
    private int nPages;

    public Memory(MemoryLimits limits) {
        this.limits = limits;
        this.buffer = Memory.allocateByteBuffer(65536 * limits.initialPages());
        this.nPages = limits.initialPages();
    }

    private static ByteBuffer allocateByteBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public int pages() {
        return this.nPages;
    }

    public int grow(int size) {
        int prevPages = this.nPages;
        int numPages = prevPages + size;
        if (numPages > this.limits.maximumPages()) {
            return -1;
        }
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = Memory.allocateByteBuffer(oldBuffer.capacity() + 65536 * size);
        int position = oldBuffer.position();
        oldBuffer.rewind();
        newBuffer.put(oldBuffer);
        newBuffer.position(position);
        this.buffer = newBuffer;
        this.nPages = numPages;
        return prevPages;
    }

    public int initialPages() {
        return this.limits.initialPages();
    }

    public int maximumPages() {
        return this.limits.maximumPages();
    }

    public void initialize(DataSegment[] dataSegments) {
        this.dataSegments = dataSegments;
        this.zero();
        if (dataSegments == null) {
            return;
        }
        for (DataSegment s : dataSegments) {
            if (s instanceof ActiveDataSegment) {
                ActiveDataSegment segment = (ActiveDataSegment)s;
                Instruction[] offsetExpr = segment.offsetInstructions();
                byte[] data = segment.data();
                int offset = Module.computeConstantValue(offsetExpr);
                this.write(offset, data);
                continue;
            }
            if (s instanceof PassiveDataSegment) continue;
            throw new ChicoryException("Data segment should be active or passive: " + s);
        }
    }

    public void initPassiveSegment(int segmentId, int dest, int offset, int size) {
        DataSegment segment = this.dataSegments[segmentId];
        if (!(segment instanceof PassiveDataSegment)) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
        this.write(dest, segment.data(), offset, size);
    }

    public void writeString(int offset, String data) {
        this.write(offset, data.getBytes(StandardCharsets.UTF_8));
    }

    public String readString(int addr, int len) {
        return new String(this.readBytes(addr, len), StandardCharsets.UTF_8);
    }

    public void write(int addr, byte[] data) {
        this.write(addr, data, 0, data.length);
    }

    public void write(int addr, byte[] data, int offset, int size) {
        try {
            this.buffer.position(addr);
            this.buffer.put(data, offset, size);
        }
        catch (Exception e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public byte read(int addr) {
        try {
            return this.buffer.get(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public byte[] readBytes(int addr, int len) {
        try {
            byte[] bytes = new byte[len];
            this.buffer.position(addr);
            this.buffer.get(bytes);
            return bytes;
        }
        catch (Exception e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void write(int addr, Value data) {
        this.write(addr, data.data());
    }

    public void writeI32(int addr, int data) {
        try {
            this.buffer.putInt(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readI32(int addr) {
        try {
            return Value.i32((long)this.buffer.getInt(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readU32(int addr) {
        try {
            return Value.i32((long)((long)this.buffer.getInt(addr) & 0xFFFFFFFFL));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void writeLong(int addr, long data) {
        try {
            this.buffer.putLong(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readI64(int addr) {
        try {
            return Value.i64((long)this.buffer.getLong(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void writeShort(int addr, short data) {
        try {
            this.buffer.putShort(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readI16(int addr) {
        try {
            return Value.i32((long)this.buffer.getShort(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readU16(int addr) {
        try {
            return Value.i32((long)(this.buffer.getShort(addr) & 0xFFFF));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void writeByte(int addr, byte data) {
        try {
            this.buffer.put(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readU8(int addr) {
        try {
            return Value.i32((long)(this.read(addr) & 0xFF));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readI8(int addr) {
        try {
            return Value.i32((long)this.read(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void writeF32(int addr, float data) {
        try {
            this.buffer.putFloat(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readF32(int addr) {
        try {
            return Value.f32((long)this.buffer.getInt(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void writeF64(int addr, double data) {
        try {
            this.buffer.putDouble(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public Value readF64(int addr) {
        try {
            return Value.f64((long)this.buffer.getLong(addr));
        }
        catch (IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void zero() {
        this.fill((byte)0);
    }

    public void fill(byte value) {
        this.fill(value, 0, this.buffer.capacity());
    }

    public void fill(byte value, int fromIndex, int toIndex) {
        try {
            Arrays.fill(this.buffer.array(), fromIndex, toIndex, value);
            this.buffer.position(0);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
    }

    public void copy(int dest, int src, int size) {
        this.write(dest, this.readBytes(src, size));
    }

    public void drop(int segment) {
        this.dataSegments[segment] = PassiveDataSegment.EMPTY;
    }
}

