/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.HostGlobal;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.runtime.StackFrame;
import com.dylibso.chicory.runtime.TrapException;
import com.dylibso.chicory.runtime.WasmFunctionHandle;
import com.dylibso.chicory.runtime.exceptions.WASMRuntimeException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.ElemElem;
import com.dylibso.chicory.wasm.types.ElemFunc;
import com.dylibso.chicory.wasm.types.ElemType;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayDeque;
import java.util.List;

class Machine {
    private final MStack stack;
    private final ArrayDeque<StackFrame> callStack;
    private final Instance instance;

    public Machine(Instance instance) {
        this.instance = instance;
        this.stack = new MStack();
        this.callStack = new ArrayDeque();
    }

    public Value[] call(int funcId, Value[] args, boolean popResults) throws ChicoryException {
        return Machine.call(this.stack, this.instance, this.callStack, funcId, args, null, popResults);
    }

    public static Value[] call(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, int funcId, Value[] args, FunctionType callType, boolean popResults) throws ChicoryException {
        FunctionBody func;
        int typeId = instance.functionType(funcId);
        FunctionType type = instance.type(typeId);
        if (callType != null) {
            Machine.verifyIndirectCall(type, callType);
        }
        if ((func = instance.function(funcId)) != null) {
            callStack.push(new StackFrame(func.instructions(), instance, funcId, args, func.localTypes()));
            Machine.eval(stack, instance, callStack);
        } else {
            callStack.push(new StackFrame(instance, funcId, args, List.of()));
            FromHost imprt = instance.imports().index()[funcId];
            if (imprt == null) {
                throw new ChicoryException("Missing host import, number: " + funcId);
            }
            switch (imprt.type()) {
                case FUNCTION: {
                    WasmFunctionHandle hostFunc = ((HostFunction)imprt).handle();
                    Value[] results = hostFunc.apply(instance, args);
                    if (results == null) break;
                    for (Value result : results) {
                        stack.push(result);
                    }
                    break;
                }
                case GLOBAL: {
                    stack.push(((HostGlobal)imprt).value());
                    break;
                }
                default: {
                    throw new ChicoryException("Not implemented");
                }
            }
        }
        if (!callStack.isEmpty()) {
            callStack.pop();
        }
        if (!popResults) {
            return null;
        }
        if (type.returns().length == 0) {
            return null;
        }
        if (stack.size() == 0) {
            return null;
        }
        int totalResults = type.returns().length;
        Value[] results = new Value[totalResults];
        for (int i = totalResults - 1; i >= 0; --i) {
            results[i] = stack.pop();
        }
        return results;
    }

    static void eval(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack) throws ChicoryException {
        block208: {
            try {
                StackFrame frame = callStack.peek();
                boolean shouldReturn = false;
                block203: while (!frame.terminated()) {
                    if (shouldReturn) {
                        return;
                    }
                    Instruction instruction = frame.loadCurrentInstruction();
                    OpCode opcode = instruction.opcode();
                    long[] operands = instruction.operands();
                    switch (opcode) {
                        case UNREACHABLE: {
                            throw new TrapException("Trapped on unreachable instruction", callStack);
                        }
                        case NOP: {
                            break;
                        }
                        case LOOP: 
                        case BLOCK: {
                            Machine.BLOCK(frame, stack);
                            break;
                        }
                        case IF: {
                            Machine.IF(frame, stack, instruction);
                            break;
                        }
                        case ELSE: 
                        case BR: {
                            Machine.prepareControlTransfer(frame, stack, false);
                            frame.jumpTo(instruction.labelTrue());
                            break;
                        }
                        case BR_IF: {
                            Machine.BR_IF(frame, stack, instruction);
                            break;
                        }
                        case BR_TABLE: {
                            Machine.BR_TABLE(frame, stack, instruction);
                            break;
                        }
                        case RETURN: {
                            shouldReturn = true;
                            break;
                        }
                        case CALL_INDIRECT: {
                            Machine.CALL_INDIRECT(stack, instance, callStack, operands);
                            break;
                        }
                        case DROP: {
                            stack.pop();
                            break;
                        }
                        case SELECT: {
                            Machine.SELECT(stack);
                            break;
                        }
                        case END: {
                            if (frame.doControlTransfer && frame.isControlFrame) {
                                Machine.doControlTransfer(instance, stack, frame, instruction.scope());
                            } else {
                                frame.endOfNonControlBlock();
                            }
                            if (!frame.isLastBlock()) continue block203;
                            break block208;
                        }
                        case LOCAL_GET: {
                            stack.push(frame.local((int)operands[0]));
                            break;
                        }
                        case LOCAL_SET: {
                            frame.setLocal((int)operands[0], stack.pop());
                            break;
                        }
                        case LOCAL_TEE: {
                            frame.setLocal((int)operands[0], stack.peek());
                            break;
                        }
                        case GLOBAL_GET: {
                            Machine.GLOBAL_GET(stack, instance, operands);
                            break;
                        }
                        case GLOBAL_SET: {
                            Machine.GLOBAL_SET(stack, instance, operands);
                            break;
                        }
                        case TABLE_GET: {
                            Machine.TABLE_GET(stack, instance, operands);
                            break;
                        }
                        case TABLE_SET: {
                            Machine.TABLE_SET(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD: {
                            Machine.I32_LOAD(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD: {
                            Machine.I64_LOAD(stack, instance, operands);
                            break;
                        }
                        case F32_LOAD: {
                            Machine.F32_LOAD(stack, instance, operands);
                            break;
                        }
                        case F64_LOAD: {
                            Machine.F64_LOAD(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD8_S: {
                            Machine.I32_LOAD8_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD8_S: {
                            Machine.I64_LOAD8_S(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD8_U: {
                            Machine.I32_LOAD8_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD8_U: {
                            Machine.I64_LOAD8_U(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD16_S: {
                            Machine.I32_LOAD16_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD16_S: {
                            Machine.I64_LOAD16_S(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD16_U: {
                            Machine.I32_LOAD16_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD16_U: {
                            Machine.I64_LOAD16_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD32_S: {
                            Machine.I64_LOAD32_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD32_U: {
                            Machine.I64_LOAD32_U(stack, instance, operands);
                            break;
                        }
                        case I32_STORE: {
                            Machine.I32_STORE(stack, instance, operands);
                            break;
                        }
                        case I32_STORE16: 
                        case I64_STORE16: {
                            Machine.I64_STORE16(stack, instance, operands);
                            break;
                        }
                        case I64_STORE: {
                            Machine.I64_STORE(stack, instance, operands);
                            break;
                        }
                        case F32_STORE: {
                            Machine.F32_STORE(stack, instance, operands);
                            break;
                        }
                        case F64_STORE: {
                            Machine.F64_STORE(stack, instance, operands);
                            break;
                        }
                        case MEMORY_GROW: {
                            Machine.MEMORY_GROW(stack, instance);
                            break;
                        }
                        case MEMORY_FILL: {
                            Machine.MEMORY_FILL(stack, instance, operands);
                            break;
                        }
                        case I32_STORE8: 
                        case I64_STORE8: {
                            Machine.I64_STORE8(stack, instance, operands);
                            break;
                        }
                        case I64_STORE32: {
                            Machine.I64_STORE32(stack, instance, operands);
                            break;
                        }
                        case MEMORY_SIZE: {
                            Machine.MEMORY_SIZE(stack, instance);
                            break;
                        }
                        case I32_CONST: {
                            stack.push(Value.i32((long)operands[0]));
                            break;
                        }
                        case I64_CONST: {
                            stack.push(Value.i64((long)operands[0]));
                            break;
                        }
                        case F32_CONST: {
                            stack.push(Value.f32((long)operands[0]));
                            break;
                        }
                        case F64_CONST: {
                            stack.push(Value.f64((long)operands[0]));
                            break;
                        }
                        case I32_EQ: {
                            Machine.I32_EQ(stack);
                            break;
                        }
                        case I64_EQ: {
                            Machine.I64_EQ(stack);
                            break;
                        }
                        case I32_NE: {
                            Machine.I32_NE(stack);
                            break;
                        }
                        case I64_NE: {
                            Machine.I64_NE(stack);
                            break;
                        }
                        case I32_EQZ: {
                            Machine.I32_EQZ(stack);
                            break;
                        }
                        case I64_EQZ: {
                            Machine.I64_EQZ(stack);
                            break;
                        }
                        case I32_LT_S: {
                            Machine.I32_LT_S(stack);
                            break;
                        }
                        case I32_LT_U: {
                            Machine.I32_LT_U(stack);
                            break;
                        }
                        case I64_LT_S: {
                            Machine.I64_LT_S(stack);
                            break;
                        }
                        case I64_LT_U: {
                            Machine.I64_LT_U(stack);
                            break;
                        }
                        case I32_GT_S: {
                            Machine.I32_GT_S(stack);
                            break;
                        }
                        case I32_GT_U: {
                            Machine.I32_GT_U(stack);
                            break;
                        }
                        case I64_GT_S: {
                            Machine.I64_GT_S(stack);
                            break;
                        }
                        case I64_GT_U: {
                            Machine.I64_GT_U(stack);
                            break;
                        }
                        case I32_GE_S: {
                            Machine.I32_GE_S(stack);
                            break;
                        }
                        case I32_GE_U: {
                            Machine.I32_GE_U(stack);
                            break;
                        }
                        case I64_GE_U: {
                            Machine.I64_GE_U(stack);
                            break;
                        }
                        case I64_GE_S: {
                            Machine.I64_GE_S(stack);
                            break;
                        }
                        case I32_LE_S: {
                            Machine.I32_LE_S(stack);
                            break;
                        }
                        case I32_LE_U: {
                            Machine.I32_LE_U(stack);
                            break;
                        }
                        case I64_LE_S: {
                            Machine.I64_LE_S(stack);
                            break;
                        }
                        case I64_LE_U: {
                            Machine.I64_LE_U(stack);
                            break;
                        }
                        case F32_EQ: {
                            Machine.F32_EQ(stack);
                            break;
                        }
                        case F64_EQ: {
                            Machine.F64_EQ(stack);
                            break;
                        }
                        case I32_CLZ: {
                            Machine.I32_CLZ(stack);
                            break;
                        }
                        case I32_CTZ: {
                            Machine.I32_CTZ(stack);
                            break;
                        }
                        case I32_POPCNT: {
                            Machine.I32_POPCNT(stack);
                            break;
                        }
                        case I32_ADD: {
                            Machine.I32_ADD(stack);
                            break;
                        }
                        case I64_ADD: {
                            Machine.I64_ADD(stack);
                            break;
                        }
                        case I32_SUB: {
                            Machine.I32_SUB(stack);
                            break;
                        }
                        case I64_SUB: {
                            Machine.I64_SUB(stack);
                            break;
                        }
                        case I32_MUL: {
                            Machine.I32_MUL(stack);
                            break;
                        }
                        case I64_MUL: {
                            Machine.I64_MUL(stack);
                            break;
                        }
                        case I32_DIV_S: {
                            Machine.I32_DIV_S(stack);
                            break;
                        }
                        case I32_DIV_U: {
                            Machine.I32_DIV_U(stack);
                            break;
                        }
                        case I64_DIV_S: {
                            Machine.I64_DIV_S(stack);
                            break;
                        }
                        case I64_DIV_U: {
                            Machine.I64_DIV_U(stack);
                            break;
                        }
                        case I32_REM_S: {
                            Machine.I32_REM_S(stack);
                            break;
                        }
                        case I32_REM_U: {
                            Machine.I32_REM_U(stack);
                            break;
                        }
                        case I64_AND: {
                            Machine.I64_AND(stack);
                            break;
                        }
                        case I64_OR: {
                            Machine.I64_OR(stack);
                            break;
                        }
                        case I64_XOR: {
                            Machine.I64_XOR(stack);
                            break;
                        }
                        case I64_SHL: {
                            Machine.I64_SHL(stack);
                            break;
                        }
                        case I64_SHR_S: {
                            Machine.I64_SHR_S(stack);
                            break;
                        }
                        case I64_SHR_U: {
                            Machine.I64_SHR_U(stack);
                            break;
                        }
                        case I64_REM_S: {
                            Machine.I64_REM_S(stack);
                            break;
                        }
                        case I64_REM_U: {
                            Machine.I64_REM_U(stack);
                            break;
                        }
                        case I64_ROTL: {
                            Machine.I64_ROTL(stack);
                            break;
                        }
                        case I64_ROTR: {
                            Machine.I64_ROTR(stack);
                            break;
                        }
                        case I64_CLZ: {
                            Machine.I64_CLZ(stack);
                            break;
                        }
                        case I64_CTZ: {
                            Machine.I64_CTZ(stack);
                            break;
                        }
                        case I64_POPCNT: {
                            Machine.I64_POPCNT(stack);
                            break;
                        }
                        case F32_NEG: {
                            Machine.F32_NEG(stack);
                            break;
                        }
                        case F64_NEG: {
                            Machine.F64_NEG(stack);
                            break;
                        }
                        case CALL: {
                            Machine.CALL(stack, instance, callStack, operands);
                            break;
                        }
                        case I32_AND: {
                            Machine.I32_AND(stack);
                            break;
                        }
                        case I32_OR: {
                            Machine.I32_OR(stack);
                            break;
                        }
                        case I32_XOR: {
                            Machine.I32_XOR(stack);
                            break;
                        }
                        case I32_SHL: {
                            Machine.I32_SHL(stack);
                            break;
                        }
                        case I32_SHR_S: {
                            Machine.I32_SHR_S(stack);
                            break;
                        }
                        case I32_SHR_U: {
                            Machine.I32_SHR_U(stack);
                            break;
                        }
                        case I32_ROTL: {
                            Machine.I32_ROTL(stack);
                            break;
                        }
                        case I32_ROTR: {
                            Machine.I32_ROTR(stack);
                            break;
                        }
                        case F32_ADD: {
                            Machine.F32_ADD(stack);
                            break;
                        }
                        case F64_ADD: {
                            Machine.F64_ADD(stack);
                            break;
                        }
                        case F32_SUB: {
                            Machine.F32_SUB(stack);
                            break;
                        }
                        case F64_SUB: {
                            Machine.F64_SUB(stack);
                            break;
                        }
                        case F32_MUL: {
                            Machine.F32_MUL(stack);
                            break;
                        }
                        case F64_MUL: {
                            Machine.F64_MUL(stack);
                            break;
                        }
                        case F32_DIV: {
                            Machine.F32_DIV(stack);
                            break;
                        }
                        case F64_DIV: {
                            Machine.F64_DIV(stack);
                            break;
                        }
                        case F32_MIN: {
                            Machine.F32_MIN(stack);
                            break;
                        }
                        case F64_MIN: {
                            Machine.F64_MIN(stack);
                            break;
                        }
                        case F32_MAX: {
                            Machine.F32_MAX(stack);
                            break;
                        }
                        case F64_MAX: {
                            Machine.F64_MAX(stack);
                            break;
                        }
                        case F32_SQRT: {
                            Machine.F32_SQRT(stack);
                            break;
                        }
                        case F64_SQRT: {
                            Machine.F64_SQRT(stack);
                            break;
                        }
                        case F32_FLOOR: {
                            Machine.F32_FLOOR(stack);
                            break;
                        }
                        case F64_FLOOR: {
                            Machine.F64_FLOOR(stack);
                            break;
                        }
                        case F32_CEIL: {
                            Machine.F32_CEIL(stack);
                            break;
                        }
                        case F64_CEIL: {
                            Machine.F64_CEIL(stack);
                            break;
                        }
                        case F32_TRUNC: {
                            Machine.F32_TRUNC(stack);
                            break;
                        }
                        case F64_TRUNC: {
                            Machine.F64_TRUNC(stack);
                            break;
                        }
                        case F32_NEAREST: {
                            Machine.F32_NEAREST(stack);
                            break;
                        }
                        case F64_NEAREST: {
                            Machine.F64_NEAREST(stack);
                            break;
                        }
                        case I32_EXTEND_8_S: {
                            Machine.I32_EXTEND_8_S(stack);
                            break;
                        }
                        case I32_EXTEND_16_S: {
                            Machine.I32_EXTEND_16_S(stack);
                            break;
                        }
                        case I64_EXTEND_8_S: {
                            Machine.I64_EXTEND_8_S(stack);
                            break;
                        }
                        case I64_EXTEND_16_S: {
                            Machine.I64_EXTEND_16_S(stack);
                            break;
                        }
                        case I64_EXTEND_32_S: {
                            Machine.I64_EXTEND_32_S(stack);
                            break;
                        }
                        case F64_CONVERT_I64_U: {
                            Machine.F64_CONVERT_I64_U(stack);
                            break;
                        }
                        case F64_CONVERT_I32_U: {
                            Machine.F64_CONVERT_I32_U(stack);
                            break;
                        }
                        case F64_CONVERT_I32_S: {
                            Machine.F64_CONVERT_I32_S(stack);
                            break;
                        }
                        case F64_PROMOTE_F32: {
                            Machine.F64_PROMOTE_F32(stack);
                            break;
                        }
                        case F64_REINTERPRET_I64: {
                            Machine.F64_REINTERPRET_I64(stack);
                            break;
                        }
                        case I64_TRUNC_F64_S: {
                            Machine.I64_TRUNC_F64_S(stack);
                            break;
                        }
                        case I32_WRAP_I64: {
                            Machine.I32_WRAP_I64(stack);
                            break;
                        }
                        case I64_EXTEND_I32_S: {
                            Machine.I64_EXTEND_I32_S(stack);
                            break;
                        }
                        case I64_EXTEND_I32_U: {
                            Machine.I64_EXTEND_I32_U(stack);
                            break;
                        }
                        case I32_REINTERPRET_F32: {
                            Machine.I32_REINTERPRET_F32(stack);
                            break;
                        }
                        case I64_REINTERPRET_F64: {
                            Machine.I64_REINTERPRET_F64(stack);
                            break;
                        }
                        case F32_REINTERPRET_I32: {
                            Machine.F32_REINTERPRET_I32(stack);
                            break;
                        }
                        case F32_COPYSIGN: {
                            Machine.F32_COPYSIGN(stack);
                            break;
                        }
                        case F32_ABS: {
                            Machine.F32_ABS(stack);
                            break;
                        }
                        case F64_COPYSIGN: {
                            Machine.F64_COPYSIGN(stack);
                            break;
                        }
                        case F64_ABS: {
                            Machine.F64_ABS(stack);
                            break;
                        }
                        case F32_NE: {
                            Machine.F32_NE(stack);
                            break;
                        }
                        case F64_NE: {
                            Machine.F64_NE(stack);
                            break;
                        }
                        case F32_LT: {
                            Machine.F32_LT(stack);
                            break;
                        }
                        case F64_LT: {
                            Machine.F64_LT(stack);
                            break;
                        }
                        case F32_LE: {
                            Machine.F32_LE(stack);
                            break;
                        }
                        case F64_LE: {
                            Machine.F64_LE(stack);
                            break;
                        }
                        case F32_GE: {
                            Machine.F32_GE(stack);
                            break;
                        }
                        case F64_GE: {
                            Machine.F64_GE(stack);
                            break;
                        }
                        case F32_GT: {
                            Machine.F32_GT(stack);
                            break;
                        }
                        case F64_GT: {
                            Machine.F64_GT(stack);
                            break;
                        }
                        case F32_DEMOTE_F64: {
                            Machine.F32_DEMOTE_F64(stack);
                            break;
                        }
                        case F32_CONVERT_I32_S: {
                            Machine.F32_CONVERT_I32_S(stack);
                            break;
                        }
                        case I32_TRUNC_F32_S: {
                            Machine.I32_TRUNC_F32_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F32_S: {
                            Machine.I32_TRUNC_SAT_F32_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F32_U: {
                            Machine.I32_TRUNC_SAT_F32_U(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F64_S: {
                            Machine.I32_TRUNC_SAY_F64_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F64_U: {
                            Machine.I32_TRUNC_SAT_F64_U(stack);
                            break;
                        }
                        case F32_CONVERT_I32_U: {
                            Machine.F32_CONVERT_I32_U(stack);
                            break;
                        }
                        case I32_TRUNC_F32_U: {
                            Machine.I32_TRUNC_F32_U(stack);
                            break;
                        }
                        case F32_CONVERT_I64_S: {
                            Machine.F32_CONVERT_I64_S(stack);
                            break;
                        }
                        case F32_CONVERT_I64_U: {
                            Machine.F32_CONVERT_I64_U(stack);
                            break;
                        }
                        case F64_CONVERT_I64_S: {
                            Machine.F64_CONVERT_I64_S(stack);
                            break;
                        }
                        case I64_TRUNC_F32_U: {
                            Machine.I64_TRUNC_F32_U(stack);
                            break;
                        }
                        case I64_TRUNC_F64_U: {
                            Machine.I64_TRUNC_F64_U(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F32_S: {
                            Machine.I64_TRUNC_SAT_F32_S(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F32_U: {
                            Machine.I64_TRUNC_SAT_F32_U(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F64_S: {
                            Machine.I64_TRUNC_SAT_F64_S(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F64_U: {
                            Machine.I64_TRUNC_SAT_F64_U(stack);
                            break;
                        }
                        case I32_TRUNC_F64_S: {
                            Machine.I32_TRUNC_F64_S(stack);
                            break;
                        }
                        case I32_TRUNC_F64_U: {
                            Machine.I32_TRUNC_F64_U(stack);
                            break;
                        }
                        case I64_TRUNC_F32_S: {
                            Machine.I64_TRUNC_F32_S(stack);
                            break;
                        }
                        case MEMORY_INIT: {
                            Machine.MEMORY_INIT(stack, instance, operands);
                            break;
                        }
                        case TABLE_INIT: {
                            Machine.TABLE_INIT(stack, instance, operands);
                            break;
                        }
                        case DATA_DROP: {
                            Machine.DATA_DROP(instance, operands);
                            break;
                        }
                        case MEMORY_COPY: {
                            Machine.MEMORY_COPY(stack, instance, operands);
                            break;
                        }
                        case TABLE_COPY: {
                            Machine.TABLE_COPY(stack, instance, operands);
                            break;
                        }
                        case TABLE_FILL: {
                            Machine.TABLE_FILL(stack, instance, operands);
                            break;
                        }
                        case TABLE_SIZE: {
                            Machine.TABLE_SIZE(stack, instance, operands);
                            break;
                        }
                        case TABLE_GROW: {
                            Machine.TABLE_GROW(stack, instance, operands);
                            break;
                        }
                        case REF_FUNC: {
                            stack.push(Value.funcRef((long)operands[0]));
                            break;
                        }
                        case REF_NULL: {
                            Machine.REF_NULL(stack, operands);
                            break;
                        }
                        case REF_IS_NULL: {
                            Machine.REF_IS_NULL(stack);
                            break;
                        }
                        case ELEM_DROP: {
                            Machine.ELEM_DROP(instance, operands);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Machine doesn't recognize Instruction " + instruction);
                        }
                    }
                }
            }
            catch (ChicoryException e) {
                throw e;
            }
            catch (ArithmeticException e) {
                if (e.getMessage().equalsIgnoreCase("/ by zero") || e.getMessage().contains("divide by zero")) {
                    throw new WASMRuntimeException("integer divide by zero: " + e.getMessage(), e);
                }
                throw new WASMRuntimeException(e.getMessage(), e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WASMRuntimeException("undefined element " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new WASMRuntimeException("An underlying Java exception occurred", e);
            }
        }
    }

    private static void I32_GE_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Integer.compareUnsigned(a, b) >= 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I64_GT_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Long.compareUnsigned(a, b) > 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I32_GE_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(a >= b ? Value.TRUE : Value.FALSE);
    }

    private static void I64_GE_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Long.compareUnsigned(a, b) >= 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I64_GE_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(a >= b ? Value.TRUE : Value.FALSE);
    }

    private static void I32_LE_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(a <= b ? Value.TRUE : Value.FALSE);
    }

    private static void I32_LE_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Integer.compareUnsigned(a, b) <= 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I64_LE_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(a <= b ? Value.TRUE : Value.FALSE);
    }

    private static void I64_LE_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Long.compareUnsigned(a, b) <= 0 ? Value.TRUE : Value.FALSE);
    }

    private static void F32_EQ(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a == (b = stack.pop().asFloat()) ? Value.TRUE : Value.FALSE);
    }

    private static void F64_EQ(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a == (b = stack.pop().asDouble()) ? Value.TRUE : Value.FALSE);
    }

    private static void I32_CLZ(MStack stack) {
        int tos = stack.pop().asInt();
        int count = Integer.numberOfLeadingZeros(tos);
        stack.push(Value.i32((long)count));
    }

    private static void I32_CTZ(MStack stack) {
        int tos = stack.pop().asInt();
        int count = Integer.numberOfTrailingZeros(tos);
        stack.push(Value.i32((long)count));
    }

    private static void I32_POPCNT(MStack stack) {
        int tos = stack.pop().asInt();
        int count = Integer.bitCount(tos);
        stack.push(Value.i32((long)count));
    }

    private static void I32_ADD(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(a + b)));
    }

    private static void I64_ADD(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a + b)));
    }

    private static void I32_SUB(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(b - a)));
    }

    private static void I64_SUB(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(b - a)));
    }

    private static void I32_MUL(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(a * b)));
    }

    private static void I64_MUL(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a * b)));
    }

    private static void I32_DIV_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        if (a == Integer.MIN_VALUE && b == -1) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i32((long)(a / b)));
    }

    private static void I32_DIV_U(MStack stack) {
        long b = stack.pop().asUInt();
        long a = stack.pop().asUInt();
        stack.push(Value.i32((long)(a / b)));
    }

    private static void I64_EXTEND_8_S(MStack stack) {
        byte tos = stack.pop().asByte();
        stack.push(Value.i64((long)tos));
    }

    private static void I64_EXTEND_16_S(MStack stack) {
        short tos = stack.pop().asShort();
        stack.push(Value.i64((long)tos));
    }

    private static void I64_EXTEND_32_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i64((long)tos));
    }

    private static void F64_CONVERT_I64_U(MStack stack) {
        double d;
        long tos = stack.pop().asLong();
        if (tos >= 0L) {
            d = tos;
        } else {
            long sum = tos + 1023L;
            long shiftIn = ((sum ^ tos) & Long.MIN_VALUE) >>> 10;
            d = Math.scalb((double)(sum >>> 11 | shiftIn), 11);
        }
        stack.push(Value.f64((long)Double.doubleToLongBits(d)));
    }

    private static void F64_CONVERT_I32_U(MStack stack) {
        long tos = stack.pop().asUInt();
        stack.push(Value.f64((long)Double.doubleToLongBits(tos)));
    }

    private static void F64_CONVERT_I32_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromDouble((double)tos));
    }

    private static void I32_EXTEND_8_S(MStack stack) {
        byte tos = stack.pop().asByte();
        stack.push(Value.i32((long)tos));
    }

    private static void F64_NEAREST(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.rint(val)));
    }

    private static void F32_NEAREST(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)((float)Math.rint(val))));
    }

    private static void F64_TRUNC(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(val < 0.0 ? Math.ceil(val) : Math.floor(val))));
    }

    private static void F64_CEIL(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.ceil(val)));
    }

    private static void F32_CEIL(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)((float)Math.ceil(val))));
    }

    private static void F64_FLOOR(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.floor(val)));
    }

    private static void F32_FLOOR(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)((float)Math.floor(val))));
    }

    private static void F64_SQRT(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.sqrt(val)));
    }

    private static void F32_SQRT(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)((float)Math.sqrt(val))));
    }

    private static void F64_MAX(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.max(a, b)));
    }

    private static void F32_MAX(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)Math.max(a, b)));
    }

    private static void F64_MIN(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.min(a, b)));
    }

    private static void F32_MIN(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)Math.min(a, b)));
    }

    private static void F64_DIV(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b / a)));
    }

    private static void F32_DIV(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b / a)));
    }

    private static void F64_MUL(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b * a)));
    }

    private static void F32_MUL(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b * a)));
    }

    private static void F64_SUB(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b - a)));
    }

    private static void F32_SUB(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b - a)));
    }

    private static void F64_ADD(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(a + b)));
    }

    private static void F32_ADD(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(a + b)));
    }

    private static void I32_ROTR(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        int z = v >>> c | v << 32 - c;
        stack.push(Value.i32((long)z));
    }

    private static void I32_ROTL(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        int z = v << c | v >>> 32 - c;
        stack.push(Value.i32((long)z));
    }

    private static void I32_SHR_U(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((long)(v >>> c)));
    }

    private static void I32_SHR_S(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((long)(v >> c)));
    }

    private static void I32_SHL(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((long)(v << c)));
    }

    private static void I32_XOR(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(a ^ b)));
    }

    private static void I32_OR(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(a | b)));
    }

    private static void I32_AND(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((long)(a & b)));
    }

    private static void I64_POPCNT(MStack stack) {
        long tos = stack.pop().asLong();
        int count = Long.bitCount(tos);
        stack.push(Value.i64((long)count));
    }

    private static void I64_CTZ(MStack stack) {
        Value tos = stack.pop();
        int count = Long.numberOfTrailingZeros(tos.asLong());
        stack.push(Value.i64((long)count));
    }

    private static void I64_CLZ(MStack stack) {
        Value tos = stack.pop();
        int count = Long.numberOfLeadingZeros(tos.asLong());
        stack.push(Value.i64((long)count));
    }

    private static void I64_ROTR(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        long z = v >>> (int)c | v << (int)(64L - c);
        stack.push(Value.i64((long)z));
    }

    private static void I64_ROTL(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        long z = v << (int)c | v >>> (int)(64L - c);
        stack.push(Value.i64((long)z));
    }

    private static void I64_REM_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)Long.remainderUnsigned(a, b)));
    }

    private static void I64_REM_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)(a % b)));
    }

    private static void I64_SHR_U(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v >>> (int)c)));
    }

    private static void I64_SHR_S(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v >> (int)c)));
    }

    private static void I64_SHL(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v << (int)c)));
    }

    private static void I64_XOR(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a ^ b)));
    }

    private static void I64_OR(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a | b)));
    }

    private static void I64_AND(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a & b)));
    }

    private static void I32_REM_U(MStack stack) {
        long b = stack.pop().asUInt();
        long a = stack.pop().asUInt();
        stack.push(Value.i32((long)(a % b)));
    }

    private static void I32_REM_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((long)(a % b)));
    }

    private static void I64_DIV_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)Long.divideUnsigned(a, b)));
    }

    private static void I64_DIV_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        if (a == Long.MIN_VALUE && b == -1L) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i64((long)(a / b)));
    }

    private static void I64_GT_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(a > b ? Value.TRUE : Value.FALSE);
    }

    private static void I32_GT_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Integer.compareUnsigned(a, b) > 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I32_GT_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(a > b ? Value.TRUE : Value.FALSE);
    }

    private static void I64_LT_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Long.compareUnsigned(a, b) < 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I64_LT_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(a < b ? Value.TRUE : Value.FALSE);
    }

    private static void I32_LT_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Integer.compareUnsigned(a, b) < 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I32_LT_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(a < b ? Value.TRUE : Value.FALSE);
    }

    private static void I64_EQZ(MStack stack) {
        long a = stack.pop().asLong();
        stack.push(a == 0L ? Value.TRUE : Value.FALSE);
    }

    private static void I32_EQZ(MStack stack) {
        int a = stack.pop().asInt();
        stack.push(a == 0 ? Value.TRUE : Value.FALSE);
    }

    private static void I64_NE(MStack stack) {
        long b;
        long a = stack.pop().asLong();
        stack.push(a == (b = stack.pop().asLong()) ? Value.FALSE : Value.TRUE);
    }

    private static void I32_NE(MStack stack) {
        int b;
        int a = stack.pop().asInt();
        stack.push(a == (b = stack.pop().asInt()) ? Value.FALSE : Value.TRUE);
    }

    private static void I64_EQ(MStack stack) {
        long b;
        long a = stack.pop().asLong();
        stack.push(a == (b = stack.pop().asLong()) ? Value.TRUE : Value.FALSE);
    }

    private static void I32_EQ(MStack stack) {
        int b;
        int a = stack.pop().asInt();
        stack.push(a == (b = stack.pop().asInt()) ? Value.TRUE : Value.FALSE);
    }

    private static void MEMORY_SIZE(MStack stack, Instance instance) {
        int sz = instance.memory().pages();
        stack.push(Value.i32((long)sz));
    }

    private static void I64_STORE32(MStack stack, Instance instance, long[] operands) {
        long value = stack.pop().asLong();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeI32(ptr, (int)value);
    }

    private static void I64_STORE8(MStack stack, Instance instance, long[] operands) {
        byte value = stack.pop().asByte();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeByte(ptr, value);
    }

    private static void F64_PROMOTE_F32(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.fromDouble((double)tos.asFloat()));
    }

    private static void F64_REINTERPRET_I64(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.f64((long)tos.asLong()));
    }

    private static void I32_WRAP_I64(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i32((long)tos.asInt()));
    }

    private static void I64_EXTEND_I32_S(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)tos.asInt()));
    }

    private static void I64_EXTEND_I32_U(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)tos.asUInt()));
    }

    private static void I32_REINTERPRET_F32(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i32((long)tos.asInt()));
    }

    private static void I64_REINTERPRET_F64(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)tos.asLong()));
    }

    private static void F32_REINTERPRET_I32(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.f32((long)tos.asInt()));
    }

    private static void F32_DEMOTE_F64(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromFloat((float)((float)val)));
    }

    private static void F32_CONVERT_I32_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromFloat((float)tos));
    }

    private static void I32_EXTEND_16_S(MStack stack) {
        int original = stack.pop().asInt() & 0xFFFF;
        if ((original & 0x8000) != 0) {
            original |= 0xFFFF0000;
        }
        stack.push(Value.i32((long)((long)original & 0xFFFFFFFFL)));
    }

    private static void I64_TRUNC_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        long tosL = (long)tos;
        if (tos == -9.223372036854776E18) {
            tosL = Long.MIN_VALUE;
        } else if (tosL == Long.MIN_VALUE || tosL == Long.MAX_VALUE) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i64((long)tosL));
    }

    private static void F32_COPYSIGN(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        if (a == 4.290773E9f) {
            stack.push(Value.fromFloat((float)Math.copySign(b, -1.0f)));
        } else if (a == 2.1432893E9f) {
            stack.push(Value.fromFloat((float)Math.copySign(b, 1.0f)));
        } else {
            stack.push(Value.fromFloat((float)Math.copySign(b, a)));
        }
    }

    private static void F32_ABS(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)Math.abs(val)));
    }

    private static void F64_ABS(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)Math.abs(val)));
    }

    private static void F32_NE(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a == (b = stack.pop().asFloat()) ? Value.FALSE : Value.TRUE);
    }

    private static void F64_NE(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a == (b = stack.pop().asDouble()) ? Value.FALSE : Value.TRUE);
    }

    private static void F32_LT(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a > (b = stack.pop().asFloat()) ? Value.TRUE : Value.FALSE);
    }

    private static void F64_LT(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a > (b = stack.pop().asDouble()) ? Value.TRUE : Value.FALSE);
    }

    private static void F32_LE(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a >= (b = stack.pop().asFloat()) ? Value.TRUE : Value.FALSE);
    }

    private static void F64_LE(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a >= (b = stack.pop().asDouble()) ? Value.TRUE : Value.FALSE);
    }

    private static void F32_GE(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a <= (b = stack.pop().asFloat()) ? Value.TRUE : Value.FALSE);
    }

    private static void F64_GE(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a <= (b = stack.pop().asDouble()) ? Value.TRUE : Value.FALSE);
    }

    private static void F32_GT(MStack stack) {
        float b;
        float a = stack.pop().asFloat();
        stack.push(a < (b = stack.pop().asFloat()) ? Value.TRUE : Value.FALSE);
    }

    private static void F64_GT(MStack stack) {
        double b;
        double a = stack.pop().asDouble();
        stack.push(a < (b = stack.pop().asDouble()) ? Value.TRUE : Value.FALSE);
    }

    private static void F32_CONVERT_I32_U(MStack stack) {
        long tos = stack.pop().asUInt();
        stack.push(Value.fromFloat((float)tos));
    }

    private static void F32_CONVERT_I64_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromFloat((float)tos));
    }

    private static void REF_NULL(MStack stack, long[] operands) {
        ValueType type = ValueType.byId((long)operands[0]);
        stack.push(new Value(type, -1L));
    }

    private static void ELEM_DROP(Instance instance, long[] operands) {
        int x = (int)operands[0];
        instance.setElement(x, null);
    }

    private static void REF_IS_NULL(MStack stack) {
        Value val = stack.pop();
        stack.push(val.equals((Object)Value.EXTREF_NULL) || val.equals((Object)Value.FUNCREF_NULL) ? Value.TRUE : Value.FALSE);
    }

    private static void DATA_DROP(Instance instance, long[] operands) {
        int segment = (int)operands[0];
        instance.memory().drop(segment);
    }

    private static void F64_CONVERT_I64_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromDouble((double)tos));
    }

    private static void TABLE_GROW(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        Table table = instance.table(tableidx);
        if (table == null) {
            table = instance.imports().table(tableidx).table();
        }
        int size = stack.pop().asInt();
        Value valValue = stack.pop();
        int val = valValue.asExtRef();
        int res = table.grow(size, val);
        stack.push(Value.i32((long)res));
    }

    private static void TABLE_SIZE(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        Table table = instance.table(tableidx);
        if (table == null) {
            table = instance.imports().table(tableidx).table();
        }
        stack.push(Value.i32((long)table.size()));
    }

    private static void TABLE_FILL(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        int size = stack.pop().asInt();
        int val = stack.pop().asExtRef();
        int offset = stack.pop().asInt();
        int end = offset + size;
        Table table = instance.table(tableidx);
        if (table == null) {
            table = instance.imports().table(tableidx).table();
        }
        if (size < 0 || end > table.size()) {
            throw new WASMRuntimeException("out of bounds table access");
        }
        for (int i = offset; i < end; ++i) {
            table.setRef(i, val);
        }
    }

    private static void TABLE_COPY(MStack stack, Instance instance, long[] operands) {
        int tableidxSrc = (int)operands[1];
        int tableidxDst = (int)operands[0];
        int size = stack.pop().asInt();
        int s = stack.pop().asInt();
        int d = stack.pop().asInt();
        Table src = instance.table(tableidxSrc);
        Table dest = instance.table(tableidxDst);
        if (size < 0 || s < 0 || size + s > src.size() || d < 0 || size + d > dest.size()) {
            throw new WASMRuntimeException("out of bounds table access");
        }
        for (int i = size - 1; i >= 0; --i) {
            Value val;
            if (d <= s) {
                val = src.ref(s++);
                dest.setRef(d++, val.asFuncRef());
                continue;
            }
            val = src.ref(s + i);
            dest.setRef(d + i, val.asFuncRef());
        }
    }

    private static void MEMORY_COPY(MStack stack, Instance instance, long[] operands) {
        int memidxSrc = (int)operands[0];
        int memidxDst = (int)operands[1];
        if (memidxDst != 0 && memidxSrc != 0) {
            throw new WASMRuntimeException("We don't support non zero index for memory: " + memidxSrc + " " + memidxDst);
        }
        int size = stack.pop().asInt();
        int offset = stack.pop().asInt();
        int destination = stack.pop().asInt();
        instance.memory().copy(destination, offset, size);
    }

    private static void TABLE_INIT(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[1];
        int elementidx = (int)operands[0];
        int size = stack.pop().asInt();
        int elemidx = stack.pop().asInt();
        int offset = stack.pop().asInt();
        int end = offset + size;
        Table table = instance.table(tableidx);
        if (table == null) {
            table = instance.imports().table(tableidx).table();
        }
        if (size < 0 || elementidx > instance.elementCount() || instance.element(elementidx) == null || elemidx + size > instance.element(elementidx).size() || end > table.size()) {
            throw new WASMRuntimeException("out of bounds table access");
        }
        for (int i = offset; i < end; ++i) {
            int val;
            if ((val = Machine.getRuntimeElementValue(instance, elementidx, elemidx++)) > instance.functionCount()) {
                throw new WASMRuntimeException("out of bounds table access");
            }
            table.setRef(i, val);
        }
    }

    private static void MEMORY_INIT(MStack stack, Instance instance, long[] operands) {
        int segmentId = (int)operands[0];
        int memidx = (int)operands[1];
        if (memidx != 0) {
            throw new WASMRuntimeException("We don't support non zero index for memory: " + memidx);
        }
        int size = stack.pop().asInt();
        int offset = stack.pop().asInt();
        int destination = stack.pop().asInt();
        instance.memory().initPassiveSegment(segmentId, destination, offset, size);
    }

    private static void I64_TRUNC_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        if (tos < -9.223372E18f || tos >= 9.223372E18f) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i64((long)((long)tos)));
    }

    private static void I32_TRUNC_F64_U(MStack stack) {
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        long tosL = (long)tos;
        if (tosL < 0L || tosL > 0xFFFFFFFFL) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i32((long)(tosL & 0xFFFFFFFFL)));
    }

    private static void I32_TRUNC_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        long tosL = (long)tos;
        if (tosL < Integer.MIN_VALUE || tosL > Integer.MAX_VALUE) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i32((long)tosL));
    }

    private static void I64_TRUNC_SAT_F64_U(MStack stack) {
        long tosL;
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos) || tos < 0.0) {
            tosL = 0L;
        } else if (tos > Math.pow(2.0, 64.0) - 1.0) {
            tosL = -1L;
        } else if (tos < 9.223372036854776E18) {
            tosL = (long)tos;
        } else {
            tosL = Long.MAX_VALUE + (long)(tos - 9.223372036854776E18) + 1L;
            if (tosL >= 0L) {
                throw new WASMRuntimeException("integer overflow");
            }
        }
        stack.push(Value.i64((long)tosL));
    }

    private static void I64_TRUNC_SAT_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            tos = 0.0;
        } else if (tos <= -9.223372036854776E18) {
            tos = -9.223372036854776E18;
        } else if (tos >= 9.223372036854776E18) {
            tos = 9.223372036854776E18;
        }
        stack.push(Value.i64((long)((long)tos)));
    }

    private static void I64_TRUNC_SAT_F32_U(MStack stack) {
        long tosL;
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos) || tos < 0.0f) {
            tosL = 0L;
        } else if ((double)tos > Math.pow(2.0, 64.0) - 1.0) {
            tosL = -1L;
        } else if (tos < 9.223372E18f) {
            tosL = (long)tos;
        } else {
            tosL = Long.MAX_VALUE + (long)((double)tos - 9.223372036854776E18) + 1L;
            if (tosL >= 0L) {
                throw new WASMRuntimeException("integer overflow");
            }
        }
        stack.push(Value.i64((long)tosL));
    }

    private static void I64_TRUNC_SAT_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            tos = 0.0f;
        } else if (tos <= -9.223372E18f) {
            tos = -9.223372E18f;
        } else if (tos >= 9.223372E18f) {
            tos = 9.223372E18f;
        }
        stack.push(Value.i64((long)((long)tos)));
    }

    private static void I64_TRUNC_F64_U(MStack stack) {
        long tosL;
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        if (tos >= 1.8446744073709552E19) {
            throw new WASMRuntimeException("integer overflow");
        }
        if (tos < 9.223372036854776E18 ? (tosL = (long)tos) < 0L : (tosL = Long.MAX_VALUE + (long)(tos - 9.223372036854776E18) + 1L) >= 0L) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i64((long)tosL));
    }

    private static void I64_TRUNC_F32_U(MStack stack) {
        long tosL;
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        if (tos >= 1.8446744E19f) {
            throw new WASMRuntimeException("integer overflow");
        }
        if (tos < 9.223372E18f ? (tosL = (long)tos) < 0L : (tosL = Long.MAX_VALUE + (long)(tos - 9.223372E18f) + 1L) >= 0L) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i64((long)tosL));
    }

    private static void F32_CONVERT_I64_U(MStack stack) {
        float f;
        long tos = stack.pop().asLong();
        if (tos >= 0L) {
            f = tos;
        } else {
            long sum = tos + 0xFFFFFFFFFFL;
            long shiftIn = ((sum ^ tos) & Long.MIN_VALUE) >>> 39;
            f = Math.scalb(sum >>> 40 | shiftIn, 40);
        }
        stack.push(Value.f32((long)Float.floatToIntBits(f)));
    }

    private static void I32_TRUNC_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        long tosL = (long)tos;
        if (tosL < 0L || tosL >= 0xFFFFFFFFL) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i32((long)tosL));
    }

    private static void I32_TRUNC_SAT_F64_U(MStack stack) {
        double tos = Double.longBitsToDouble(stack.pop().asLong());
        long tosL = Double.isNaN(tos) || tos < 0.0 ? 0L : (tos > 4.294967295E9 ? 0xFFFFFFFFL : (long)tos);
        stack.push(Value.i32((long)tosL));
    }

    private static void I32_TRUNC_SAY_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        if (Double.isNaN(tos)) {
            tos = 0.0;
        } else if (tos <= -2.147483648E9) {
            tos = -2.147483648E9;
        } else if (tos >= 2.147483647E9) {
            tos = 2.147483647E9;
        }
        stack.push(Value.i32((long)((int)tos)));
    }

    private static void I32_TRUNC_SAT_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        long tosL = Float.isNaN(tos) || tos < 0.0f ? 0L : (tos >= 4.2949673E9f ? 0xFFFFFFFFL : (long)tos);
        stack.push(Value.i32((long)tosL));
    }

    private static void I32_TRUNC_SAT_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            tos = 0.0f;
        } else if (tos < -2.1474836E9f) {
            tos = -2.1474836E9f;
        } else if (tos > 2.1474836E9f) {
            tos = 2.1474836E9f;
        }
        stack.push(Value.i32((long)((int)tos)));
    }

    private static void I32_TRUNC_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        if (Float.isNaN(tos)) {
            throw new WASMRuntimeException("invalid conversion to integer");
        }
        if (tos < -2.1474836E9f || tos >= 2.1474836E9f) {
            throw new WASMRuntimeException("integer overflow");
        }
        stack.push(Value.i32((long)((long)tos)));
    }

    private static void F64_COPYSIGN(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        if (a == -1.8014398509481984E16) {
            stack.push(Value.fromDouble((double)Math.copySign(b, -1.0)));
        } else if (a == 9.205357638345294E18) {
            stack.push(Value.fromDouble((double)Math.copySign(b, 1.0)));
        } else {
            stack.push(Value.fromDouble((double)Math.copySign(b, a)));
        }
    }

    private static void F32_TRUNC(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)((float)(val < 0.0f ? Math.ceil(val) : Math.floor(val)))));
    }

    private static void CALL(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, long[] operands) {
        int funcId = (int)operands[0];
        int typeId = instance.functionType(funcId);
        FunctionType type = instance.type(typeId);
        Value[] args = Machine.extractArgsForParams(stack, type.params());
        Machine.call(stack, instance, callStack, funcId, args, type, false);
    }

    private static void F64_NEG(MStack stack) {
        double tos = stack.pop().asDouble();
        double result = Double.isNaN(tos) ? Double.longBitsToDouble(Double.doubleToRawLongBits(tos) ^ Long.MIN_VALUE) : -1.0 * tos;
        stack.push(Value.fromDouble((double)result));
    }

    private static void F32_NEG(MStack stack) {
        float tos = stack.pop().asFloat();
        float result = Float.isNaN(tos) ? Float.intBitsToFloat(Float.floatToRawIntBits(tos) ^ Integer.MIN_VALUE) : -1.0f * tos;
        stack.push(Value.fromFloat((float)result));
    }

    private static void MEMORY_FILL(MStack stack, Instance instance, long[] operands) {
        int memidx = (int)operands[0];
        if (memidx != 0) {
            throw new WASMRuntimeException("We don't support multiple memories just yet");
        }
        int size = stack.pop().asInt();
        byte val = stack.pop().asByte();
        int offset = stack.pop().asInt();
        int end = size + offset;
        instance.memory().fill(val, offset, end);
    }

    private static void MEMORY_GROW(MStack stack, Instance instance) {
        int size = stack.pop().asInt();
        int nPages = instance.memory().grow(size);
        stack.push(Value.i32((long)nPages));
    }

    private static void F64_STORE(MStack stack, Instance instance, long[] operands) {
        double value = stack.pop().asDouble();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeF64(ptr, value);
    }

    private static void F32_STORE(MStack stack, Instance instance, long[] operands) {
        float value = stack.pop().asFloat();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeF32(ptr, value);
    }

    private static void I64_STORE(MStack stack, Instance instance, long[] operands) {
        long value = stack.pop().asLong();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeLong(ptr, value);
    }

    private static void I64_STORE16(MStack stack, Instance instance, long[] operands) {
        short value = stack.pop().asShort();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeShort(ptr, value);
    }

    private static void I32_STORE(MStack stack, Instance instance, long[] operands) {
        int value = stack.pop().asInt();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeI32(ptr, value);
    }

    private static void I64_LOAD32_U(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readU32(ptr);
        stack.push(val);
    }

    private static void I64_LOAD32_S(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI32(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I64_LOAD16_U(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readU16(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD16_U(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readU16(ptr);
        stack.push(val);
    }

    private static void I64_LOAD16_S(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI16(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD16_S(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI16(ptr);
        stack.push(val);
    }

    private static void I64_LOAD8_U(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readU8(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD8_U(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readU8(ptr);
        stack.push(val);
    }

    private static void I64_LOAD8_S(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI8(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD8_S(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI8(ptr);
        stack.push(val);
    }

    private static void F64_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readF64(ptr);
        stack.push(val);
    }

    private static void F32_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readF32(ptr);
        stack.push(val);
    }

    private static void I64_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI64(ptr);
        stack.push(val);
    }

    private static void I32_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        Value val = instance.memory().readI32(ptr);
        stack.push(val);
    }

    private static void TABLE_SET(MStack stack, Instance instance, long[] operands) {
        int idx = (int)operands[0];
        Table table = instance.table(idx);
        if (table == null) {
            table = instance.imports().table(idx).table();
        }
        int value = stack.pop().asExtRef();
        int i = stack.pop().asInt();
        table.setRef(i, value);
    }

    private static void TABLE_GET(MStack stack, Instance instance, long[] operands) {
        int i;
        int idx = (int)operands[0];
        Table table = instance.table(idx);
        if (table == null) {
            table = instance.imports().table(idx).table();
        }
        if ((i = stack.pop().asInt()) < 0 || (long)i >= table.limits().max() || i >= table.size()) {
            throw new WASMRuntimeException("out of bounds table access");
        }
        stack.push(table.ref(i));
    }

    private static void GLOBAL_SET(MStack stack, Instance instance, long[] operands) {
        Global mutabilityType;
        int id = (int)operands[0];
        Object object = mutabilityType = instance.globalInitializer(id) == null ? instance.imports().global(id).mutabilityType() : instance.globalInitializer(id);
        if (mutabilityType == MutabilityType.Const) {
            throw new RuntimeException("Can't call GLOBAL_SET on immutable global");
        }
        Value val = stack.pop();
        instance.writeGlobal(id, val);
    }

    private static void GLOBAL_GET(MStack stack, Instance instance, long[] operands) {
        int idx = (int)operands[0];
        Value val = instance.readGlobal(idx);
        if (val == null) {
            val = instance.imports().global(idx).value();
        }
        stack.push(val);
    }

    private static void SELECT(MStack stack) {
        int pred = stack.pop().asInt();
        Value b = stack.pop();
        Value a = stack.pop();
        if (pred == 0) {
            stack.push(b);
        } else {
            stack.push(a);
        }
    }

    private static void CALL_INDIRECT(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, long[] operands) {
        int tableIdx = (int)operands[1];
        Table table = instance.table(tableIdx);
        if (table == null) {
            table = instance.imports().table(tableIdx).table();
        }
        int typeId = (int)operands[0];
        FunctionType type = instance.type(typeId);
        int funcTableIdx = stack.pop().asInt();
        int funcId = table.ref(funcTableIdx).asFuncRef();
        if (funcId == -1) {
            throw new ChicoryException("uninitialized element " + funcTableIdx);
        }
        Value[] args = Machine.extractArgsForParams(stack, type.params());
        Machine.call(stack, instance, callStack, funcId, args, type, false);
    }

    private static void BLOCK(StackFrame frame, MStack stack) {
        frame.isControlFrame = true;
        frame.registerStackSize(stack);
    }

    private static int numberOfValuesToReturn(Instance instance, Instruction scope) {
        if (scope.opcode() == OpCode.END) {
            return 0;
        }
        int typeId = (int)scope.operands()[0];
        if (typeId == 64) {
            return 0;
        }
        if (ValueType.byId((long)typeId) != null) {
            return 1;
        }
        return instance.type(typeId).returns().length;
    }

    private static void IF(StackFrame frame, MStack stack, Instruction instruction) {
        frame.isControlFrame = false;
        frame.registerStackSize(stack);
        Value predValue = stack.pop();
        frame.jumpTo(predValue.asInt() == 0 ? instruction.labelFalse() : instruction.labelTrue());
    }

    private static void BR_TABLE(StackFrame frame, MStack stack, Instruction instruction) {
        Value predValue = Machine.prepareControlTransfer(frame, stack, true);
        int pred = predValue.asInt();
        if (pred < 0 || pred >= instruction.labelTable().length - 1) {
            frame.jumpTo(instruction.labelTable()[instruction.labelTable().length - 1]);
        } else {
            frame.jumpTo(instruction.labelTable()[pred]);
        }
    }

    private static void BR_IF(StackFrame frame, MStack stack, Instruction instruction) {
        Value predValue = Machine.prepareControlTransfer(frame, stack, true);
        int pred = predValue.asInt();
        if (pred == 0) {
            frame.jumpTo(instruction.labelFalse());
        } else {
            frame.jumpTo(instruction.labelTrue());
        }
    }

    private static Value prepareControlTransfer(StackFrame frame, MStack stack, boolean consume) {
        frame.doControlTransfer = true;
        ArrayDeque<Value> unwindStack = stack.unwindFrame();
        stack.resetUnwindFrame();
        Value predValue = null;
        if (consume) {
            predValue = stack.pop();
        }
        if (unwindStack == null) {
            stack.setUnwindFrame(new ArrayDeque<Value>());
        } else {
            stack.setUnwindFrame(unwindStack);
        }
        return predValue;
    }

    private static void doControlTransfer(Instance instance, MStack stack, StackFrame frame, Instruction scope) {
        int i;
        frame.doControlTransfer = false;
        ArrayDeque<Value> unwindStack = stack.unwindFrame();
        stack.resetUnwindFrame();
        Value[] returns = new Value[Machine.numberOfValuesToReturn(instance, scope)];
        for (i = 0; i < returns.length; ++i) {
            if (stack.size() <= 0) continue;
            returns[i] = stack.pop();
        }
        frame.dropValuesOutOfBlock(stack);
        if (frame.isLastBlock()) {
            while (!unwindStack.isEmpty()) {
                stack.push(unwindStack.pop());
            }
        }
        for (i = 0; i < returns.length; ++i) {
            Value value = returns[returns.length - 1 - i];
            if (value == null) continue;
            stack.push(value);
        }
    }

    private static int getRuntimeElementValue(Instance instance, int idx, int s) {
        int val;
        Element elem = instance.element(idx);
        Element.ElemType type = elem.elemType();
        switch (type) {
            case Type: {
                ElemType t = (ElemType)elem;
                val = Module.computeConstantValue(t.exprInstructions());
                break;
            }
            case Elem: {
                ElemElem e = (ElemElem)elem;
                Instruction[] expr = e.exprs()[s];
                val = Module.computeConstantValue(expr);
                break;
            }
            case Func: {
                ElemFunc f = (ElemFunc)elem;
                val = (int)f.funcIndices()[s];
                break;
            }
            default: {
                throw new WASMRuntimeException("Element Type not recognized " + type);
            }
        }
        return val;
    }

    List<StackFrame> getStackTrace() {
        return List.copyOf(this.callStack);
    }

    static Value[] extractArgsForParams(MStack stack, ValueType[] params) {
        if (params == null) {
            return Value.EMPTY_VALUES;
        }
        Value[] args = new Value[params.length];
        for (int i = params.length; i > 0; --i) {
            Value p = stack.pop();
            ValueType t = params[i - 1];
            if (p.type() != t) {
                throw new RuntimeException("Type error when extracting args.");
            }
            args[i - 1] = p;
        }
        return args;
    }

    protected static void verifyIndirectCall(FunctionType actual, FunctionType expected) throws ChicoryException {
        if (!actual.typesMatch(expected)) {
            throw new ChicoryException("indirect call type mismatch");
        }
    }
}

