/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.OpcodeImpl;
import com.dylibso.chicory.runtime.StackFrame;
import com.dylibso.chicory.runtime.TableInstance;
import com.dylibso.chicory.runtime.TrapException;
import com.dylibso.chicory.runtime.exceptions.WASMRuntimeException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayDeque;
import java.util.List;

class InterpreterMachine
implements Machine {
    private final MStack stack;
    private final ArrayDeque<StackFrame> callStack;
    private final Instance instance;

    public InterpreterMachine(Instance instance) {
        this.instance = instance;
        this.stack = new MStack();
        this.callStack = new ArrayDeque();
    }

    @Override
    public Value[] call(int funcId, Value[] args) throws ChicoryException {
        return InterpreterMachine.call(this.stack, this.instance, this.callStack, funcId, args, null, true);
    }

    public static Value[] call(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, int funcId, Value[] args, FunctionType callType, boolean popResults) throws ChicoryException {
        FunctionBody func;
        InterpreterMachine.checkInterruption();
        int typeId = instance.functionType(funcId);
        FunctionType type = instance.type(typeId);
        if (callType != null) {
            InterpreterMachine.verifyIndirectCall(type, callType);
        }
        if ((func = instance.function(funcId)) != null) {
            callStack.push(new StackFrame(func.instructions(), instance, funcId, args, func.localTypes()));
            InterpreterMachine.eval(stack, instance, callStack);
        } else {
            callStack.push(new StackFrame(instance, funcId, args, List.of()));
            Value[] results = instance.callHostFunction(funcId, args);
            if (results != null) {
                for (Value result : results) {
                    stack.push(result);
                }
            }
        }
        if (!callStack.isEmpty()) {
            callStack.pop();
        }
        if (!popResults) {
            return null;
        }
        if (type.returns().isEmpty()) {
            return null;
        }
        if (stack.size() == 0) {
            return null;
        }
        int totalResults = type.returns().size();
        Value[] results = new Value[totalResults];
        for (int i = totalResults - 1; i >= 0; --i) {
            results[i] = stack.pop();
        }
        return results;
    }

    static void eval(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack) throws ChicoryException {
        block209: {
            try {
                StackFrame frame = callStack.peek();
                boolean shouldReturn = false;
                block205: while (!frame.terminated()) {
                    if (shouldReturn) {
                        return;
                    }
                    Instruction instruction = frame.loadCurrentInstruction();
                    OpCode opcode = instruction.opcode();
                    long[] operands = instruction.operands();
                    instance.onExecution(instruction, operands, stack);
                    switch (opcode) {
                        case UNREACHABLE: {
                            throw new TrapException("Trapped on unreachable instruction", callStack);
                        }
                        case NOP: {
                            break;
                        }
                        case LOOP: 
                        case BLOCK: {
                            InterpreterMachine.BLOCK(frame, stack);
                            break;
                        }
                        case IF: {
                            InterpreterMachine.IF(frame, stack, instruction);
                            break;
                        }
                        case BR: {
                            InterpreterMachine.checkInterruption();
                        }
                        case ELSE: {
                            InterpreterMachine.prepareControlTransfer(frame, stack, false);
                            frame.jumpTo(instruction.labelTrue());
                            break;
                        }
                        case BR_IF: {
                            InterpreterMachine.BR_IF(frame, stack, instruction);
                            break;
                        }
                        case BR_TABLE: {
                            InterpreterMachine.BR_TABLE(frame, stack, instruction);
                            break;
                        }
                        case RETURN: {
                            shouldReturn = true;
                            break;
                        }
                        case CALL_INDIRECT: {
                            InterpreterMachine.CALL_INDIRECT(stack, instance, callStack, operands);
                            break;
                        }
                        case DROP: {
                            stack.pop();
                            break;
                        }
                        case SELECT: {
                            InterpreterMachine.SELECT(stack);
                            break;
                        }
                        case SELECT_T: {
                            InterpreterMachine.SELECT_T(stack, operands);
                            break;
                        }
                        case END: {
                            if (frame.doControlTransfer && frame.isControlFrame) {
                                InterpreterMachine.doControlTransfer(instance, stack, frame, instruction.scope());
                            } else {
                                frame.endOfNonControlBlock();
                            }
                            if (!frame.isLastBlock()) continue block205;
                            break block209;
                        }
                        case LOCAL_GET: {
                            stack.push(frame.local((int)operands[0]));
                            break;
                        }
                        case LOCAL_SET: {
                            frame.setLocal((int)operands[0], stack.pop());
                            break;
                        }
                        case LOCAL_TEE: {
                            frame.setLocal((int)operands[0], stack.peek());
                            break;
                        }
                        case GLOBAL_GET: {
                            InterpreterMachine.GLOBAL_GET(stack, instance, operands);
                            break;
                        }
                        case GLOBAL_SET: {
                            InterpreterMachine.GLOBAL_SET(stack, instance, operands);
                            break;
                        }
                        case TABLE_GET: {
                            InterpreterMachine.TABLE_GET(stack, instance, operands);
                            break;
                        }
                        case TABLE_SET: {
                            InterpreterMachine.TABLE_SET(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD: {
                            InterpreterMachine.I32_LOAD(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD: {
                            InterpreterMachine.I64_LOAD(stack, instance, operands);
                            break;
                        }
                        case F32_LOAD: {
                            InterpreterMachine.F32_LOAD(stack, instance, operands);
                            break;
                        }
                        case F64_LOAD: {
                            InterpreterMachine.F64_LOAD(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD8_S: {
                            InterpreterMachine.I32_LOAD8_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD8_S: {
                            InterpreterMachine.I64_LOAD8_S(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD8_U: {
                            InterpreterMachine.I32_LOAD8_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD8_U: {
                            InterpreterMachine.I64_LOAD8_U(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD16_S: {
                            InterpreterMachine.I32_LOAD16_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD16_S: {
                            InterpreterMachine.I64_LOAD16_S(stack, instance, operands);
                            break;
                        }
                        case I32_LOAD16_U: {
                            InterpreterMachine.I32_LOAD16_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD16_U: {
                            InterpreterMachine.I64_LOAD16_U(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD32_S: {
                            InterpreterMachine.I64_LOAD32_S(stack, instance, operands);
                            break;
                        }
                        case I64_LOAD32_U: {
                            InterpreterMachine.I64_LOAD32_U(stack, instance, operands);
                            break;
                        }
                        case I32_STORE: {
                            InterpreterMachine.I32_STORE(stack, instance, operands);
                            break;
                        }
                        case I32_STORE16: 
                        case I64_STORE16: {
                            InterpreterMachine.I64_STORE16(stack, instance, operands);
                            break;
                        }
                        case I64_STORE: {
                            InterpreterMachine.I64_STORE(stack, instance, operands);
                            break;
                        }
                        case F32_STORE: {
                            InterpreterMachine.F32_STORE(stack, instance, operands);
                            break;
                        }
                        case F64_STORE: {
                            InterpreterMachine.F64_STORE(stack, instance, operands);
                            break;
                        }
                        case MEMORY_GROW: {
                            InterpreterMachine.MEMORY_GROW(stack, instance);
                            break;
                        }
                        case MEMORY_FILL: {
                            InterpreterMachine.MEMORY_FILL(stack, instance, operands);
                            break;
                        }
                        case I32_STORE8: 
                        case I64_STORE8: {
                            InterpreterMachine.I64_STORE8(stack, instance, operands);
                            break;
                        }
                        case I64_STORE32: {
                            InterpreterMachine.I64_STORE32(stack, instance, operands);
                            break;
                        }
                        case MEMORY_SIZE: {
                            InterpreterMachine.MEMORY_SIZE(stack, instance);
                            break;
                        }
                        case I32_CONST: {
                            stack.push(Value.i32((long)operands[0]));
                            break;
                        }
                        case I64_CONST: {
                            stack.push(Value.i64((long)operands[0]));
                            break;
                        }
                        case F32_CONST: {
                            stack.push(Value.f32((long)operands[0]));
                            break;
                        }
                        case F64_CONST: {
                            stack.push(Value.f64((long)operands[0]));
                            break;
                        }
                        case I32_EQ: {
                            InterpreterMachine.I32_EQ(stack);
                            break;
                        }
                        case I64_EQ: {
                            InterpreterMachine.I64_EQ(stack);
                            break;
                        }
                        case I32_NE: {
                            InterpreterMachine.I32_NE(stack);
                            break;
                        }
                        case I64_NE: {
                            InterpreterMachine.I64_NE(stack);
                            break;
                        }
                        case I32_EQZ: {
                            InterpreterMachine.I32_EQZ(stack);
                            break;
                        }
                        case I64_EQZ: {
                            InterpreterMachine.I64_EQZ(stack);
                            break;
                        }
                        case I32_LT_S: {
                            InterpreterMachine.I32_LT_S(stack);
                            break;
                        }
                        case I32_LT_U: {
                            InterpreterMachine.I32_LT_U(stack);
                            break;
                        }
                        case I64_LT_S: {
                            InterpreterMachine.I64_LT_S(stack);
                            break;
                        }
                        case I64_LT_U: {
                            InterpreterMachine.I64_LT_U(stack);
                            break;
                        }
                        case I32_GT_S: {
                            InterpreterMachine.I32_GT_S(stack);
                            break;
                        }
                        case I32_GT_U: {
                            InterpreterMachine.I32_GT_U(stack);
                            break;
                        }
                        case I64_GT_S: {
                            InterpreterMachine.I64_GT_S(stack);
                            break;
                        }
                        case I64_GT_U: {
                            InterpreterMachine.I64_GT_U(stack);
                            break;
                        }
                        case I32_GE_S: {
                            InterpreterMachine.I32_GE_S(stack);
                            break;
                        }
                        case I32_GE_U: {
                            InterpreterMachine.I32_GE_U(stack);
                            break;
                        }
                        case I64_GE_U: {
                            InterpreterMachine.I64_GE_U(stack);
                            break;
                        }
                        case I64_GE_S: {
                            InterpreterMachine.I64_GE_S(stack);
                            break;
                        }
                        case I32_LE_S: {
                            InterpreterMachine.I32_LE_S(stack);
                            break;
                        }
                        case I32_LE_U: {
                            InterpreterMachine.I32_LE_U(stack);
                            break;
                        }
                        case I64_LE_S: {
                            InterpreterMachine.I64_LE_S(stack);
                            break;
                        }
                        case I64_LE_U: {
                            InterpreterMachine.I64_LE_U(stack);
                            break;
                        }
                        case F32_EQ: {
                            InterpreterMachine.F32_EQ(stack);
                            break;
                        }
                        case F64_EQ: {
                            InterpreterMachine.F64_EQ(stack);
                            break;
                        }
                        case I32_CLZ: {
                            InterpreterMachine.I32_CLZ(stack);
                            break;
                        }
                        case I32_CTZ: {
                            InterpreterMachine.I32_CTZ(stack);
                            break;
                        }
                        case I32_POPCNT: {
                            InterpreterMachine.I32_POPCNT(stack);
                            break;
                        }
                        case I32_ADD: {
                            InterpreterMachine.I32_ADD(stack);
                            break;
                        }
                        case I64_ADD: {
                            InterpreterMachine.I64_ADD(stack);
                            break;
                        }
                        case I32_SUB: {
                            InterpreterMachine.I32_SUB(stack);
                            break;
                        }
                        case I64_SUB: {
                            InterpreterMachine.I64_SUB(stack);
                            break;
                        }
                        case I32_MUL: {
                            InterpreterMachine.I32_MUL(stack);
                            break;
                        }
                        case I64_MUL: {
                            InterpreterMachine.I64_MUL(stack);
                            break;
                        }
                        case I32_DIV_S: {
                            InterpreterMachine.I32_DIV_S(stack);
                            break;
                        }
                        case I32_DIV_U: {
                            InterpreterMachine.I32_DIV_U(stack);
                            break;
                        }
                        case I64_DIV_S: {
                            InterpreterMachine.I64_DIV_S(stack);
                            break;
                        }
                        case I64_DIV_U: {
                            InterpreterMachine.I64_DIV_U(stack);
                            break;
                        }
                        case I32_REM_S: {
                            InterpreterMachine.I32_REM_S(stack);
                            break;
                        }
                        case I32_REM_U: {
                            InterpreterMachine.I32_REM_U(stack);
                            break;
                        }
                        case I64_AND: {
                            InterpreterMachine.I64_AND(stack);
                            break;
                        }
                        case I64_OR: {
                            InterpreterMachine.I64_OR(stack);
                            break;
                        }
                        case I64_XOR: {
                            InterpreterMachine.I64_XOR(stack);
                            break;
                        }
                        case I64_SHL: {
                            InterpreterMachine.I64_SHL(stack);
                            break;
                        }
                        case I64_SHR_S: {
                            InterpreterMachine.I64_SHR_S(stack);
                            break;
                        }
                        case I64_SHR_U: {
                            InterpreterMachine.I64_SHR_U(stack);
                            break;
                        }
                        case I64_REM_S: {
                            InterpreterMachine.I64_REM_S(stack);
                            break;
                        }
                        case I64_REM_U: {
                            InterpreterMachine.I64_REM_U(stack);
                            break;
                        }
                        case I64_ROTL: {
                            InterpreterMachine.I64_ROTL(stack);
                            break;
                        }
                        case I64_ROTR: {
                            InterpreterMachine.I64_ROTR(stack);
                            break;
                        }
                        case I64_CLZ: {
                            InterpreterMachine.I64_CLZ(stack);
                            break;
                        }
                        case I64_CTZ: {
                            InterpreterMachine.I64_CTZ(stack);
                            break;
                        }
                        case I64_POPCNT: {
                            InterpreterMachine.I64_POPCNT(stack);
                            break;
                        }
                        case F32_NEG: {
                            InterpreterMachine.F32_NEG(stack);
                            break;
                        }
                        case F64_NEG: {
                            InterpreterMachine.F64_NEG(stack);
                            break;
                        }
                        case CALL: {
                            InterpreterMachine.CALL(stack, instance, callStack, operands);
                            break;
                        }
                        case I32_AND: {
                            InterpreterMachine.I32_AND(stack);
                            break;
                        }
                        case I32_OR: {
                            InterpreterMachine.I32_OR(stack);
                            break;
                        }
                        case I32_XOR: {
                            InterpreterMachine.I32_XOR(stack);
                            break;
                        }
                        case I32_SHL: {
                            InterpreterMachine.I32_SHL(stack);
                            break;
                        }
                        case I32_SHR_S: {
                            InterpreterMachine.I32_SHR_S(stack);
                            break;
                        }
                        case I32_SHR_U: {
                            InterpreterMachine.I32_SHR_U(stack);
                            break;
                        }
                        case I32_ROTL: {
                            InterpreterMachine.I32_ROTL(stack);
                            break;
                        }
                        case I32_ROTR: {
                            InterpreterMachine.I32_ROTR(stack);
                            break;
                        }
                        case F32_ADD: {
                            InterpreterMachine.F32_ADD(stack);
                            break;
                        }
                        case F64_ADD: {
                            InterpreterMachine.F64_ADD(stack);
                            break;
                        }
                        case F32_SUB: {
                            InterpreterMachine.F32_SUB(stack);
                            break;
                        }
                        case F64_SUB: {
                            InterpreterMachine.F64_SUB(stack);
                            break;
                        }
                        case F32_MUL: {
                            InterpreterMachine.F32_MUL(stack);
                            break;
                        }
                        case F64_MUL: {
                            InterpreterMachine.F64_MUL(stack);
                            break;
                        }
                        case F32_DIV: {
                            InterpreterMachine.F32_DIV(stack);
                            break;
                        }
                        case F64_DIV: {
                            InterpreterMachine.F64_DIV(stack);
                            break;
                        }
                        case F32_MIN: {
                            InterpreterMachine.F32_MIN(stack);
                            break;
                        }
                        case F64_MIN: {
                            InterpreterMachine.F64_MIN(stack);
                            break;
                        }
                        case F32_MAX: {
                            InterpreterMachine.F32_MAX(stack);
                            break;
                        }
                        case F64_MAX: {
                            InterpreterMachine.F64_MAX(stack);
                            break;
                        }
                        case F32_SQRT: {
                            InterpreterMachine.F32_SQRT(stack);
                            break;
                        }
                        case F64_SQRT: {
                            InterpreterMachine.F64_SQRT(stack);
                            break;
                        }
                        case F32_FLOOR: {
                            InterpreterMachine.F32_FLOOR(stack);
                            break;
                        }
                        case F64_FLOOR: {
                            InterpreterMachine.F64_FLOOR(stack);
                            break;
                        }
                        case F32_CEIL: {
                            InterpreterMachine.F32_CEIL(stack);
                            break;
                        }
                        case F64_CEIL: {
                            InterpreterMachine.F64_CEIL(stack);
                            break;
                        }
                        case F32_TRUNC: {
                            InterpreterMachine.F32_TRUNC(stack);
                            break;
                        }
                        case F64_TRUNC: {
                            InterpreterMachine.F64_TRUNC(stack);
                            break;
                        }
                        case F32_NEAREST: {
                            InterpreterMachine.F32_NEAREST(stack);
                            break;
                        }
                        case F64_NEAREST: {
                            InterpreterMachine.F64_NEAREST(stack);
                            break;
                        }
                        case I32_EXTEND_8_S: {
                            InterpreterMachine.I32_EXTEND_8_S(stack);
                            break;
                        }
                        case I32_EXTEND_16_S: {
                            InterpreterMachine.I32_EXTEND_16_S(stack);
                            break;
                        }
                        case I64_EXTEND_8_S: {
                            InterpreterMachine.I64_EXTEND_8_S(stack);
                            break;
                        }
                        case I64_EXTEND_16_S: {
                            InterpreterMachine.I64_EXTEND_16_S(stack);
                            break;
                        }
                        case I64_EXTEND_32_S: {
                            InterpreterMachine.I64_EXTEND_32_S(stack);
                            break;
                        }
                        case F64_CONVERT_I64_U: {
                            InterpreterMachine.F64_CONVERT_I64_U(stack);
                            break;
                        }
                        case F64_CONVERT_I32_U: {
                            InterpreterMachine.F64_CONVERT_I32_U(stack);
                            break;
                        }
                        case F64_CONVERT_I32_S: {
                            InterpreterMachine.F64_CONVERT_I32_S(stack);
                            break;
                        }
                        case F64_PROMOTE_F32: {
                            InterpreterMachine.F64_PROMOTE_F32(stack);
                            break;
                        }
                        case F64_REINTERPRET_I64: {
                            InterpreterMachine.F64_REINTERPRET_I64(stack);
                            break;
                        }
                        case I64_TRUNC_F64_S: {
                            InterpreterMachine.I64_TRUNC_F64_S(stack);
                            break;
                        }
                        case I32_WRAP_I64: {
                            InterpreterMachine.I32_WRAP_I64(stack);
                            break;
                        }
                        case I64_EXTEND_I32_S: {
                            InterpreterMachine.I64_EXTEND_I32_S(stack);
                            break;
                        }
                        case I64_EXTEND_I32_U: {
                            InterpreterMachine.I64_EXTEND_I32_U(stack);
                            break;
                        }
                        case I32_REINTERPRET_F32: {
                            InterpreterMachine.I32_REINTERPRET_F32(stack);
                            break;
                        }
                        case I64_REINTERPRET_F64: {
                            InterpreterMachine.I64_REINTERPRET_F64(stack);
                            break;
                        }
                        case F32_REINTERPRET_I32: {
                            InterpreterMachine.F32_REINTERPRET_I32(stack);
                            break;
                        }
                        case F32_COPYSIGN: {
                            InterpreterMachine.F32_COPYSIGN(stack);
                            break;
                        }
                        case F32_ABS: {
                            InterpreterMachine.F32_ABS(stack);
                            break;
                        }
                        case F64_COPYSIGN: {
                            InterpreterMachine.F64_COPYSIGN(stack);
                            break;
                        }
                        case F64_ABS: {
                            InterpreterMachine.F64_ABS(stack);
                            break;
                        }
                        case F32_NE: {
                            InterpreterMachine.F32_NE(stack);
                            break;
                        }
                        case F64_NE: {
                            InterpreterMachine.F64_NE(stack);
                            break;
                        }
                        case F32_LT: {
                            InterpreterMachine.F32_LT(stack);
                            break;
                        }
                        case F64_LT: {
                            InterpreterMachine.F64_LT(stack);
                            break;
                        }
                        case F32_LE: {
                            InterpreterMachine.F32_LE(stack);
                            break;
                        }
                        case F64_LE: {
                            InterpreterMachine.F64_LE(stack);
                            break;
                        }
                        case F32_GE: {
                            InterpreterMachine.F32_GE(stack);
                            break;
                        }
                        case F64_GE: {
                            InterpreterMachine.F64_GE(stack);
                            break;
                        }
                        case F32_GT: {
                            InterpreterMachine.F32_GT(stack);
                            break;
                        }
                        case F64_GT: {
                            InterpreterMachine.F64_GT(stack);
                            break;
                        }
                        case F32_DEMOTE_F64: {
                            InterpreterMachine.F32_DEMOTE_F64(stack);
                            break;
                        }
                        case F32_CONVERT_I32_S: {
                            InterpreterMachine.F32_CONVERT_I32_S(stack);
                            break;
                        }
                        case I32_TRUNC_F32_S: {
                            InterpreterMachine.I32_TRUNC_F32_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F32_S: {
                            InterpreterMachine.I32_TRUNC_SAT_F32_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F32_U: {
                            InterpreterMachine.I32_TRUNC_SAT_F32_U(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F64_S: {
                            InterpreterMachine.I32_TRUNC_SAT_F64_S(stack);
                            break;
                        }
                        case I32_TRUNC_SAT_F64_U: {
                            InterpreterMachine.I32_TRUNC_SAT_F64_U(stack);
                            break;
                        }
                        case F32_CONVERT_I32_U: {
                            InterpreterMachine.F32_CONVERT_I32_U(stack);
                            break;
                        }
                        case I32_TRUNC_F32_U: {
                            InterpreterMachine.I32_TRUNC_F32_U(stack);
                            break;
                        }
                        case F32_CONVERT_I64_S: {
                            InterpreterMachine.F32_CONVERT_I64_S(stack);
                            break;
                        }
                        case F32_CONVERT_I64_U: {
                            InterpreterMachine.F32_CONVERT_I64_U(stack);
                            break;
                        }
                        case F64_CONVERT_I64_S: {
                            InterpreterMachine.F64_CONVERT_I64_S(stack);
                            break;
                        }
                        case I64_TRUNC_F32_U: {
                            InterpreterMachine.I64_TRUNC_F32_U(stack);
                            break;
                        }
                        case I64_TRUNC_F64_U: {
                            InterpreterMachine.I64_TRUNC_F64_U(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F32_S: {
                            InterpreterMachine.I64_TRUNC_SAT_F32_S(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F32_U: {
                            InterpreterMachine.I64_TRUNC_SAT_F32_U(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F64_S: {
                            InterpreterMachine.I64_TRUNC_SAT_F64_S(stack);
                            break;
                        }
                        case I64_TRUNC_SAT_F64_U: {
                            InterpreterMachine.I64_TRUNC_SAT_F64_U(stack);
                            break;
                        }
                        case I32_TRUNC_F64_S: {
                            InterpreterMachine.I32_TRUNC_F64_S(stack);
                            break;
                        }
                        case I32_TRUNC_F64_U: {
                            InterpreterMachine.I32_TRUNC_F64_U(stack);
                            break;
                        }
                        case I64_TRUNC_F32_S: {
                            InterpreterMachine.I64_TRUNC_F32_S(stack);
                            break;
                        }
                        case MEMORY_INIT: {
                            InterpreterMachine.MEMORY_INIT(stack, instance, operands);
                            break;
                        }
                        case TABLE_INIT: {
                            InterpreterMachine.TABLE_INIT(stack, instance, operands);
                            break;
                        }
                        case DATA_DROP: {
                            InterpreterMachine.DATA_DROP(instance, operands);
                            break;
                        }
                        case MEMORY_COPY: {
                            InterpreterMachine.MEMORY_COPY(stack, instance, operands);
                            break;
                        }
                        case TABLE_COPY: {
                            InterpreterMachine.TABLE_COPY(stack, instance, operands);
                            break;
                        }
                        case TABLE_FILL: {
                            InterpreterMachine.TABLE_FILL(stack, instance, operands);
                            break;
                        }
                        case TABLE_SIZE: {
                            InterpreterMachine.TABLE_SIZE(stack, instance, operands);
                            break;
                        }
                        case TABLE_GROW: {
                            InterpreterMachine.TABLE_GROW(stack, instance, operands);
                            break;
                        }
                        case REF_FUNC: {
                            stack.push(Value.funcRef((int)((int)operands[0])));
                            break;
                        }
                        case REF_NULL: {
                            InterpreterMachine.REF_NULL(stack, operands);
                            break;
                        }
                        case REF_IS_NULL: {
                            InterpreterMachine.REF_IS_NULL(stack);
                            break;
                        }
                        case ELEM_DROP: {
                            InterpreterMachine.ELEM_DROP(instance, operands);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Machine doesn't recognize Instruction " + instruction);
                        }
                    }
                }
            }
            catch (ChicoryException e) {
                throw e;
            }
            catch (StackOverflowError e) {
                throw new ChicoryException("call stack exhausted", (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WASMRuntimeException("undefined element " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new WASMRuntimeException("An underlying Java exception occurred", e);
            }
        }
    }

    private static void I32_GE_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_GE_U(a, b)));
    }

    private static void I64_GT_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_GT_U(a, b)));
    }

    private static void I32_GE_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_GE_S(a, b)));
    }

    private static void I64_GE_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_GE_U(a, b)));
    }

    private static void I64_GE_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_GE_S(a, b)));
    }

    private static void I32_LE_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_LE_S(a, b)));
    }

    private static void I32_LE_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_LE_U(a, b)));
    }

    private static void I64_LE_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_LE_S(a, b)));
    }

    private static void I64_LE_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_LE_U(a, b)));
    }

    private static void F32_EQ(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_EQ(a, b)));
    }

    private static void F64_EQ(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_EQ(a, b)));
    }

    private static void I32_CLZ(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_CLZ(tos)));
    }

    private static void I32_CTZ(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_CTZ(tos)));
    }

    private static void I32_POPCNT(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_POPCNT(tos)));
    }

    private static void I32_ADD(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(a + b)));
    }

    private static void I64_ADD(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a + b)));
    }

    private static void I32_SUB(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(b - a)));
    }

    private static void I64_SUB(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(b - a)));
    }

    private static void I32_MUL(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(a * b)));
    }

    private static void I64_MUL(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a * b)));
    }

    private static void I32_DIV_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_DIV_S(a, b)));
    }

    private static void I32_DIV_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_DIV_U(a, b)));
    }

    private static void I64_EXTEND_8_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_EXTEND_8_S(tos)));
    }

    private static void I64_EXTEND_16_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_EXTEND_16_S(tos)));
    }

    private static void I64_EXTEND_32_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_EXTEND_32_S(tos)));
    }

    private static void F64_CONVERT_I64_U(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_CONVERT_I64_U(tos)));
    }

    private static void F64_CONVERT_I32_U(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_CONVERT_I32_U(tos)));
    }

    private static void F64_CONVERT_I32_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_CONVERT_I32_S(tos)));
    }

    private static void I32_EXTEND_8_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_EXTEND_8_S(tos)));
    }

    private static void F64_NEAREST(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_NEAREST(val)));
    }

    private static void F32_NEAREST(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_NEAREST(val)));
    }

    private static void F64_TRUNC(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_TRUNC(val)));
    }

    private static void F64_CEIL(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_CEIL(val)));
    }

    private static void F32_CEIL(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_CEIL(val)));
    }

    private static void F64_FLOOR(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_FLOOR(val)));
    }

    private static void F32_FLOOR(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_FLOOR(val)));
    }

    private static void F64_SQRT(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_SQRT(val)));
    }

    private static void F32_SQRT(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_SQRT(val)));
    }

    private static void F64_MAX(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_MAX(a, b)));
    }

    private static void F32_MAX(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_MAX(a, b)));
    }

    private static void F64_MIN(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_MIN(a, b)));
    }

    private static void F32_MIN(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_MIN(a, b)));
    }

    private static void F64_DIV(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b / a)));
    }

    private static void F32_DIV(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b / a)));
    }

    private static void F64_MUL(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b * a)));
    }

    private static void F32_MUL(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b * a)));
    }

    private static void F64_SUB(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(b - a)));
    }

    private static void F32_SUB(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(b - a)));
    }

    private static void F64_ADD(MStack stack) {
        double a = stack.pop().asDouble();
        double b = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(a + b)));
    }

    private static void F32_ADD(MStack stack) {
        float a = stack.pop().asFloat();
        float b = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(a + b)));
    }

    private static void I32_ROTR(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_ROTR(v, c)));
    }

    private static void I32_ROTL(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_ROTL(v, c)));
    }

    private static void I32_SHR_U(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((int)(v >>> c)));
    }

    private static void I32_SHR_S(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((int)(v >> c)));
    }

    private static void I32_SHL(MStack stack) {
        int c = stack.pop().asInt();
        int v = stack.pop().asInt();
        stack.push(Value.i32((int)(v << c)));
    }

    private static void I32_XOR(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(a ^ b)));
    }

    private static void I32_OR(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(a | b)));
    }

    private static void I32_AND(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)(a & b)));
    }

    private static void I64_POPCNT(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_POPCNT(tos)));
    }

    private static void I64_CTZ(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)OpcodeImpl.I64_CTZ(tos.asLong())));
    }

    private static void I64_CLZ(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)OpcodeImpl.I64_CLZ(tos.asLong())));
    }

    private static void I64_ROTR(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_ROTR(v, c)));
    }

    private static void I64_ROTL(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_ROTL(v, c)));
    }

    private static void I64_REM_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_REM_U(a, b)));
    }

    private static void I64_REM_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_REM_S(a, b)));
    }

    private static void I64_SHR_U(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v >>> (int)c)));
    }

    private static void I64_SHR_S(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v >> (int)c)));
    }

    private static void I64_SHL(MStack stack) {
        long c = stack.pop().asLong();
        long v = stack.pop().asLong();
        stack.push(Value.i64((long)(v << (int)c)));
    }

    private static void I64_XOR(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a ^ b)));
    }

    private static void I64_OR(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a | b)));
    }

    private static void I64_AND(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i64((long)(a & b)));
    }

    private static void I32_REM_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_REM_U(a, b)));
    }

    private static void I32_REM_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_REM_S(a, b)));
    }

    private static void I64_DIV_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_DIV_U(a, b)));
    }

    private static void I64_DIV_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i64((long)OpcodeImpl.I64_DIV_S(a, b)));
    }

    private static void I64_GT_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_GT_S(a, b)));
    }

    private static void I32_GT_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_GT_U(a, b)));
    }

    private static void I32_GT_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_GT_S(a, b)));
    }

    private static void I64_LT_U(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_LT_U(a, b)));
    }

    private static void I64_LT_S(MStack stack) {
        long b = stack.pop().asLong();
        long a = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_LT_S(a, b)));
    }

    private static void I32_LT_U(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_LT_U(a, b)));
    }

    private static void I32_LT_S(MStack stack) {
        int b = stack.pop().asInt();
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_LT_S(a, b)));
    }

    private static void I64_EQZ(MStack stack) {
        long a = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_EQZ(a)));
    }

    private static void I32_EQZ(MStack stack) {
        int a = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_EQZ(a)));
    }

    private static void I64_NE(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_NE(a, b)));
    }

    private static void I32_NE(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_NE(a, b)));
    }

    private static void I64_EQ(MStack stack) {
        long a = stack.pop().asLong();
        long b = stack.pop().asLong();
        stack.push(Value.i32((int)OpcodeImpl.I64_EQ(a, b)));
    }

    private static void I32_EQ(MStack stack) {
        int a = stack.pop().asInt();
        int b = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_EQ(a, b)));
    }

    private static void MEMORY_SIZE(MStack stack, Instance instance) {
        int sz = instance.memory().pages();
        stack.push(Value.i32((int)sz));
    }

    private static void I64_STORE32(MStack stack, Instance instance, long[] operands) {
        long value = stack.pop().asLong();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeI32(ptr, (int)value);
    }

    private static void I64_STORE8(MStack stack, Instance instance, long[] operands) {
        byte value = stack.pop().asByte();
        int ptr = (int)(operands[1] + (long)stack.pop().asInt());
        instance.memory().writeByte(ptr, value);
    }

    private static void F64_PROMOTE_F32(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.fromDouble((double)tos.asFloat()));
    }

    private static void F64_REINTERPRET_I64(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_REINTERPRET_I64(tos)));
    }

    private static void I32_WRAP_I64(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i32((int)tos.asInt()));
    }

    private static void I64_EXTEND_I32_S(MStack stack) {
        Value tos = stack.pop();
        stack.push(Value.i64((long)tos.asInt()));
    }

    private static void I64_EXTEND_I32_U(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i64((long)OpcodeImpl.I64_EXTEND_I32_U(tos)));
    }

    private static void I32_REINTERPRET_F32(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.I32_REINTERPRET_F32(tos)));
    }

    private static void I64_REINTERPRET_F64(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i64((long)OpcodeImpl.I64_REINTERPRET_F64(tos)));
    }

    private static void F32_REINTERPRET_I32(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_REINTERPRET_I32(tos)));
    }

    private static void F32_DEMOTE_F64(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromFloat((float)((float)val)));
    }

    private static void F32_CONVERT_I32_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_CONVERT_I32_S(tos)));
    }

    private static void I32_EXTEND_16_S(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.i32((int)OpcodeImpl.I32_EXTEND_16_S(tos)));
    }

    private static void I64_TRUNC_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_F64_S(tos)));
    }

    private static void F32_COPYSIGN(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_COPYSIGN(a, b)));
    }

    private static void F32_ABS(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_ABS(val)));
    }

    private static void F64_ABS(MStack stack) {
        double val = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_ABS(val)));
    }

    private static void F32_NE(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_NE(a, b)));
    }

    private static void F64_NE(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_NE(a, b)));
    }

    private static void F32_LT(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_LT(a, b)));
    }

    private static void F64_LT(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_LT(a, b)));
    }

    private static void F32_LE(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_LE(a, b)));
    }

    private static void F64_LE(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_LE(a, b)));
    }

    private static void F32_GE(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_GE(a, b)));
    }

    private static void F64_GE(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_GE(a, b)));
    }

    private static void F32_GT(MStack stack) {
        float b = stack.pop().asFloat();
        float a = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.F32_GT(a, b)));
    }

    private static void F64_GT(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.F64_GT(a, b)));
    }

    private static void F32_CONVERT_I32_U(MStack stack) {
        int tos = stack.pop().asInt();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_CONVERT_I32_U(tos)));
    }

    private static void F32_CONVERT_I64_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_CONVERT_I64_S(tos)));
    }

    private static void REF_NULL(MStack stack, long[] operands) {
        ValueType type = ValueType.forId((int)((int)operands[0]));
        stack.push(new Value(type, -1L));
    }

    private static void ELEM_DROP(Instance instance, long[] operands) {
        int x = (int)operands[0];
        instance.setElement(x, null);
    }

    private static void REF_IS_NULL(MStack stack) {
        Value val = stack.pop();
        stack.push(val.equals((Object)Value.EXTREF_NULL) || val.equals((Object)Value.FUNCREF_NULL) ? Value.TRUE : Value.FALSE);
    }

    private static void DATA_DROP(Instance instance, long[] operands) {
        int segment = (int)operands[0];
        instance.memory().drop(segment);
    }

    private static void F64_CONVERT_I64_S(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_CONVERT_I64_S(tos)));
    }

    private static void TABLE_GROW(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        TableInstance table = instance.table(tableidx);
        int size = stack.pop().asInt();
        Value valValue = stack.pop();
        int val = valValue.asExtRef();
        int res = table.grow(size, val, instance);
        stack.push(Value.i32((int)res));
    }

    private static void TABLE_SIZE(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        TableInstance table = instance.table(tableidx);
        stack.push(Value.i32((int)table.size()));
    }

    private static void TABLE_FILL(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[0];
        int size = stack.pop().asInt();
        int val = stack.pop().asExtRef();
        int offset = stack.pop().asInt();
        OpcodeImpl.TABLE_FILL(instance, tableidx, size, val, offset);
    }

    private static void TABLE_COPY(MStack stack, Instance instance, long[] operands) {
        int tableidxSrc = (int)operands[1];
        int tableidxDst = (int)operands[0];
        int size = stack.pop().asInt();
        int s = stack.pop().asInt();
        int d = stack.pop().asInt();
        OpcodeImpl.TABLE_COPY(instance, tableidxSrc, tableidxDst, size, s, d);
    }

    private static void MEMORY_COPY(MStack stack, Instance instance, long[] operands) {
        int memidxSrc = (int)operands[0];
        int memidxDst = (int)operands[1];
        if (memidxDst != 0 && memidxSrc != 0) {
            throw new WASMRuntimeException("We don't support non zero index for memory: " + memidxSrc + " " + memidxDst);
        }
        int size = stack.pop().asInt();
        int offset = stack.pop().asInt();
        int destination = stack.pop().asInt();
        instance.memory().copy(destination, offset, size);
    }

    private static void TABLE_INIT(MStack stack, Instance instance, long[] operands) {
        int tableidx = (int)operands[1];
        int elementidx = (int)operands[0];
        int size = stack.pop().asInt();
        int elemidx = stack.pop().asInt();
        int offset = stack.pop().asInt();
        OpcodeImpl.TABLE_INIT(instance, tableidx, elementidx, size, elemidx, offset);
    }

    private static void MEMORY_INIT(MStack stack, Instance instance, long[] operands) {
        int segmentId = (int)operands[0];
        int memidx = (int)operands[1];
        if (memidx != 0) {
            throw new WASMRuntimeException("We don't support non zero index for memory: " + memidx);
        }
        int size = stack.pop().asInt();
        int offset = stack.pop().asInt();
        int destination = stack.pop().asInt();
        instance.memory().initPassiveSegment(segmentId, destination, offset, size);
    }

    private static void I64_TRUNC_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_F32_S(tos)));
    }

    private static void I32_TRUNC_F64_U(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_F64_U(tos)));
    }

    private static void I32_TRUNC_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_F64_S(tos)));
    }

    private static void I64_TRUNC_SAT_F64_U(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_SAT_F64_U(tos)));
    }

    private static void I64_TRUNC_SAT_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_SAT_F64_S(tos)));
    }

    private static void I64_TRUNC_SAT_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_SAT_F32_U(tos)));
    }

    private static void I64_TRUNC_SAT_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_SAT_F32_S(tos)));
    }

    private static void I64_TRUNC_F64_U(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_F64_U(tos)));
    }

    private static void I64_TRUNC_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i64((long)OpcodeImpl.I64_TRUNC_F32_U(tos)));
    }

    private static void F32_CONVERT_I64_U(MStack stack) {
        long tos = stack.pop().asLong();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_CONVERT_I64_U(tos)));
    }

    private static void I32_TRUNC_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_F32_U(tos)));
    }

    private static void I32_TRUNC_SAT_F64_U(MStack stack) {
        double tos = Double.longBitsToDouble(stack.pop().asLong());
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_SAT_F64_U(tos)));
    }

    private static void I32_TRUNC_SAT_F64_S(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_SAT_F64_S(tos)));
    }

    private static void I32_TRUNC_SAT_F32_U(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_SAT_F32_U(tos)));
    }

    private static void I32_TRUNC_SAT_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_SAT_F32_S(tos)));
    }

    private static void I32_TRUNC_F32_S(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.i32((int)OpcodeImpl.I32_TRUNC_F32_S(tos)));
    }

    private static void F64_COPYSIGN(MStack stack) {
        double b = stack.pop().asDouble();
        double a = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)OpcodeImpl.F64_COPYSIGN(a, b)));
    }

    private static void F32_TRUNC(MStack stack) {
        float val = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)OpcodeImpl.F32_TRUNC(val)));
    }

    private static void CALL(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, long[] operands) {
        int funcId = (int)operands[0];
        int typeId = instance.functionType(funcId);
        FunctionType type = instance.type(typeId);
        Value[] args = InterpreterMachine.extractArgsForParams(stack, type.params());
        InterpreterMachine.call(stack, instance, callStack, funcId, args, type, false);
    }

    private static void F64_NEG(MStack stack) {
        double tos = stack.pop().asDouble();
        stack.push(Value.fromDouble((double)(-tos)));
    }

    private static void F32_NEG(MStack stack) {
        float tos = stack.pop().asFloat();
        stack.push(Value.fromFloat((float)(-tos)));
    }

    private static void MEMORY_FILL(MStack stack, Instance instance, long[] operands) {
        int memidx = (int)operands[0];
        if (memidx != 0) {
            throw new WASMRuntimeException("We don't support multiple memories just yet");
        }
        int size = stack.pop().asInt();
        byte val = stack.pop().asByte();
        int offset = stack.pop().asInt();
        int end = size + offset;
        instance.memory().fill(val, offset, end);
    }

    private static void MEMORY_GROW(MStack stack, Instance instance) {
        int size = stack.pop().asInt();
        int nPages = instance.memory().grow(size);
        stack.push(Value.i32((int)nPages));
    }

    private static int readMemPtr(MStack stack, long[] operands) {
        int offset = stack.pop().asInt();
        if (operands[1] < 0L || operands[1] >= Integer.MAX_VALUE || offset < 0) {
            throw new WASMRuntimeException("out of bounds memory access");
        }
        return (int)(operands[1] + (long)offset);
    }

    private static void F64_STORE(MStack stack, Instance instance, long[] operands) {
        double value = stack.pop().asDouble();
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        instance.memory().writeF64(ptr, value);
    }

    private static void F32_STORE(MStack stack, Instance instance, long[] operands) {
        float value = stack.pop().asFloat();
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        instance.memory().writeF32(ptr, value);
    }

    private static void I64_STORE(MStack stack, Instance instance, long[] operands) {
        long value = stack.pop().asLong();
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        instance.memory().writeLong(ptr, value);
    }

    private static void I64_STORE16(MStack stack, Instance instance, long[] operands) {
        short value = stack.pop().asShort();
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        instance.memory().writeShort(ptr, value);
    }

    private static void I32_STORE(MStack stack, Instance instance, long[] operands) {
        int value = stack.pop().asInt();
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        instance.memory().writeI32(ptr, value);
    }

    private static void I64_LOAD32_U(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readU32(ptr);
        stack.push(val);
    }

    private static void I64_LOAD32_S(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI32(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I64_LOAD16_U(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readU16(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD16_U(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readU16(ptr);
        stack.push(val);
    }

    private static void I64_LOAD16_S(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI16(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD16_S(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI16(ptr);
        stack.push(val);
    }

    private static void I64_LOAD8_U(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readU8(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD8_U(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readU8(ptr);
        stack.push(val);
    }

    private static void I64_LOAD8_S(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI8(ptr);
        stack.push(Value.i64((long)val.asInt()));
    }

    private static void I32_LOAD8_S(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI8(ptr);
        stack.push(val);
    }

    private static void F64_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readF64(ptr);
        stack.push(val);
    }

    private static void F32_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readF32(ptr);
        stack.push(val);
    }

    private static void I64_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI64(ptr);
        stack.push(val);
    }

    private static void I32_LOAD(MStack stack, Instance instance, long[] operands) {
        int ptr = InterpreterMachine.readMemPtr(stack, operands);
        Value val = instance.memory().readI32(ptr);
        stack.push(val);
    }

    private static void TABLE_SET(MStack stack, Instance instance, long[] operands) {
        int idx = (int)operands[0];
        TableInstance table = instance.table(idx);
        int value = stack.pop().asExtRef();
        int i = stack.pop().asInt();
        table.setRef(i, value, instance);
    }

    private static void TABLE_GET(MStack stack, Instance instance, long[] operands) {
        int idx = (int)operands[0];
        int i = stack.pop().asInt();
        stack.push(OpcodeImpl.TABLE_GET(instance, idx, i));
    }

    private static void GLOBAL_SET(MStack stack, Instance instance, long[] operands) {
        int id = (int)operands[0];
        Value val = stack.pop();
        instance.writeGlobal(id, val);
    }

    private static void GLOBAL_GET(MStack stack, Instance instance, long[] operands) {
        int idx = (int)operands[0];
        Value val = instance.readGlobal(idx);
        stack.push(val);
    }

    private static void SELECT(MStack stack) {
        int pred = stack.pop().asInt();
        Value b = stack.pop();
        Value a = stack.pop();
        if (pred == 0) {
            stack.push(b);
        } else {
            stack.push(a);
        }
    }

    private static void SELECT_T(MStack stack, long[] operands) {
        int pred = stack.pop().asInt();
        Value b = stack.pop();
        Value a = stack.pop();
        if (pred == 0) {
            stack.push(b);
        } else {
            stack.push(a);
        }
    }

    private static void CALL_INDIRECT(MStack stack, Instance instance, ArrayDeque<StackFrame> callStack, long[] operands) {
        int tableIdx = (int)operands[1];
        TableInstance table = instance.table(tableIdx);
        int typeId = (int)operands[0];
        int funcTableIdx = stack.pop().asInt();
        int funcId = table.ref(funcTableIdx).asFuncRef();
        Instance tableInstance = table.instance(funcTableIdx);
        if (tableInstance != null) {
            instance = tableInstance;
        }
        if (funcId == -1) {
            throw new ChicoryException("uninitialized element " + funcTableIdx);
        }
        FunctionType type = instance.type(typeId);
        Value[] args = InterpreterMachine.extractArgsForParams(stack, type.params());
        InterpreterMachine.call(stack, instance, callStack, funcId, args, type, false);
    }

    private static void BLOCK(StackFrame frame, MStack stack) {
        frame.isControlFrame = true;
        frame.registerStackSize(stack);
    }

    private static int numberOfValuesToReturn(Instance instance, Instruction scope) {
        if (scope.opcode() == OpCode.END) {
            return 0;
        }
        int typeId = (int)scope.operands()[0];
        if (typeId == 64) {
            return 0;
        }
        if (ValueType.isValid((int)typeId)) {
            return 1;
        }
        return instance.type(typeId).returns().size();
    }

    private static void IF(StackFrame frame, MStack stack, Instruction instruction) {
        frame.isControlFrame = false;
        frame.registerStackSize(stack);
        Value predValue = stack.pop();
        frame.jumpTo(predValue.asInt() == 0 ? instruction.labelFalse() : instruction.labelTrue());
    }

    private static void BR_TABLE(StackFrame frame, MStack stack, Instruction instruction) {
        Value predValue = InterpreterMachine.prepareControlTransfer(frame, stack, true);
        int pred = predValue.asInt();
        if (pred < 0 || pred >= instruction.labelTable().length - 1) {
            frame.jumpTo(instruction.labelTable()[instruction.labelTable().length - 1]);
        } else {
            frame.jumpTo(instruction.labelTable()[pred]);
        }
    }

    private static void BR_IF(StackFrame frame, MStack stack, Instruction instruction) {
        Value predValue = InterpreterMachine.prepareControlTransfer(frame, stack, true);
        int pred = predValue.asInt();
        if (pred == 0) {
            frame.jumpTo(instruction.labelFalse());
        } else {
            frame.jumpTo(instruction.labelTrue());
        }
    }

    private static Value prepareControlTransfer(StackFrame frame, MStack stack, boolean consume) {
        frame.doControlTransfer = true;
        frame.isControlFrame = true;
        return consume ? stack.pop() : null;
    }

    private static void doControlTransfer(Instance instance, MStack stack, StackFrame frame, Instruction scope) {
        int i;
        frame.doControlTransfer = false;
        Value[] returns = new Value[InterpreterMachine.numberOfValuesToReturn(instance, scope)];
        for (i = 0; i < returns.length; ++i) {
            if (stack.size() <= 0) continue;
            returns[i] = stack.pop();
        }
        frame.dropValuesOutOfBlock(stack);
        for (i = 0; i < returns.length; ++i) {
            Value value = returns[returns.length - 1 - i];
            if (value == null) continue;
            stack.push(value);
        }
    }

    @Override
    public List<StackFrame> getStackTrace() {
        return List.copyOf(this.callStack);
    }

    static Value[] extractArgsForParams(MStack stack, List<ValueType> params) {
        if (params == null) {
            return Value.EMPTY_VALUES;
        }
        Value[] args = new Value[params.size()];
        for (int i = params.size(); i > 0; --i) {
            Value p = stack.pop();
            ValueType t = params.get(i - 1);
            if (p.type() != t) {
                switch (t) {
                    case I32: 
                    case I64: 
                    case F32: 
                    case F64: {
                        p = new Value(t, p.asLong());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Type error when extracting args. Found: " + t);
                    }
                }
            }
            args[i - 1] = p;
        }
        return args;
    }

    protected static void verifyIndirectCall(FunctionType actual, FunctionType expected) throws ChicoryException {
        if (!actual.typesMatch(expected)) {
            throw new ChicoryException("indirect call type mismatch");
        }
    }

    private static void checkInterruption() {
        if (Thread.currentThread().isInterrupted()) {
            throw new ChicoryException("Thread interrupted");
        }
    }
}

