/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ExecutionListener;
import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.GlobalInstance;
import com.dylibso.chicory.runtime.HostImports;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.runtime.TableInstance;
import com.dylibso.chicory.runtime.exceptions.WASMMachineException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;
import java.util.List;

public class Instance {
    private final Module module;
    private final Machine machine;
    private final FunctionBody[] functions;
    private final Memory memory;
    private final DataSegment[] dataSegments;
    private final Global[] globalInitializers;
    private final GlobalInstance[] globals;
    private final int importedGlobalsOffset;
    private final int importedFunctionsOffset;
    private final int importedTablesOffset;
    private final FunctionType[] types;
    private final int[] functionTypes;
    private final HostImports imports;
    private final Table[] roughTables;
    private TableInstance[] tables;
    private final Element[] elements;
    private final boolean start;
    private final ExecutionListener listener;

    public Instance(Module module, Global[] globalInitializers, int importedGlobalsOffset, int importedFunctionsOffset, int importedTablesOffset, Memory memory, DataSegment[] dataSegments, FunctionBody[] functions, FunctionType[] types, int[] functionTypes, HostImports imports, Table[] tables, Element[] elements, boolean initialize, boolean start, ExecutionListener listener) {
        this.module = module;
        this.globalInitializers = (Global[])globalInitializers.clone();
        this.globals = new GlobalInstance[globalInitializers.length + importedGlobalsOffset];
        this.importedGlobalsOffset = importedGlobalsOffset;
        this.importedFunctionsOffset = importedFunctionsOffset;
        this.importedTablesOffset = importedTablesOffset;
        this.memory = memory;
        this.dataSegments = dataSegments;
        this.functions = (FunctionBody[])functions.clone();
        this.types = (FunctionType[])types.clone();
        this.functionTypes = (int[])functionTypes.clone();
        this.imports = imports;
        this.machine = new Machine(this);
        this.roughTables = (Table[])tables.clone();
        this.elements = (Element[])elements.clone();
        this.start = start;
        this.listener = listener;
        if (initialize) {
            this.initialize(this.start);
        }
    }

    public Instance initialize(boolean start) {
        this.tables = new TableInstance[this.roughTables.length];
        for (int i = 0; i < this.roughTables.length; ++i) {
            this.tables[i] = new TableInstance(this.roughTables[i]);
        }
        for (Element el : this.elements) {
            if (!(el instanceof ActiveElement)) continue;
            ActiveElement ae = (ActiveElement)el;
            TableInstance table = this.table(ae.tableIndex());
            Value offset = Machine.computeConstantValue(this, ae.offset());
            if (offset.type() != ValueType.I32) {
                throw new ChicoryException("Invalid offset type in element");
            }
            List initializers = ae.initializers();
            for (int i = 0; i < initializers.size(); ++i) {
                List init = (List)initializers.get(i);
                int index = offset.asInt() + i;
                Value value = Machine.computeConstantValue(this, init);
                Instance inst = Machine.computeConstantInstance(this, init);
                if (ae.type() == ValueType.FuncRef) {
                    table.setRef(index, value.asFuncRef(), inst);
                    continue;
                }
                assert (ae.type() == ValueType.ExternRef);
                table.setRef(index, value.asExtRef(), inst);
            }
        }
        for (int i = 0; i < this.globalInitializers.length; ++i) {
            Global g = this.globalInitializers[i];
            if (g.initInstructions().size() > 2) {
                throw new RuntimeException("We don't support a global initializer with multiple instructions");
            }
            Instruction instr = (Instruction)g.initInstructions().get(0);
            switch (instr.opcode()) {
                case I32_CONST: {
                    this.globals[i] = new GlobalInstance(Value.i32((long)instr.operands()[0]));
                    break;
                }
                case I64_CONST: {
                    this.globals[i] = new GlobalInstance(Value.i64((long)instr.operands()[0]));
                    break;
                }
                case F32_CONST: {
                    this.globals[i] = new GlobalInstance(Value.f32((long)instr.operands()[0]));
                    break;
                }
                case F64_CONST: {
                    this.globals[i] = new GlobalInstance(Value.f64((long)instr.operands()[0]));
                    break;
                }
                case GLOBAL_GET: {
                    int idx = (int)instr.operands()[0];
                    this.globals[i] = idx < this.imports.globalCount() ? this.imports.global(idx).instance() : this.globals[idx];
                    break;
                }
                case REF_NULL: {
                    this.globals[i] = new GlobalInstance(Value.EXTREF_NULL);
                    break;
                }
                case REF_FUNC: {
                    this.globals[i] = new GlobalInstance(Value.funcRef((long)instr.operands()[0]));
                    break;
                }
                default: {
                    throw new RuntimeException("We only support i32.const, i64.const, f32.const, f64.const, global.get, ref.func and ref.null opcodes on global initializers right now. We failed to initialize opcode: " + instr.opcode());
                }
            }
            this.globals[i].setInstance(this);
        }
        if (this.memory != null) {
            this.memory.initialize(this, this.dataSegments);
        } else if (this.imports.memories().length > 0) {
            this.imports.memories()[0].memory().initialize(this, this.dataSegments);
        }
        if (start && this.module.export("_start") != null) {
            this.export("_start").apply(new Value[0]);
        }
        return this;
    }

    public ExportFunction export(String name) {
        final Export export = this.module.export(name);
        if (export == null) {
            throw new ChicoryException("Unknown export with name " + name);
        }
        switch (export.exportType()) {
            case FUNCTION: {
                int funcId = export.index();
                return args -> {
                    this.module.logger().debug(() -> "Args: " + Arrays.toString(args));
                    try {
                        return this.machine.call(funcId, args, true);
                    }
                    catch (Exception e) {
                        throw new WASMMachineException(this.machine.getStackTrace(), e);
                    }
                };
            }
            case GLOBAL: {
                return new ExportFunction(){

                    @Override
                    public Value[] apply(Value ... args) throws ChicoryException {
                        assert (args.length == 0);
                        return new Value[]{Instance.this.readGlobal(export.index())};
                    }
                };
            }
        }
        throw new ChicoryException("not implemented");
    }

    public FunctionBody function(int idx) {
        if (idx < this.importedFunctionsOffset) {
            return null;
        }
        return this.functions[idx - this.importedFunctionsOffset];
    }

    public int functionCount() {
        return this.importedFunctionsOffset + this.functions.length;
    }

    public Memory memory() {
        return this.memory;
    }

    public GlobalInstance global(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return this.imports.global(idx).instance();
        }
        return this.globals[idx - this.importedGlobalsOffset];
    }

    public void writeGlobal(int idx, Value val) {
        if (idx < this.importedGlobalsOffset) {
            this.imports.global(idx).instance().setValue(val);
        }
        this.globals[idx - this.importedGlobalsOffset].setValue(val);
    }

    public Value readGlobal(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return this.imports.global(idx).instance().getValue();
        }
        return this.globals[idx - this.importedGlobalsOffset].getValue();
    }

    public Global globalInitializer(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return null;
        }
        return this.globalInitializers[idx - this.importedGlobalsOffset];
    }

    public int globalCount() {
        return this.globals.length;
    }

    public FunctionType type(int idx) {
        return this.types[idx];
    }

    public int functionType(int idx) {
        return this.functionTypes[idx];
    }

    public HostImports imports() {
        return this.imports;
    }

    public Module module() {
        return this.module;
    }

    public int importedTableCount() {
        return this.importedTablesOffset;
    }

    public TableInstance table(int idx) {
        if (idx < this.importedTablesOffset) {
            return this.imports.table(idx).table();
        }
        return this.tables[idx - this.importedTablesOffset];
    }

    public Element element(int idx) {
        return this.elements[idx];
    }

    public int elementCount() {
        return this.elements.length;
    }

    public void setElement(int idx, Element val) {
        this.elements[idx] = val;
    }

    public void onExecution(Instruction instruction, long[] operands, MStack stack) {
        if (this.listener != null) {
            this.listener.onExecution(instruction, operands, stack);
        }
    }
}

