/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.HostGlobal;
import com.dylibso.chicory.runtime.HostMemory;
import com.dylibso.chicory.runtime.HostTable;

public class HostImports {
    private static final HostFunction[] NO_HOST_FUNCTIONS = new HostFunction[0];
    private static final HostGlobal[] NO_HOST_GLOBALS = new HostGlobal[0];
    private static final HostMemory[] NO_HOST_MEMORIES = new HostMemory[0];
    private static final HostTable[] NO_HOST_TABLES = new HostTable[0];
    private final HostFunction[] functions;
    private final HostGlobal[] globals;
    private final HostMemory[] memories;
    private final HostTable[] tables;
    private FromHost[] index;

    public HostImports() {
        this.functions = NO_HOST_FUNCTIONS;
        this.globals = NO_HOST_GLOBALS;
        this.memories = NO_HOST_MEMORIES;
        this.tables = NO_HOST_TABLES;
    }

    public HostImports(HostFunction[] functions) {
        this.functions = (HostFunction[])functions.clone();
        this.globals = NO_HOST_GLOBALS;
        this.memories = NO_HOST_MEMORIES;
        this.tables = NO_HOST_TABLES;
    }

    public HostImports(HostGlobal[] globals) {
        this.functions = NO_HOST_FUNCTIONS;
        this.globals = (HostGlobal[])globals.clone();
        this.memories = NO_HOST_MEMORIES;
        this.tables = NO_HOST_TABLES;
    }

    public HostImports(HostMemory[] memories) {
        this.functions = NO_HOST_FUNCTIONS;
        this.globals = NO_HOST_GLOBALS;
        this.memories = (HostMemory[])memories.clone();
        this.tables = NO_HOST_TABLES;
    }

    public HostImports(HostMemory memory) {
        this.functions = NO_HOST_FUNCTIONS;
        this.globals = NO_HOST_GLOBALS;
        this.memories = new HostMemory[]{memory};
        this.tables = NO_HOST_TABLES;
    }

    public HostImports(HostTable[] tables) {
        this.functions = NO_HOST_FUNCTIONS;
        this.globals = NO_HOST_GLOBALS;
        this.memories = NO_HOST_MEMORIES;
        this.tables = (HostTable[])tables.clone();
    }

    public HostImports(HostFunction[] functions, HostGlobal[] globals, HostMemory memory, HostTable[] tables) {
        this.functions = (HostFunction[])functions.clone();
        this.globals = (HostGlobal[])globals.clone();
        this.memories = new HostMemory[]{memory};
        this.tables = (HostTable[])tables.clone();
    }

    public HostImports(HostFunction[] functions, HostGlobal[] globals, HostMemory[] memories, HostTable[] tables) {
        this.functions = (HostFunction[])functions.clone();
        this.globals = (HostGlobal[])globals.clone();
        this.memories = (HostMemory[])memories.clone();
        this.tables = (HostTable[])tables.clone();
    }

    public HostFunction[] functions() {
        return (HostFunction[])this.functions.clone();
    }

    public int functionCount() {
        return this.functions.length;
    }

    public HostFunction function(int idx) {
        return this.functions[idx];
    }

    public HostGlobal[] globals() {
        return this.globals;
    }

    public int globalCount() {
        return this.globals.length;
    }

    public HostGlobal global(int idx) {
        return this.globals[idx];
    }

    public HostMemory[] memories() {
        return this.memories;
    }

    public int memoryCount() {
        return this.memories.length;
    }

    public HostMemory memory(int idx) {
        return this.memories[idx];
    }

    public HostTable[] tables() {
        return this.tables;
    }

    public int tableCount() {
        return this.tables.length;
    }

    public HostTable table(int idx) {
        return this.tables[idx];
    }

    public FromHost[] index() {
        return this.index;
    }

    public void setIndex(FromHost[] index) {
        this.index = index;
    }
}

