/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity.client;

import com.duosecurity.client.Base64;
import com.duosecurity.client.Util;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.CertificatePinner;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class Http {
    public static final int BACKOFF_FACTOR = 2;
    public static final int INITIAL_BACKOFF_MS = 1000;
    public static final int MAX_BACKOFF_MS = 32000;
    public static final int DEFAULT_TIMEOUT_SECS = 60;
    private static final int RATE_LIMIT_ERROR_CODE = 429;
    public static final String UserAgentString = "Duo API Java/0.6.0";
    private final String method;
    private final String host;
    private final String uri;
    private final String signingAlgorithm = "HmacSHA512";
    private final String hashingAlgorithm = "SHA-512";
    private Headers.Builder headers;
    private SortedMap<String, Object> params = new TreeMap<String, Object>();
    protected int sigVersion = 2;
    private Random random = new Random();
    private OkHttpClient httpClient;
    private SortedMap<String, String> additionalDuoHeaders = new TreeMap<String, String>();
    public static SimpleDateFormat RFC_2822_DATE_FORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    public static MediaType FORM_ENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    public static MediaType JSON_ENCODED = MediaType.parse((String)"application/json");
    private static final String[] DEFAULT_CA_CERTS = new String[]{"sha256/I/Lt/z7ekCWanjD0Cvj5EqXls2lOaThEA0H2Bg4BT/o=", "sha256/r/mIkG3eEpVdm+u/ko/cwxzOMo1bk4TyHIlByibiA5E=", "sha256/WoiWRyIOVNa9ihaBciRSC7XHjliYS9VwUGOIud4PB18=", "sha256/dykHF2FLJfEpZOvbOLX4PKrcD2w2sHd/iA/G3uHTOcw=", "sha256/JZaQTcTWma4gws703OR/KFk313RkrDcHRvUt6na6DCg=", "sha256/++MBgDH5WGvL9Bcn5Be30cRcL0f5O+NyoXuWtQdX1aI=", "sha256/f0KW/FtqTjs108NpYj42SrGvOB2PpxIVM8nWxjPqJGE=", "sha256/NqvDJlas/GRcYbcWE8S/IceH9cq77kg0jVhZeAPXq8k=", "sha256/9+ze1cZgR9KO1kZrVDxA4HQ6voHRCSVNz4RdTCx4U8U=", "sha256/j9ESw8g3DxR9XM06fYZeuN1UB4O6xp/GAIjjdD/zM3g="};

    public Http(String inMethod, String inHost, String inUri) {
        this(inMethod, inHost, inUri, 60);
    }

    protected Http(String inMethod, String inHost, String inUri, int timeout) {
        this.method = inMethod.toUpperCase();
        this.host = inHost;
        this.uri = inUri;
        this.headers = new Headers.Builder();
        this.headers.add("Host", this.host);
        this.headers.add("user-agent", UserAgentString);
        CertificatePinner pinner = Util.createPinner(this.host, DEFAULT_CA_CERTS);
        this.httpClient = new OkHttpClient.Builder().connectTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).certificatePinner(pinner).build();
    }

    public Object executeJSONRequest() throws Exception {
        JSONObject result = new JSONObject(this.executeRequestRaw());
        if (!result.getString("stat").equals("OK")) {
            throw new Exception("Duo error code (" + result.getInt("code") + "): " + result.getString("message"));
        }
        return result;
    }

    public String executeRequestRaw() throws Exception {
        Response response = this.executeHttpRequest();
        return response.body().string();
    }

    public Response executeHttpRequest() throws Exception {
        Object requestBody;
        String url = "https://" + this.host + this.uri;
        String queryString = this.canonQueryString();
        String jsonBody = this.canonJSONBody();
        if (this.sigVersion == 1 || this.sigVersion == 2) {
            requestBody = RequestBody.create((String)queryString, (MediaType)FORM_ENCODED);
        } else if (this.sigVersion == 5) {
            requestBody = "POST".equals(this.method) || "PUT".equals(this.method) ? RequestBody.create((String)jsonBody, (MediaType)JSON_ENCODED) : null;
        } else {
            throw new UnsupportedOperationException("Unsupported signature version: " + this.sigVersion);
        }
        Request.Builder requestBuilder = new Request.Builder();
        if (this.method.equals("POST")) {
            requestBuilder.post(requestBody);
        } else if (this.method.equals("PUT")) {
            requestBuilder.put(requestBody);
        } else if (this.method.equals("GET")) {
            if (queryString.length() > 0) {
                url = url + "?" + queryString;
            }
            requestBuilder.get();
        } else if (this.method.equals("DELETE")) {
            if (queryString.length() > 0) {
                url = url + "?" + queryString;
            }
            requestBuilder.delete();
        } else {
            throw new UnsupportedOperationException("Unsupported method: " + this.method);
        }
        Request request = requestBuilder.headers(this.headers.build()).url(url).build();
        return this.executeRequest(request);
    }

    public Object executeRequest() throws Exception {
        JSONObject result = (JSONObject)this.executeJSONRequest();
        return result.get("response");
    }

    private Response executeRequest(Request request) throws Exception {
        long backoffMs = 1000L;
        Response response;
        while ((response = this.httpClient.newCall(request).execute()).code() == 429 && backoffMs <= 32000L) {
            this.sleep(backoffMs + (long)this.nextRandomInt(1000));
            backoffMs *= 2L;
        }
        return response;
    }

    protected void sleep(long ms) throws Exception {
        Thread.sleep(ms);
    }

    public void signRequest(String ikey, String skey) throws UnsupportedEncodingException {
        this.signRequest(ikey, skey, this.sigVersion);
    }

    public void signRequest(String ikey, String skey, int inSigVersion) throws UnsupportedEncodingException {
        int[] availableSigVersion = new int[]{1, 2, 5};
        if (Arrays.stream(availableSigVersion).anyMatch(i -> i == inSigVersion)) {
            this.sigVersion = inSigVersion;
        }
        String date = this.formatDate(new Date());
        String canon = this.canonRequest(date, this.sigVersion);
        String sig = this.signHMAC(skey, canon);
        String auth = ikey + ":" + sig;
        String header = "Basic " + Base64.encodeBytes(auth.getBytes());
        this.addHeader("Authorization", header);
        if (this.sigVersion == 2 || this.sigVersion == 5) {
            this.addHeader("Date", date);
        }
    }

    protected String signHMAC(String skey, String msg) {
        try {
            byte[] sigBytes = Util.hmac("HmacSHA512", skey.getBytes(), msg.getBytes());
            String sig = Util.bytes_to_hex(sigBytes);
            return sig;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = RFC_2822_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return RFC_2822_DATE_FORMAT.format(date);
        }
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    public void addParam(String name, String value) {
        this.params.put(name, value);
    }

    public void addParam(String name, Integer value) {
        this.params.put(name, value);
    }

    public void addParam(String name, JSONObject value) {
        this.params.put(name, value);
    }

    public void addParam(String name, List<Object> value) {
        this.params.put(name, value);
    }

    public void addAdditionalDuoHeader(Map<String, String> inAdditionalDuoHeaders) {
        this.additionalDuoHeaders.putAll(inAdditionalDuoHeaders);
    }

    public void setProxy(String host, int port) {
        Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        this.httpClient = this.httpClient.newBuilder().proxy(httpProxy).build();
    }

    public void useCustomCertificates(String[] customCaCerts) {
        CertificatePinner pinner = Util.createPinner(this.host, customCaCerts);
        this.httpClient = this.httpClient.newBuilder().certificatePinner(pinner).build();
    }

    protected String canonRequest(String date, int sigVersion) throws UnsupportedEncodingException {
        String canon = "";
        if (sigVersion == 1) {
            canon = canon + this.method.toUpperCase() + System.lineSeparator();
            canon = canon + this.host.toLowerCase() + System.lineSeparator();
            canon = canon + this.uri + System.lineSeparator();
            canon = canon + this.canonQueryString();
        } else if (sigVersion == 2) {
            canon = canon + date + System.lineSeparator();
            canon = canon + this.method.toUpperCase() + System.lineSeparator();
            canon = canon + this.host.toLowerCase() + System.lineSeparator();
            canon = canon + this.uri + System.lineSeparator();
            canon = canon + this.canonQueryString();
        } else if (sigVersion == 5) {
            String canonBody;
            String canonParam;
            canon = canon + date + System.lineSeparator();
            canon = canon + this.method.toUpperCase() + System.lineSeparator();
            canon = canon + this.host.toLowerCase() + System.lineSeparator();
            canon = canon + this.uri + System.lineSeparator();
            if ("POST".equals(this.method) || "PUT".equals(this.method)) {
                canonParam = System.lineSeparator();
                canonBody = Util.bytes_to_hex(Util.hash("SHA-512", this.canonJSONBody()));
            } else {
                canonParam = this.canonQueryString() + System.lineSeparator();
                canonBody = Util.bytes_to_hex(Util.hash("SHA-512", ""));
            }
            canon = canon + canonParam;
            canon = canon + canonBody + System.lineSeparator();
            canon = canon + Util.bytes_to_hex(Util.hash("SHA-512", this.canonXDuoHeaders()));
        }
        return canon;
    }

    private String canonQueryString() throws UnsupportedEncodingException {
        ArrayList<String> args = new ArrayList<String>();
        for (String key : this.params.keySet()) {
            String name = URLEncoder.encode(key, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String value = URLEncoder.encode(this.params.get(key).toString(), "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            args.add(name + "=" + value);
        }
        return Util.join(args.toArray(), "&");
    }

    private String canonJSONBody() {
        JSONObject jsonBody = new JSONObject(this.params);
        return jsonBody.toString();
    }

    private String canonXDuoHeaders() {
        ArrayList<String> canonList = new ArrayList<String>();
        for (String name : this.additionalDuoHeaders.keySet()) {
            String value = (String)this.additionalDuoHeaders.get(name);
            canonList.add(name + '\u0000' + value);
            this.headers.add(name, value);
        }
        return Util.join(canonList.toArray(), String.valueOf('\u0000'));
    }

    public int nextRandomInt(int bound) {
        return this.random.nextInt(bound);
    }

    protected static abstract class ClientBuilder<T extends Http> {
        private final String method;
        private final String host;
        private final String uri;
        private int timeout = 60;
        private String[] caCerts = null;
        private SortedMap<String, String> additionalDuoHeaders = new TreeMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();

        public ClientBuilder(String method, String host, String uri) {
            this.method = method;
            this.host = host;
            this.uri = uri;
        }

        public ClientBuilder<T> useTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ClientBuilder<T> useCustomCertificates(String[] customCaCerts) {
            this.caCerts = customCaCerts;
            return this;
        }

        public ClientBuilder<T> addAdditionalDuoHeader(String name, String value) throws IllegalArgumentException {
            this.validateXDuoHeader(name, value);
            this.additionalDuoHeaders.put(name.toLowerCase(), value);
            return this;
        }

        public ClientBuilder<T> addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public T build() {
            T duoClient = this.createClient(this.method, this.host, this.uri, this.timeout);
            if (this.caCerts != null) {
                ((Http)duoClient).useCustomCertificates(this.caCerts);
            }
            if (this.additionalDuoHeaders != null) {
                ((Http)duoClient).addAdditionalDuoHeader(this.additionalDuoHeaders);
            }
            if (this.headers != null) {
                for (String name : this.headers.keySet()) {
                    String value = this.headers.get(name);
                    ((Http)duoClient).addHeader(name, value);
                }
            }
            return duoClient;
        }

        protected abstract T createClient(String var1, String var2, String var3, int var4);

        private void validateXDuoHeader(String name, String value) throws IllegalArgumentException {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("Not allowed 'Null' or empty header name");
            }
            if (value == null || value.length() == 0) {
                throw new IllegalArgumentException("Not allowed 'Null' or empty header value");
            }
            if (!name.toLowerCase().startsWith("x-duo-")) {
                throw new IllegalArgumentException("Additional headers must start with 'X-Duo-'");
            }
            if (this.additionalDuoHeaders.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate header passed, header=" + name);
            }
        }
    }

    public static class HttpBuilder
    extends ClientBuilder<Http> {
        protected HttpBuilder(String method, String host, String uri) {
            super(method, host, uri);
        }

        @Override
        protected Http createClient(String method, String host, String uri, int timeout) {
            return new Http(method, host, uri, timeout);
        }
    }
}

