/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum Types {
    PRIMITIVE,
    ARRAY,
    MAP,
    OBJECT,
    ENUM;

    private static final Set<Class<?>> PRIMITIVE_TYPES;

    public static Types getType(Class<?> clazz) {
        if (clazz.isArray() || List.class.isAssignableFrom(clazz)) {
            return ARRAY;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MAP;
        }
        if (clazz.isEnum()) {
            return ENUM;
        }
        if (Types.isPrimitiveWrapperTypes(clazz) || clazz.isPrimitive() || String.class.isAssignableFrom(clazz)) {
            return PRIMITIVE;
        }
        return OBJECT;
    }

    private static boolean isPrimitiveWrapperTypes(Class<?> clazz) {
        return PRIMITIVE_TYPES.contains(clazz);
    }

    private static Set<Class<?>> getPrimitiveWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        return ret;
    }

    static {
        PRIMITIVE_TYPES = Types.getPrimitiveWrapperTypes();
    }
}

